/*
 * Decompiled with CFR 0.152.
 */
package com.glaivestone.toolbox.text.csv;

import java.util.ArrayList;
import java.util.List;

public class CSVParser {
    protected static final int NOT_FOUND_INDEX = -1;
    protected String separator;
    protected char stringDelimiterChar;
    protected String csvString;
    protected int nChars;
    protected List<String> values;

    public CSVParser() {
        this(",", '\"');
    }

    public CSVParser(String aSeparator, char stringDelimiter) {
        this.setSeparator(aSeparator);
        this.setDelimiter(stringDelimiter);
    }

    public String[] getStringValues(String aString) {
        List<String> stringList = this.getValues(aString);
        return stringList.toArray(new String[stringList.size()]);
    }

    public List<String> getValues(String aString) {
        this.csvString = aString;
        this.nChars = this.csvString == null ? 0 : this.csvString.length();
        this.parse();
        return this.values;
    }

    protected boolean isWhitespaceChar(int index) {
        char aChar = this.csvString.charAt(index);
        return Character.isSpaceChar(aChar) || aChar == '\t';
    }

    protected void parse() {
        String trimmedString;
        this.values = new ArrayList<String>();
        String string = trimmedString = this.csvString == null ? "" : this.csvString.trim();
        if (trimmedString.length() == 0) {
            return;
        }
        int pos = 0;
        while (pos != -1) {
            pos = this.parseNextValue(pos);
        }
        if (trimmedString.endsWith(this.separator)) {
            this.storeValue("");
        }
    }

    protected int parseDelimitedValue(int startIndex) {
        char delimiter = this.csvString.charAt(startIndex);
        int nChars = this.csvString.length();
        int pos = startIndex + 1;
        StringBuffer tokenBuffer = new StringBuffer();
        while (true) {
            int stopIndex;
            if ((stopIndex = this.csvString.indexOf(delimiter, pos)) == -1) {
                tokenBuffer.append(this.csvString.substring(pos, nChars));
                this.storeValue(tokenBuffer.toString());
                return nChars;
            }
            tokenBuffer.append(this.csvString.substring(pos, stopIndex));
            if (pos >= nChars - 1 || this.csvString.charAt(pos) != delimiter) {
                this.storeValue(tokenBuffer.toString());
                for (pos = stopIndex + 1; pos < nChars && this.isWhitespaceChar(pos); ++pos) {
                }
                if (pos < nChars && this.csvString.charAt(pos) == this.separator.charAt(0)) {
                    ++pos;
                }
                return pos;
            }
            tokenBuffer.append(delimiter);
            ++pos;
        }
    }

    protected int parseNextValue(int startIndex) {
        int pos;
        for (pos = startIndex; pos < this.nChars && this.isWhitespaceChar(pos); ++pos) {
        }
        if (pos >= this.nChars) {
            return -1;
        }
        if (this.csvString.charAt(pos) == this.stringDelimiterChar) {
            return this.parseDelimitedValue(pos);
        }
        return this.parseSimpleValue(pos);
    }

    protected int parseSimpleValue(int startIndex) {
        int separatorIndex = this.csvString.indexOf(this.separator, startIndex);
        if (separatorIndex < 0) {
            separatorIndex = this.csvString.length();
        }
        int stopIndex = separatorIndex;
        this.storeValue(this.csvString.substring(startIndex, stopIndex).trim());
        return separatorIndex + 1;
    }

    public void setSeparator(String aSeparator) {
        this.separator = aSeparator;
    }

    public void setDelimiter(char stringDelimiter) {
        this.stringDelimiterChar = stringDelimiter;
    }

    protected void storeValue(String aValue) {
        this.values.add(aValue);
    }
}

