'==============================================================================
'
' VBScript Source File
'
' NAME: CreateACESShortcut.vbs
'
' AUTHOR: D. J. Lewis
' DATE  : 22-Jan-2003
'
' COMMENT: Create a desktop shortcut to launch ACE Scoring. 
'
' REFERENCES:
'    MSDN Library: Scripting>Windows Script Technologies>Windows Script Host>Basic Windows Script Host Tasks>Managing Shortcuts
'    http://msdn.microsoft.com/library/default.asp?url=/library/en-us/script56/html/wsconcreatingshortcut.asp
'
'==============================================================================

DEBUGGING = False

'==============================================================================
' CONSTANTS
Const JAVA_HOME_VAR_NAME = "JAVA_HOME"
Const JAVA_EXE_RELATIVE_PATH = "bin\javaw.exe"
Const JAVA_HOME_EXE_PATH = "%JAVA_HOME%\bin\javaw.exe"
	'Actually: "%" & JAVA_HOME_VAR_NAME & "%\" & JAVA_EXE_RELATIVE_PATH

Const ACES_SHORTCUT_NAME = "ACE Scoring"
Const DEFAULT_ACES_PATH = "c:\ACEScoring"
Const ACES_PROGFILES_DIR_NAME = "ProgramFiles"
Const ACES_JAR_RELATIVE_PATH = "lib\aces.jar"

'==============================================================================
' GLOBALS
Dim gobjShell, gobjFSO
Dim gstrDesktopPath

set gobjShell = WScript.CreateObject("Wscript.Shell")
set gobjFSO = CreateObject("Scripting.FileSystemObject")

gstrDesktopPath = gobjShell.SpecialFolders("Desktop")


'==============================================================================
' Create a shortcut on the desktop
'==============================================================================

Function createDesktopShortcut( strName, strTarget, strArgs, strWorkingDirPath, strDescription, strIconPath )

	strShortcutPath = gstrDesktopPath & "\" & strName & ".lnk"

	If gobjFSO.FileExists(strShortcutPath) Then
		MsgBox "You already have a shortcut named '" & strName & "' on your desktop.", vbOKOnly + vbInformation, "Shortcut Already Defined"
		Exit Function
	End If

	If DEBUGGING Then
		MsgBox("Creating desktop shortcut '" & strName & "' - launch " & strTarget & ", start in " & strWorkingDirPath )
	End If

	set link = gobjShell.CreateShortcut( strShortcutPath )

	link.TargetPath = strTarget
	link.Arguments = strArgs
	link.WorkingDirectory = strWorkingDirPath

	link.Description = strDescription
	link.IconLocation = strIconPath
	link.WindowStyle = 1  ' activate and display (normal size)
	'??? link.HotKey = "CTRL+ALT+SHIFT+X"

	link.Save

	If DEBUGGING Then
		MsgBox( "Desktop shortcut created" )
	End If

End Function 'createDesktopShortcut


'==============================================================================
' Delete a shortcut from the desktop
'==============================================================================

Function deleteDesktopShortcut( strName )

	strShortcutPath = gstrDesktopPath & "\" & strName & ".lnk"

	If gobjFSO.FileExists(strShortcutPath) Then
		Exit Function
	End If

	If DEBUGGING Then
		MsgBox("Deleting link '" & strName )
	End If

	gobjFSO.DeleteFile strShortcutPath

	If DEBUGGING Then
		MsgBox( "Desktop shortcut deleted" )
	End If

End Function 'deleteDesktopShortcut


'==============================================================================
' Create a shortcut to launch ACE Scoring
'==============================================================================

Function createACESShortcut( strName )

	strACESDirPath = getACESPath()

	strTarget = getJavaExePath( strACESDirPath )
	strArgs = "-jar " & ACES_JAR_RELATIVE_PATH
	strWorkingDirPath = strACESDirPath & "\" & ACES_PROGFILES_DIR_NAME

	strDescription = "Launch ACE Scoring"
	strIconPath = strACESDirPath & "\ProgramFiles\ACEScoring.ico"
	'??strHotKey= "CTRL+ALT+SHIFT+X"??

	createDesktopShortcut strName, strTarget, strArgs, strWorkingDirPath, strDescription, strIconPath

End Function 'createACESShortcut


'==============================================================================
' Get the path of the ACEScoring installation directory
'==============================================================================

Function getACESPath()

	strScriptFileName = WScript.ScriptName
	strScriptPathName = WScript.ScriptFullName
	strACESDirPath = Left( strScriptPathName, Len(strScriptPathName) - Len(strScriptFileName) - 1 )

	If LCase(strACESDirPath) <> LCase(DEFAULT_ACES_PATH) Then
		strMessage = "You are about to create a shortcut to launch ACE Scoring from:" & vbNewLine & vbNewLine & "    " & strACESDirPath & vbNewLine & vbNewline & "The standard location for the ACE Scoring installation directory is: " & vbNewLine & vbNewLine & "    " & DEFAULT_ACES_PATH & vbNewLine & vbNewLine & "Is this indeed the location of your ACEScoring installation directory?"
		intAnswer = MsgBox(strMessage, vbYesNoCancel+vbQuestion, "Please Confirm")
		If intAnswer = vbCancel Then
			MsgBox "ACE Scoring shortcut creation cancelled", vbOkOnly+vbInformation, "Operation Cancelled"
			WScript.Quit
		End If
		If intAnswer = vbNo Then
			'###TO DO: use File dialog to get path from user ###
			MsgBox "Getting ACE Scoring installation directory path from user is not yet supported", vbOkOnly+vbCritical, "Not Yet Implemented"
			WScript.Quit
		End If
	End IF

	' Validate the path to ensure we're really at ACEScoring
	strProgFilesDirPath = strACESDirPath & "\" & ACES_PROGFILES_DIR_NAME
	strJarFilePath = strProgFilesDirPath & "\" & ACES_JAR_RELATIVE_PATH
	If NOT gobjFSO.FolderExists(strProgFilesDirPath) Then
		MsgBox "Invalid ACEScoring installation directory - required directory not found:" & vbNewLine & vbNewLine & "    " & strProgFilesDirPath, vbOkOnly+vbCritical, "ACE Scoring Shortcut Creation Failed"
		WScript.Quit
	End If
	If NOT gobjFSO.FileExists(strJarFilePath) Then
		MsgBox "Invalid ACEScoring installation directory - required file not found:" & vbNewLine & vbNewLine & "    " & strJarFilePath, vbOkOnly+vbCritical, "ACE Scoring Shortcut Creation Failed"
		WScript.Quit
	End If

	getACESPath = strACESDirPath

End Function 'getACESPath


'==============================================================================
' Get the path of the Java VM
'==============================================================================

Function getJavaExePath( strACESDirPath )

	strInternalVMPath = strACESDirPath & "\jre\" & JAVA_EXE_RELATIVE_PATH

	' reference JRE in self-contained ACES installation if there, else JAVA_HOME env var
	strJavaExePath = strInternalVMPath
	If NOT gobjFSO.FileExists(strJavaExePath) Then
		call validateJavaConfiguration()
		strJavaExePath = JAVA_HOME_EXE_PATH
	End If

	If DEBUGGING Then
		MsgBox("Checking for internal JRE VM at '" & strInternalVMPath & "' -> resolved to '" & strJavaExePath & "'" )
	End If

	getJavaExePath = strJavaExePath

End Function 'getJavaExePath


'==============================================================================
' Validate the Java configuration
'==============================================================================

Function validateJavaConfiguration()

	Dim boolJavaHomeDefined
	boolJavaHomeDefined = False

	Dim wshEnvVars, javaHomePath, javaExeAbsPath

	If DEBUGGING Then
		MsgBox "Checking Java configuration"
	End If

	' NOTE: For Windows 95/98/Me, only Environment("Process") is allowed
	' For Windows NT/2000 (?XP?), Environment("System") is used??
	' If strType is not supplied, the Environment property returns different 
	' environment variable types depending on the operating system.

	' Verify that the JAVA_HOME environment variable is defined
	set wshEnvVars = gobjShell.Environment("Process")
	javaHomePath = wshEnvVars(JAVA_HOME_VAR_NAME)
	If javaHomePath <> "" Then
		boolJavaHomeDefined = True
		If DEBUGGING Then
			WScript.Echo JAVA_HOME_VAR_NAME & "(process): " & javaHomePath
		End If
	End If
	'ISSUE: What's the best way to check for Windows NT/2000/XP but *NOT* Win95/98/Me???
	If ( NOT boolJavaHomeDefined ) AND ( wshEnvVars("OS") = "Windows_NT" ) Then
		Set wshEnvVars = gobjShell.Environment("USER")
		javaHomePath = wshEnvVars(JAVA_HOME_VAR_NAME)
		If javaHomePath <> "" Then
			boolJavaHomeDefined = True
			If DEBUGGING Then
				WScript.Echo JAVA_HOME_VAR_NAME & "(user): " & javaHomePath
			End If
		Else
			Set wshEnvVars = gobjShell.Environment("SYSTEM")
			javaHomePath = wshEnvVars(JAVA_HOME_VAR_NAME)
			If javaHomePath <> "" Then
				boolJavaHomeDefined = True
				If DEBUGGING Then
					WScript.Echo JAVA_HOME_VAR_NAME & "(system): " & javaHomePath
				End If
			End If
		End If
	End If

	If ( NOT boolJavaHomeDefined ) Then
		MsgBox "You need to define the environment variable " & JAVA_HOME_VAR_NAME & " with the path where your Java runtime is installed.", vbOkOnly+vbCritical, "ACES Java Configuration Problem"
		WScript.Quit(0)
	End If

	' Verify that the JAVA_HOME path is valid and that the java VM is really there
	javaExeAbsPath = javaHomePath & "\" & JAVA_EXE_RELATIVE_PATH
	If NOT gobjFSO.folderExists(javaHomePath) Then
		MsgBox "The directory where your Java runtime is installed does not exist:" & vbNewLine & vbNewLine & "    " & JAVA_HOME_VAR_NAME & "=" & javaHomePath & vbNewLine & vbNewLine & "Please correct your environment variable setting and try again.", vbOkOnly+vbCritical, "ACES Java Configuration Problem"
		WScript.Quit(0)
	End If
	If NOT gobjFSO.fileExists(javaExeAbsPath) Then
		MsgBox "Unable to locate the Java runtime executable at " & JAVA_HOME_EXE_PATH & "." & vbNewLine & vbNewLine & "Please correct your environment variable setting for the Java runtime installation directory:" & vbNewLine & vbNewLine & "    " & JAVA_HOME_VAR_NAME & "=" & javaHomePath & vbNewLine & vbNewLine & "and try again.", vbOkOnly+vbCritical, "ACES Java Configuration Problem"
		WScript.Quit(0)
	End If

	'??? Validate that J2SE 1.4 or later is installed ????

	If DEBUGGING Then
		MsgBox JAVA_HOME_VAR_NAME & ": " & javaHomePath, vbOkOnly+vbInformation, "Java Configuration Validated"
	End If

End Function 'validateJavaConfiguration


'==========================================================================

'TBD: allow arguments to paramaterize the shortcut name or ACES inst dir??
'Set objArgs = WScript.Arguments
'For I = 0 to objArgs.Count - 1
'   WScript.Echo objArgs(I)
'Next

call createACESShortcut( ACES_SHORTCUT_NAME )
