/*
 * Decompiled with CFR 0.152.
 */
package com.glaivestone.javax.execution;

import com.glaivestone.javax.execution.EvaluableAction;
import com.glaivestone.javax.execution.ExceptionHandler;
import com.glaivestone.javax.execution.SessionManager;
import java.lang.reflect.InvocationTargetException;

public abstract class AbstractEvaluableAction
implements EvaluableAction {
    public static final ExceptionHandler PROPAGATING_HANDLER = new ExceptionHandler(){

        @Override
        public boolean canHandle(Throwable anException) {
            return true;
        }

        @Override
        public Object handle(Throwable anException, Object context) {
            throw new RuntimeException(AbstractEvaluableAction.getOriginalException(anException));
        }
    };
    public static final ExceptionHandler TERMINATING_HANDLER = new ExceptionHandler(){

        @Override
        public boolean canHandle(Throwable anException) {
            return true;
        }

        @Override
        public Object handle(Throwable anException, Object context) {
            AbstractEvaluableAction.reportEvaluationFailure(anException, context);
            SessionManager.current.shutdown();
            return null;
        }
    };
    public static final ExceptionHandler CONTINUABLE_HANDLER = new ExceptionHandler(){

        @Override
        public boolean canHandle(Throwable anException) {
            return true;
        }

        @Override
        public Object handle(Throwable anException, Object context) {
            AbstractEvaluableAction.reportEvaluationFailure(anException, context);
            return null;
        }
    };
    public static final Class<?>[] EMPTY_PARM_TYPES = new Class[0];
    public static final Object[] EMPTY_ARGS = new Object[0];
    protected static final int UNKNOWN_NUM_ARGS = -1;
    public static ExceptionHandler DEFAULT_HANDLER = PROPAGATING_HANDLER;
    protected Object receiver;
    protected int nArguments;
    protected Object[] arguments;
    protected ExceptionHandler exceptionHandler;

    protected AbstractEvaluableAction(Object receiver, Object[] arguments, ExceptionHandler exceptionHandler) {
        if (receiver == null) {
            throw new IllegalArgumentException("EvaluableAction receiver may not be null");
        }
        this.setReceiver(receiver);
        this.nArguments = -1;
        this.setArguments(arguments);
        this.setExceptionHandler(exceptionHandler);
    }

    public static Throwable getOriginalException(Throwable anException) {
        if (anException instanceof InvocationTargetException) {
            return ((InvocationTargetException)anException).getTargetException();
        }
        Throwable originalCause = anException.getCause();
        return originalCause != null ? originalCause : anException;
    }

    protected static void reportEvaluationFailure(Throwable anException, Object context) {
    }

    @Override
    public Object evaluate() {
        return this.evaluate(this.arguments);
    }

    @Override
    public Object evaluate(Object anArg) {
        return this.evaluate(new Object[]{anArg});
    }

    @Override
    public Object evaluate(Object arg1, Object arg2) {
        return this.evaluate(new Object[]{arg1, arg2});
    }

    @Override
    public abstract Object evaluate(Object[] var1);

    @Override
    public Object[] getArguments() {
        return this.arguments;
    }

    public int getNumberOfArguments() {
        return this.nArguments;
    }

    @Override
    public Object getReceiver() {
        return this.receiver;
    }

    protected String getReceiverClassName() {
        return this.receiver instanceof Class ? ((Class)this.receiver).getName() : this.receiver.getClass().getName();
    }

    protected String getReceiverDescription() {
        if (this.receiver == null) {
            return "(null)";
        }
        String className = this.getReceiverClassName();
        return this.receiver instanceof Class ? "class " + className : "instance of " + className;
    }

    @Override
    public abstract String getSelector();

    protected String getSimpleClassName() {
        return this.getClass().getSimpleName();
    }

    protected Object handleEvaluationException(Throwable ex) {
        Throwable anException = AbstractEvaluableAction.getOriginalException(ex);
        if (this.exceptionHandler.canHandle(anException)) {
            return this.exceptionHandler.handle(anException, this);
        }
        throw new RuntimeException(anException);
    }

    @Override
    public void setArguments(Object[] arguments) {
        this.arguments = arguments;
    }

    protected void setNumberOfArguments(int nArguments) {
        this.nArguments = nArguments;
    }

    @Override
    public void setExceptionHandler(ExceptionHandler aHandler) {
        this.exceptionHandler = aHandler;
    }

    protected void setReceiver(Object receiver) {
        this.validateReceiver(receiver);
        this.receiver = receiver;
    }

    protected void validateArguments(Object[] args) {
        int actualNumArgs;
        int expectedNumArgs = this.getNumberOfArguments();
        int n = actualNumArgs = args == null ? 0 : args.length;
        if (actualNumArgs != expectedNumArgs) {
            throw new IllegalArgumentException("Wrong number of arguments : given " + actualNumArgs + " , requires " + expectedNumArgs + " - " + this);
        }
    }

    protected void validateDefaultArguments() {
        if (this.getNumberOfArguments() == -1) {
            throw new IllegalStateException("Constructor init error: nArgs not defined");
        }
        if (this.arguments == null) {
            if (this.getNumberOfArguments() == 0) {
                this.setArguments(EMPTY_ARGS);
            }
        } else {
            this.validateArguments(this.arguments);
        }
    }

    protected void validateReceiver(Object aReceiver) {
        if (aReceiver == null) {
            throw new IllegalArgumentException("Evaluable action receiver may not be null.");
        }
    }
}

