/*
 * Decompiled with CFR 0.152.
 */
package com.glaivestone.javax.execution;

import com.glaivestone.javax.execution.AbstractEvaluableAction;
import com.glaivestone.javax.execution.ExceptionHandler;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;

public class ConstructorAction
extends AbstractEvaluableAction {
    protected Constructor<?> constructor;

    public ConstructorAction(Class<?> aClass, Constructor<?> aConstructor, Object[] arguments, ExceptionHandler exceptionHandler) {
        super(aClass, arguments, exceptionHandler);
        this.setConstructor(aConstructor);
        this.setNumberOfArguments(aConstructor.getParameterTypes().length);
        this.validateDefaultArguments();
    }

    public static ConstructorAction create(Class<?> aClass) {
        return ConstructorAction.create(aClass, EMPTY_PARM_TYPES, EMPTY_ARGS);
    }

    public static ConstructorAction create(Class<?> aClass, Class<?>[] parmTypes) {
        return ConstructorAction.create(aClass, parmTypes, null);
    }

    public static ConstructorAction create(Class<?> aClass, Class<?>[] parmTypes, Object[] args) {
        Constructor<?> aConstructor = ConstructorAction.findConstructor(aClass, parmTypes);
        return aConstructor == null ? null : ConstructorAction.create(aClass, aConstructor, args);
    }

    public static ConstructorAction create(Class<?> aClass, Constructor<?> aConstructor, Object[] args) {
        return new ConstructorAction(aClass, aConstructor, args, DEFAULT_HANDLER);
    }

    public static Constructor<?> findConstructor(Class<?> aClass) {
        return ConstructorAction.findConstructor(aClass, EMPTY_PARM_TYPES);
    }

    public static Constructor<?> findConstructor(Class<?> aClass, Class<?>[] parmTypes) {
        Constructor<?> aConstructor;
        try {
            aConstructor = aClass.getConstructor(parmTypes);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
        if (!Modifier.isPublic(aConstructor.getModifiers())) {
            return null;
        }
        return aConstructor;
    }

    @Override
    public Object evaluate(Object[] args) {
        try {
            return this.constructor.newInstance(args);
        }
        catch (Throwable ex) {
            return this.handleEvaluationException(ex);
        }
    }

    public Constructor<?> getConstructor() {
        return this.constructor;
    }

    @Override
    public String getSelector() {
        return this.constructor.getName();
    }

    protected void setConstructor(Constructor<?> aConstructor) {
        this.validateConstructor(aConstructor);
        this.constructor = aConstructor;
    }

    public String toString() {
        return "a " + this.getSimpleClassName() + " {" + this.constructor + "}";
    }

    protected void validateConstructor(Constructor<?> aConstructor) {
        if (aConstructor == null) {
            throw new IllegalArgumentException("ConstructorAction requires a constructor (may not be null)");
        }
        if (!Modifier.isPublic(aConstructor.getModifiers())) {
            throw new IllegalArgumentException(this.getSimpleClassName() + " constructor not public: " + aConstructor);
        }
    }

    @Override
    protected void validateReceiver(Object aReceiver) {
        super.validateReceiver(aReceiver);
        if (!(aReceiver instanceof Class)) {
            throw new IllegalArgumentException(this.getSimpleClassName() + " receiver not a class: " + this.receiver);
        }
    }
}

