/*
 * Decompiled with CFR 0.152.
 */
package com.glaivestone.javax.execution;

import com.glaivestone.javax.execution.ExceptionHandler;
import com.glaivestone.javax.execution.MessageAction;
import com.glaivestone.javax.lang.ClassX;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class InstanceMethodAction
extends MessageAction {
    public InstanceMethodAction(Object receiver, Method aMethod, Object[] arguments, ExceptionHandler exceptionHandler) {
        super(receiver, aMethod, arguments, exceptionHandler);
    }

    public static InstanceMethodAction create(Object anInstance, String selector) {
        return InstanceMethodAction.create(anInstance, selector, EMPTY_PARM_TYPES, EMPTY_ARGS);
    }

    public static InstanceMethodAction create(Object anInstance, String selector, Class<?>[] parmTypes) {
        return InstanceMethodAction.create(anInstance, selector, parmTypes, null);
    }

    public static InstanceMethodAction create(Object anInstance, String selector, Class<?>[] parmTypes, Object[] args) {
        Method aMethod = InstanceMethodAction.findMethod(anInstance, selector, parmTypes);
        return aMethod == null ? null : InstanceMethodAction.create(anInstance, aMethod, args);
    }

    public static InstanceMethodAction create(Object anInstance, Method aMethod, Object[] args) {
        return new InstanceMethodAction(anInstance, aMethod, args, DEFAULT_HANDLER);
    }

    public static Method findMethod(Object anInstance, String selector) {
        return InstanceMethodAction.findMethod(anInstance, selector, EMPTY_PARM_TYPES);
    }

    public static Method findMethod(Object anInstance, String selector, Class<?>[] parmTypes) {
        Method aMethod = ClassX.getMethodOrNull(anInstance.getClass(), selector, parmTypes);
        if (aMethod == null) {
            return null;
        }
        return aMethod;
    }

    @Override
    protected void validateMethod(Method aMethod) {
        super.validateMethod(aMethod);
        if (Modifier.isStatic(aMethod.getModifiers())) {
            throw new IllegalArgumentException(this.getSimpleClassName() + " method not an instance method: " + aMethod);
        }
    }

    @Override
    protected void validateReceiver(Object aReceiver) {
        super.validateReceiver(aReceiver);
        if (aReceiver instanceof Class) {
            throw new IllegalArgumentException(this.getSimpleClassName() + " receiver not an instance: " + this.receiver);
        }
    }
}

