/*
 * Decompiled with CFR 0.152.
 */
package com.glaivestone.javax.execution;

import com.glaivestone.javax.execution.AbstractEvaluableAction;
import com.glaivestone.javax.execution.ExceptionHandler;
import com.glaivestone.javax.lang.ClassX;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class MessageAction
extends AbstractEvaluableAction {
    protected Method method;

    public MessageAction(Object receiver, Method aMethod, Object[] arguments, ExceptionHandler exceptionHandler) {
        super(receiver, arguments, exceptionHandler);
        this.setMethod(aMethod);
        this.setNumberOfArguments(aMethod.getParameterTypes().length);
        this.validateDefaultArguments();
    }

    @Override
    public Object evaluate(Object[] args) {
        try {
            return this.method.invoke(this.receiver, args);
        }
        catch (Throwable ex) {
            return this.handleEvaluationException(ex);
        }
    }

    public Method getMethod() {
        return this.method;
    }

    @Override
    public String getSelector() {
        return this.method.getName();
    }

    protected void setMethod(Method aMethod) {
        this.validateMethod(aMethod);
        this.method = aMethod;
    }

    public String toString() {
        return this.getSimpleClassName() + " {" + this.getReceiverDescription() + ", " + ClassX.toSimpleSignatureDescription(this.method) + "}";
    }

    protected void validateMethod(Method aMethod) {
        if (aMethod == null) {
            throw new IllegalArgumentException("MessageAction requires a method (may not be null)");
        }
        if (!Modifier.isPublic(aMethod.getModifiers())) {
            throw new IllegalArgumentException(this.getSimpleClassName() + " method not public: " + aMethod);
        }
    }
}

