/*
 * Decompiled with CFR 0.152.
 */
package com.glaivestone.javax.execution;

import com.glaivestone.javax.execution.ExceptionHandler;
import com.glaivestone.javax.execution.MessageAction;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class StaticMethodAction
extends MessageAction {
    public StaticMethodAction(Object receiver, Method aMethod, Object[] arguments, ExceptionHandler exceptionHandler) {
        super(receiver, aMethod, arguments, exceptionHandler);
    }

    public static StaticMethodAction create(Class<?> aClass, String selector) {
        return StaticMethodAction.create(aClass, selector, EMPTY_PARM_TYPES, EMPTY_ARGS);
    }

    public static StaticMethodAction create(Class<?> aClass, String selector, Class<?>[] parmTypes) {
        return StaticMethodAction.create(aClass, selector, parmTypes, null);
    }

    public static StaticMethodAction create(Class<?> aClass, String selector, Class<?>[] parmTypes, Object[] args) {
        Method aMethod = StaticMethodAction.findMethod(aClass, selector, parmTypes);
        return aMethod == null ? null : StaticMethodAction.create(aClass, aMethod, args);
    }

    public static StaticMethodAction create(Class<?> aClass, Method aMethod, Object[] args) {
        return new StaticMethodAction(aClass, aMethod, args, DEFAULT_HANDLER);
    }

    public static Method findMethod(Class<?> aClass, String selector) {
        return StaticMethodAction.findMethod(aClass, selector, EMPTY_PARM_TYPES);
    }

    public static Method findMethod(Class<?> aClass, String selector, Class<?>[] parmTypes) {
        Method aMethod;
        try {
            aMethod = aClass.getDeclaredMethod(selector, parmTypes);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
        if (!Modifier.isPublic(aMethod.getModifiers())) {
            return null;
        }
        if (!Modifier.isStatic(aMethod.getModifiers())) {
            throw new IllegalArgumentException("Not a static method: " + aMethod);
        }
        return aMethod;
    }

    @Override
    protected void validateMethod(Method aMethod) {
        super.validateMethod(aMethod);
        if (!Modifier.isStatic(aMethod.getModifiers())) {
            throw new IllegalArgumentException(this.getSimpleClassName() + " method not static: " + aMethod);
        }
    }

    @Override
    protected void validateReceiver(Object aReceiver) {
        super.validateReceiver(aReceiver);
        if (!(aReceiver instanceof Class)) {
            throw new IllegalArgumentException(this.getSimpleClassName() + " receiver not a class: " + this.receiver);
        }
    }
}

