/*
 * Decompiled with CFR 0.152.
 */
package com.glaivestone.javax.swing;

import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class PlainTextDocument
extends PlainDocument {
    public static boolean REPORT_IMPOSSIBLE_ERRORS = true;

    public PlainTextDocument() {
    }

    public PlainTextDocument(String aString) {
        this();
        this.setText(aString);
    }

    public void appendText(String aString) {
        try {
            this.insertString(this.getLength(), aString, null);
        }
        catch (BadLocationException ex) {
            this.reportOperationFailure("appendText", ex);
        }
    }

    public String getText() {
        try {
            return this.getText(0, this.getLength());
        }
        catch (BadLocationException ex) {
            this.reportOperationFailure("getText", ex);
            return null;
        }
    }

    protected void reportOperationFailure(String operationName, Throwable ex) {
        if (REPORT_IMPOSSIBLE_ERRORS) {
            System.err.println("***ERROR in " + this.getClass().getName() + "::" + operationName + ": " + ex.getMessage());
            ex.printStackTrace(System.err);
        }
    }

    public void setText(String aString) {
        try {
            this.remove(0, this.getLength());
            this.appendText(aString);
        }
        catch (BadLocationException ex) {
            this.reportOperationFailure("setText", ex);
        }
    }
}

