/*
 * Decompiled with CFR 0.152.
 */
package com.glaivestone.javax.util;

import java.lang.reflect.Array;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;

public class EventListenerList {
    public static final int NOT_FOUND_INDEX = -1;
    public static final Class<EventListener> GENERIC_LISTENER_TYPE = EventListener.class;
    protected static Map<Class<? extends EventListener>, EventListener[]> emptyListenersTable = new HashMap<Class<? extends EventListener>, EventListener[]>();
    protected Class<? extends EventListener> listenerType;
    protected boolean holdsGenericListeners;
    protected boolean validateListeners;
    protected EventListener[] listeners;

    public EventListenerList() {
        this(GENERIC_LISTENER_TYPE);
    }

    public EventListenerList(Class<? extends EventListener> listenerType) {
        if (!GENERIC_LISTENER_TYPE.isAssignableFrom(listenerType)) {
            throw new IllegalArgumentException("Listener type must be an EventListener: " + listenerType);
        }
        this.listenerType = listenerType;
        this.holdsGenericListeners = this.listenerType.equals(GENERIC_LISTENER_TYPE);
        this.validateListeners = !this.holdsGenericListeners;
        this.listeners = this.constructEmptyListenersArray();
    }

    public static EventListener[] getEmptyListenersArray(Class<? extends EventListener> listenerType) {
        EventListener[] emptyListeners = emptyListenersTable.get(listenerType);
        if (emptyListeners == null) {
            emptyListeners = EventListenerList.newListenersArray(listenerType, 0);
            emptyListenersTable.put(listenerType, emptyListeners);
        }
        return emptyListeners;
    }

    public static EventListener[] newListenersArray(Class<? extends EventListener> listenerType, int size) {
        return (EventListener[])Array.newInstance(listenerType, size);
    }

    public synchronized void add(EventListener aListener) {
        if (this.validateListeners) {
            this.validateListener(aListener);
        }
        if (this.listeners.length == 0) {
            this.listeners = this.constructListenersArray(1);
            this.listeners[0] = aListener;
        } else {
            int count = this.listeners.length;
            EventListener[] newList = this.constructListenersArray(count + 1);
            System.arraycopy(this.listeners, 0, newList, 0, count);
            newList[count] = aListener;
            this.listeners = newList;
        }
    }

    public synchronized void addFirst(EventListener aListener) {
        if (this.validateListeners) {
            this.validateListener(aListener);
        }
        if (this.listeners.length == 0) {
            this.listeners = this.constructListenersArray(1);
            this.listeners[0] = aListener;
        } else {
            int count = this.listeners.length;
            EventListener[] newList = this.constructListenersArray(count + 1);
            newList[0] = aListener;
            System.arraycopy(this.listeners, 0, newList, 1, count);
            this.listeners = newList;
        }
    }

    protected EventListener[] constructEmptyListenersArray() {
        return EventListenerList.getEmptyListenersArray(this.listenerType);
    }

    protected EventListener[] constructListenersArray(int size) {
        return EventListenerList.newListenersArray(this.listenerType, size);
    }

    public EventListener[] getListeners() {
        return this.listeners;
    }

    protected int indexOf(EventListener aListener) {
        for (int i = this.listeners.length - 1; i >= 0; --i) {
            if (!this.listeners[i].equals(aListener)) continue;
            return i;
        }
        return -1;
    }

    public synchronized void remove(EventListener aListener) {
        int count;
        if (aListener == null) {
            return;
        }
        int index = this.indexOf(aListener);
        if (index == -1) {
            return;
        }
        int nListeners = this.listeners.length;
        if (nListeners == 1) {
            this.listeners = this.constructEmptyListenersArray();
            return;
        }
        EventListener[] newList = this.constructListenersArray(nListeners - 1);
        if (index > 0) {
            count = index;
            System.arraycopy(this.listeners, 0, newList, 0, count);
        }
        if (index < nListeners - 1) {
            count = newList.length - index;
            System.arraycopy(this.listeners, index + 1, newList, index, count);
        }
        this.listeners = newList;
    }

    public void removeAll() {
        this.listeners = this.constructEmptyListenersArray();
    }

    public int size() {
        return this.listeners.length;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.size() + "]" + (!this.holdsGenericListeners ? " of " + this.listenerType.getName() : "");
    }

    protected void validateListener(EventListener aListener) {
        if (!this.listenerType.isAssignableFrom(aListener.getClass())) {
            throw new IllegalArgumentException("Listener must be " + this.listenerType + ": " + aListener);
        }
    }
}

