/*
 * Decompiled with CFR 0.152.
 */
package com.glaivestone.mv.swing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;

public abstract class AbstractListHolder {
    public static final int NOT_FOUND_INDEX = -1;
    public static final int SINGLE_SELECT_MODE = 0;
    public static final int MULTI_SELECT_MODE = 2;
    public static final int DEFAULT_SELECTION_MODE = 0;
    protected ListSelectionModel selectionModel;

    protected AbstractListHolder(ListSelectionModel selectionModel) {
        this.selectionModel = selectionModel;
    }

    public static ListSelectionModel createDefaultSelectionModel() {
        return AbstractListHolder.createDefaultSelectionModel(0);
    }

    public static ListSelectionModel createDefaultSelectionModel(int selectionMode) {
        DefaultListSelectionModel aSelectionModel = new DefaultListSelectionModel();
        aSelectionModel.setSelectionMode(selectionMode);
        return aSelectionModel;
    }

    public synchronized void add(Object aValue) {
        this.addEntry(aValue);
    }

    public synchronized void addAll(Collection<?> values) {
        for (Object aValue : values) {
            this.addEntry(aValue);
        }
    }

    protected abstract void addEntry(Object var1);

    public synchronized void clear() {
        if (this.size() == 0) {
            return;
        }
        this.clearSelection();
        this.clearValues();
    }

    public void clearSelection() {
        this.getSelectionModel().clearSelection();
    }

    protected abstract void clearValues();

    public abstract boolean contains(Object var1);

    public abstract Object get(int var1);

    public int getSelectedIndex() {
        this.verifySingleSelectMode();
        if (this.getSelectionModel().isSelectionEmpty()) {
            return -1;
        }
        return this.getSelectionModel().getMinSelectionIndex();
    }

    public Object getSelectedValue() {
        int selectedIndex = this.getSelectedIndex();
        return selectedIndex == -1 ? null : this.get(selectedIndex);
    }

    public List<Object> getSelectedValues() {
        this.verifyMultiSelectMode();
        if (this.getSelectionModel().isSelectionEmpty()) {
            return Collections.emptyList();
        }
        int firstSelIndex = this.getSelectionModel().getMinSelectionIndex();
        int lastSelIndex = this.getSelectionModel().getMaxSelectionIndex();
        ArrayList<Object> selectedValues = new ArrayList<Object>();
        for (int i = firstSelIndex; i <= lastSelIndex; ++i) {
            if (!this.getSelectionModel().isSelectedIndex(i)) continue;
            selectedValues.add(this.get(i));
        }
        return selectedValues;
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public int getSelectionSize() {
        if (this.getSelectionModel().isSelectionEmpty()) {
            return 0;
        }
        if (this.isSingleSelect()) {
            return 1;
        }
        int nSelectedValues = 0;
        int firstSelIndex = this.getSelectionModel().getMinSelectionIndex();
        int lastSelIndex = this.getSelectionModel().getMaxSelectionIndex();
        for (int i = firstSelIndex; i <= lastSelIndex; ++i) {
            if (!this.getSelectionModel().isSelectedIndex(i)) continue;
            ++nSelectedValues;
        }
        return nSelectedValues;
    }

    public synchronized List<Object> getValues() {
        int nValues = this.size();
        ArrayList<Object> values = new ArrayList<Object>(nValues);
        for (int i = 0; i < nValues; ++i) {
            values.add(this.get(i));
        }
        return values;
    }

    public boolean hasSelection() {
        return !this.getSelectionModel().isSelectionEmpty();
    }

    public abstract int indexOf(Object var1);

    public boolean isMultiSelect() {
        return !this.isSingleSelect();
    }

    public boolean isSingleSelect() {
        return this.getSelectionModel().getSelectionMode() == 0;
    }

    public void remove(Object aValue) {
        this.remove(this.indexOf(aValue));
    }

    public void remove(int index) {
        if (index < 0 || index >= this.size()) {
            return;
        }
        boolean valueWasSelected = this.getSelectionModel().isSelectedIndex(index);
        this.removeEntry(index);
        if (valueWasSelected) {
            this.updateSelectionAfterEntryRemoved(index);
        }
    }

    protected abstract void removeEntry(int var1);

    public void selectAll() {
        this.verifyMultiSelectMode();
        this.selectIndices(0, this.size() - 1);
    }

    public void selectIndex(int index) {
        this.selectIndex(index, true);
    }

    public void selectIndex(int index, boolean addToExistingSelection) {
        if (this.isSingleSelect() || !addToExistingSelection) {
            this.getSelectionModel().setSelectionInterval(index, index);
        } else {
            this.getSelectionModel().addSelectionInterval(index, index);
        }
    }

    public void selectIndices(int firstIndex, int lastIndex) {
        this.selectIndices(firstIndex, lastIndex, true);
    }

    public void selectIndices(int firstIndex, int lastIndex, boolean addToExistingSelection) {
        this.verifyMultiSelectMode();
        if (addToExistingSelection) {
            this.getSelectionModel().addSelectionInterval(firstIndex, lastIndex);
        } else {
            this.getSelectionModel().setSelectionInterval(firstIndex, lastIndex);
        }
    }

    public void selectValue(Object aValue) {
        this.selectValue(aValue, true);
    }

    public void selectValue(Object aValue, boolean addToExistingSelection) {
        int index = this.indexOf(aValue);
        if (index < 0) {
            return;
        }
        this.selectIndex(index, addToExistingSelection);
    }

    public void selectValues(List<?> valuesToSelect) {
        this.selectValues(valuesToSelect, true);
    }

    public void selectValues(List<?> valuesToSelect, boolean addToExistingSelection) {
        this.verifyMultiSelectMode();
        if (!addToExistingSelection) {
            this.clearSelection();
        }
        for (Object aValue : valuesToSelect) {
            int index = this.indexOf(aValue);
            if (index < 0) continue;
            this.getSelectionModel().addSelectionInterval(index, index);
        }
    }

    public void setMultiSelect() {
        this.getSelectionModel().setSelectionMode(2);
    }

    public void setSingleSelect() {
        this.getSelectionModel().setSelectionMode(0);
    }

    public abstract int size();

    protected void updateSelectionAfterEntryRemoved(int index) {
        if (this.isMultiSelect()) {
            return;
        }
        if (this.size() == 0) {
            this.getSelectionModel().removeSelectionInterval(index, index);
            return;
        }
        int newSelectedIndex = index == 0 ? 0 : index - 1;
        this.selectIndex(newSelectedIndex);
    }

    protected void verifyMultiSelectMode() {
        if (!this.isMultiSelect()) {
            throw new IllegalStateException("Invalid operation for single-select holder: " + this);
        }
    }

    protected void verifySingleSelectMode() {
        if (!this.isSingleSelect()) {
            throw new IllegalStateException("Invalid operation for multi-select holder: " + this);
        }
    }
}

