/*
 * Decompiled with CFR 0.152.
 */
package com.glaivestone.mv.swing;

import com.glaivestone.mv.swing.StandardValueRenderer;
import com.glaivestone.mv.swing.ValueRenderer;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.UIManager;

public class ConfigurableListCellRenderer
extends DefaultListCellRenderer {
    protected ValueRenderer valueRenderer;

    public ConfigurableListCellRenderer() {
        this(StandardValueRenderer.current);
    }

    public ConfigurableListCellRenderer(ValueRenderer aValueRenderer) {
        this.setValueRenderer(aValueRenderer);
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setComponentOrientation(list.getComponentOrientation());
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        this.renderValue(value);
        this.setEnabled(list.isEnabled());
        this.setFont(list.getFont());
        this.setBorder(cellHasFocus ? UIManager.getBorder("List.focusCellHighlightBorder") : noFocusBorder);
        return this;
    }

    protected String getRenderingString(Object value) {
        return this.valueRenderer.toDisplayString(value);
    }

    protected void renderIcon(Icon anIcon) {
        this.setIcon(anIcon);
        this.setText("");
    }

    protected void renderText(Object value) {
        this.setIcon(null);
        this.setText(this.getRenderingString(value));
    }

    protected void renderValue(Object value) {
        if (value instanceof Icon) {
            this.renderIcon((Icon)value);
        } else {
            this.renderText(value);
        }
    }

    public void setValueRenderer(ValueRenderer aValueRenderer) {
        this.valueRenderer = aValueRenderer;
    }
}

