/*
 * Decompiled with CFR 0.152.
 */
package com.glaivestone.mv.swing;

import com.glaivestone.mv.swing.AbstractListHolder;
import com.glaivestone.mv.swing.TableRow;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.ListSelectionModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class TableHolder
extends AbstractListHolder {
    protected static final Object[][] EMPTY_ROW_DATA = new Object[0][];
    protected DefaultTableModel dataModel;

    public TableHolder() {
        this(TableHolder.createDefaultDataModel(), TableHolder.createDefaultSelectionModel());
    }

    public TableHolder(int selectionMode) {
        this(TableHolder.createDefaultDataModel(), TableHolder.createDefaultSelectionModel(selectionMode));
    }

    public TableHolder(DefaultTableModel dataModel, ListSelectionModel selectionModel) {
        super(selectionModel);
        this.dataModel = dataModel;
    }

    public static Vector<Object> asVector(Object[] values) {
        return new Vector<Object>(Arrays.asList(values));
    }

    public static Vector<String> asVector(String[] values) {
        return new Vector<String>(Arrays.asList(values));
    }

    public static DefaultTableModel createDefaultDataModel() {
        return new DefaultTableModel();
    }

    @Override
    protected void addEntry(Object aValue) {
        this.validateRow(aValue);
        this.getConcreteDataModel().addRow((TableRow)aValue);
    }

    @Override
    protected void clearValues() {
        this.getConcreteDataModel().setNumRows(0);
    }

    @Override
    public boolean contains(Object aValue) {
        this.validateRow(aValue);
        return this.getConcreteDataModel().getDataVector().contains(aValue);
    }

    @Override
    public Object get(int index) {
        return this.getConcreteDataModel().getDataVector().elementAt(index);
    }

    protected DefaultTableModel getConcreteDataModel() {
        return this.dataModel;
    }

    public TableModel getDataModel() {
        return this.dataModel;
    }

    public Object getRow(int index) {
        return (TableRow)this.get(index);
    }

    @Override
    public int indexOf(Object aValue) {
        this.validateRow(aValue);
        return this.getConcreteDataModel().getDataVector().indexOf(aValue);
    }

    @Override
    protected void removeEntry(int index) {
        this.getConcreteDataModel().removeRow(index);
    }

    public void setColumnNames(String[] columnNames) {
        if (this.size() > 0) {
            throw new IllegalStateException("Cannot reset column names when table contains data");
        }
        this.getConcreteDataModel().setDataVector(EMPTY_ROW_DATA, columnNames);
    }

    public void setColumnNames(List<String> columnNames) {
        if (this.size() > 0) {
            throw new IllegalStateException("Cannot reset column names when table contains data");
        }
        List<TableRow> emptyRows = Collections.emptyList();
        this.setData(columnNames, emptyRows);
    }

    public void setData(String[] columnNames, List<TableRow> rows) {
        this.setData(TableHolder.asVector(columnNames), new Vector<TableRow>(rows));
    }

    public void setData(List<String> columnNames, List<TableRow> rows) {
        this.setData(new Vector<String>(columnNames), new Vector<TableRow>(rows));
    }

    protected void setData(Vector<String> columnNames, Vector<TableRow> rows) {
        for (TableRow aRow : rows) {
            this.validateRow(aRow);
        }
        this.getConcreteDataModel().setDataVector(rows, columnNames);
    }

    @Override
    public int size() {
        return this.dataModel.getRowCount();
    }

    protected void validateRow(Object aValue) {
        if (!(aValue instanceof TableRow)) {
            throw new IllegalArgumentException("Table entry not a TableRow: " + aValue);
        }
    }
}

