/*
 * Decompiled with CFR 0.152.
 */
package com.glaivestone.toolbox.mv.text;

import com.glaivestone.javax.lang.SystemConstants;
import com.glaivestone.mv.FrameWindowApplicationModel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public abstract class BasicTextWindow
extends FrameWindowApplicationModel {
    public static final String NEW_LINE = SystemConstants.NEW_LINE;
    public static final String TEXT_TYPE_SPECIFICATION = "textType";
    public static final String TEXT_TYPE_STYLED = "styled";
    public static final String TEXT_TYPE_UNSTYLED = "unstyled";
    public static final String TEXT_PRINT_TARGET_SPECIFICATION = "textPrintTarget";
    public static final Map<String, Object> TEXT_PROPERTIES_UNSTYLED = Collections.unmodifiableMap(new HashMap<String, Object>(){
        {
            this.put(BasicTextWindow.TEXT_TYPE_SPECIFICATION, BasicTextWindow.TEXT_TYPE_UNSTYLED);
            this.put(BasicTextWindow.TEXT_PRINT_TARGET_SPECIFICATION, Boolean.FALSE);
        }
    });
    public static final Map<String, Object> TEXT_PROPERTIES_UNSTYLED_LOG = Collections.unmodifiableMap(new HashMap<String, Object>(){
        {
            this.put(BasicTextWindow.TEXT_TYPE_SPECIFICATION, BasicTextWindow.TEXT_TYPE_UNSTYLED);
            this.put(BasicTextWindow.TEXT_PRINT_TARGET_SPECIFICATION, Boolean.TRUE);
        }
    });
    protected Map<String, Object> textSpecifications;
    protected Document textHolder;
    protected AttributeSet currentAttributes;

    protected BasicTextWindow(String appTitle, Map<String, Object> textSpecifications) {
        super(appTitle);
        this.textSpecifications = textSpecifications;
        this.initialize();
    }

    protected BasicTextWindow(String appTitle, String subjectDescription) {
        super(appTitle, subjectDescription);
        this.initialize();
    }

    public void appendString(String aString) {
        this.appendString(aString, this.getCurrentAttributes());
    }

    public void appendString(String aString, AttributeSet attributes) {
        try {
            this.getTextHolder().insertString(this.getTextHolder().getLength(), aString, attributes);
        }
        catch (BadLocationException ex) {
            this.reportOperationFailure("appendString", ex);
            return;
        }
    }

    protected abstract Document constructTextHolder();

    public AttributeSet getCurrentAttributes() {
        return this.currentAttributes;
    }

    public String getText() {
        try {
            return this.getTextHolder().getText(0, this.getTextHolder().getLength());
        }
        catch (BadLocationException ex) {
            this.reportOperationFailure("getText", ex);
            return "";
        }
    }

    public Document getTextHolder() {
        return this.textHolder;
    }

    public Map<String, Object> getTextSpecifications() {
        return this.textSpecifications;
    }

    protected void initialize() {
        this.textHolder = this.constructTextHolder();
    }

    protected void reportOperationFailure(String operationName, Throwable ex) {
        System.err.println("ERROR in " + this.getClass().getName() + "::" + operationName + ": " + ex.getMessage());
    }

    public void setCurrentAttributes(AttributeSet attributes) {
        this.currentAttributes = attributes;
    }

    public void setText(String aString) {
        this.setText(aString, this.getCurrentAttributes());
    }

    public void setText(String aString, AttributeSet attributes) {
        try {
            this.getTextHolder().remove(0, this.getTextHolder().getLength());
            this.getTextHolder().insertString(0, aString, attributes);
        }
        catch (BadLocationException ex) {
            this.reportOperationFailure("setText", ex);
            return;
        }
    }
}

