/*
 * Decompiled with CFR 0.152.
 */
package com.glaivestone.toolbox.mv.text;

import com.glaivestone.javax.io.SystemIOStreams;
import com.glaivestone.javax.swing.MessageDialog;
import com.glaivestone.javax.util.VetoException;
import com.glaivestone.mv.UISessionManager;
import com.glaivestone.mv.WindowEvent;
import com.glaivestone.mv.WindowEventAdaptor;
import java.awt.Frame;
import java.io.PrintStream;

public class SessionStreamWindowController
extends WindowEventAdaptor {
    protected PrintStream appPrintStream;
    protected Frame printTargetView;
    protected boolean mustBeLastOpenWindow;

    public SessionStreamWindowController(PrintStream appPrintStream, Frame aWindow) {
        this.appPrintStream = appPrintStream;
        this.printTargetView = aWindow;
        this.mustBeLastOpenWindow(false);
    }

    @Override
    public void confirmWindowClose(WindowEvent event) throws VetoException {
        boolean allowClose;
        if (event.getWindow() != this.printTargetView) {
            return;
        }
        if (!this.isSysOut() && !this.isSysErr()) {
            UISessionManager.current.removeWindowListener(this);
            return;
        }
        if (this.isLastOpenWindow()) {
            return;
        }
        if (this.mustBeLastOpenWindow) {
            MessageDialog.displayMessage(this.printTargetView.getTitle(), "The session log window cannot be closed while there are open windows active in the current session.", this.printTargetView);
            allowClose = false;
        } else {
            allowClose = MessageDialog.confirm("Closing the session log window while there are still open windows active in the current session will reset the system output streams to the original console.\n\nProceed?", this.printTargetView);
        }
        if (!allowClose) {
            event.veto();
        }
    }

    protected void disconnectSystemStreams(boolean isSysOut, boolean isSysErr) {
        if (isSysOut) {
            SystemIOStreams.disconnectSysOut(this.appPrintStream);
        }
        if (isSysErr) {
            SystemIOStreams.disconnectSysErr(this.appPrintStream);
        }
    }

    public void installInSessionStreams() {
        this.installInSessionStreams(true, true);
    }

    public void installInSessionStreams(boolean captureSysOut, boolean captureSysErr) {
        if (captureSysOut && captureSysErr) {
            SystemIOStreams.setSystemOutputStreams(this.appPrintStream);
        } else {
            if (captureSysOut) {
                SystemIOStreams.setSysOut(this.appPrintStream);
            }
            if (captureSysErr) {
                SystemIOStreams.setSysErr(this.appPrintStream);
            }
        }
        UISessionManager.current.addWindowListener(this);
    }

    protected boolean isLastOpenWindow() {
        return UISessionManager.current.getOpenWindows().size() == 1;
    }

    protected boolean isSysErr() {
        return SystemIOStreams.isSysErr(this.appPrintStream);
    }

    protected boolean isSysOut() {
        return SystemIOStreams.isSysOut(this.appPrintStream);
    }

    public void mustBeLastOpenWindow(boolean mustBeLastOpenWindow) {
        this.mustBeLastOpenWindow = mustBeLastOpenWindow;
    }

    @Override
    public void windowClosing(WindowEvent event) {
        if (event.getWindow() != this.printTargetView) {
            return;
        }
        this.disconnectSystemStreams(this.isSysOut(), this.isSysErr());
        UISessionManager.current.removeWindowListener(this);
    }
}

