/*
 * Decompiled with CFR 0.152.
 */
package com.glaivestone.toolbox.mv.text;

import com.glaivestone.mv.ApplicationView;
import com.glaivestone.toolbox.mv.text.SessionStreamWindowController;
import com.glaivestone.toolbox.mv.text.TextLogWindow;
import com.glaivestone.toolbox.mv.text.TextWindow;
import java.awt.Frame;
import java.awt.Window;

public class SessionTextLogWindow
extends TextLogWindow {
    public static String DEFAULT_WINDOW_TITLE = "Session Log";
    public static boolean mustBeLastOpenWindow = false;
    private static boolean TESTING_FROM_MAIN = false;

    public SessionTextLogWindow() {
        this(DEFAULT_WINDOW_TITLE);
    }

    public SessionTextLogWindow(String windowTitle) {
        super(windowTitle);
    }

    public static TextLogWindow createWindow(String windowTitle) {
        SessionTextLogWindow aWindow = new SessionTextLogWindow(windowTitle);
        aWindow.openWindow();
        return aWindow;
    }

    public static ApplicationView open() {
        return (ApplicationView)((Object)new SessionTextLogWindow().openWindow());
    }

    public static ApplicationView open(String windowTitle) {
        return (ApplicationView)((Object)new SessionTextLogWindow(windowTitle).openWindow());
    }

    public static void requireSessionLogToBeLastOpenWindow() {
        mustBeLastOpenWindow = true;
    }

    protected void configureSessionLogController(SessionStreamWindowController controller) {
        controller.mustBeLastOpenWindow(mustBeLastOpenWindow);
    }

    protected SessionStreamWindowController constructSessionLogController(Window aWindow) {
        return new SessionStreamWindowController(this.getPrintStream(), (Frame)aWindow);
    }

    protected void installAsSessionLog(Window aWindow) {
        SessionStreamWindowController controller = this.constructSessionLogController(aWindow);
        this.configureSessionLogController(controller);
        controller.installInSessionStreams();
    }

    @Override
    protected void windowOpening(Window aWindow) {
        super.windowOpening(aWindow);
        this.installAsSessionLog(aWindow);
    }

    @Override
    protected void windowOpened(Window aWindow) {
        super.windowOpened(aWindow);
        if (TESTING_FROM_MAIN) {
            this.println("Session log window windowOpened event handler [" + this + "]");
            System.out.println("...verify System.out is captured...");
            System.err.println("...verify System.err is captured...");
            this.println("...ok");
        }
    }

    @Override
    protected void windowClosing(Window aWindow) {
        super.windowClosing(aWindow);
        if (TESTING_FROM_MAIN) {
            System.out.println("Session log window windowClosing event handler [" + this + "]");
            System.out.println("\n*****END SESSION LOG WINDOW TEST******");
            System.out.println("...verify System.out is again the console...");
            System.err.println("...verify System.err is again the console...");
            System.out.println();
        }
    }

    public static void main(String[] args) {
        TESTING_FROM_MAIN = true;
        SessionTextLogWindow.requireSessionLogToBeLastOpenWindow();
        System.out.println("\n*****BEGIN SESSION LOG WINDOW TEST******");
        System.out.println("...printed to System.out...");
        System.err.println("...printed to System.err...");
        System.out.println("Now we start opening windows");
        SessionTextLogWindow lw1 = new SessionTextLogWindow(DEFAULT_WINDOW_TITLE + " - TEST (1 of 2)");
        lw1.setText("Session log window #1 test.\n\nWe have created: " + NEW_LINE + lw1);
        lw1.openWindow();
        TextWindow.createWindow("TEST TEXT WINDOW (EMPTY)");
        TextLogWindow lw2 = SessionTextLogWindow.createWindow(DEFAULT_WINDOW_TITLE + " - TEST (2 of 2 -> override)");
        lw2.println("Session log window #2 test");
        lw2.println();
        System.out.println("CONSOLE REDIRECTION TEST: this is being written to System.out...");
        System.err.println("CONSOLE REDIRECTION TEST: this is being written to System.err...");
        lw2.println();
        lw2.println("OK, now verify various combinations of window close order");
    }
}

