/*
 * Decompiled with CFR 0.152.
 */
package com.parcplace.pjava.Framer;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;

public class PARTSFramer {
    public static final int TWIP = 1;
    public static final int INCH = 2;
    public static final int PIXEL = 3;
    public static final int CENTIMETER = 4;
    public static int DefaultScaleUnit;
    public static int PixelsPerInch;
    public static int PixelsPerMeter;
    public float left;
    public float top;
    public float right;
    public float bottom;
    public int mask;
    public int scaleUnit;

    public PARTSFramer() {
        this.scaleUnit = 1;
        this.mask = 136;
    }

    public PARTSFramer(int scaleUnit, float left, float top, float right, float bottom, int mask) {
        this.scaleUnit = scaleUnit;
        this.left = left;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
        this.mask = mask;
    }

    public static int pixelsPerInch() {
        if (PixelsPerInch == 0) {
            PixelsPerInch = Toolkit.getDefaultToolkit().getScreenResolution();
        }
        return PixelsPerInch;
    }

    public static int pixelsPerMeter() {
        if (PixelsPerMeter == 0) {
            PixelsPerMeter = (int)((double)PARTSFramer.pixelsPerInch() * 39.3700787);
        }
        return PixelsPerMeter;
    }

    public static int pointToPixel(int pointSize) {
        return (int)((double)pointSize / 72.0 * (double)PARTSFramer.pixelsPerInch());
    }

    public static int scaleUnitToPixel(int scaleUnit, float units) {
        if (scaleUnit == 1) {
            return (int)(units * (float)PARTSFramer.pixelsPerInch() / 1440.0f);
        }
        if (scaleUnit == 2) {
            return (int)(units * (float)PARTSFramer.pixelsPerInch());
        }
        if (scaleUnit == 4) {
            return (int)(units * (float)PARTSFramer.pixelsPerMeter() / 100.0f);
        }
        return (int)units;
    }

    public static float pixelToScaleUnit(int scaleUnit, int pixels) {
        if (scaleUnit == 1) {
            return pixels * 1440 / PARTSFramer.pixelsPerInch();
        }
        if (scaleUnit == 2) {
            return pixels / PARTSFramer.pixelsPerInch();
        }
        if (scaleUnit == 4) {
            return pixels * 100 / PARTSFramer.pixelsPerMeter();
        }
        return pixels;
    }

    protected float pixelToScaleUnit(int pixels) {
        if (this.scaleUnit == 1) {
            return pixels * 1440 / PARTSFramer.pixelsPerInch();
        }
        if (this.scaleUnit == 2) {
            return pixels / PARTSFramer.pixelsPerInch();
        }
        if (this.scaleUnit == 4) {
            return pixels * 100 / PARTSFramer.pixelsPerMeter();
        }
        return pixels;
    }

    public int scaleUnitToPixel(float units) {
        if (this.scaleUnit == 1) {
            return (int)(units * (float)PARTSFramer.pixelsPerInch() / 1440.0f);
        }
        if (this.scaleUnit == 2) {
            return (int)(units * (float)PARTSFramer.pixelsPerInch());
        }
        if (this.scaleUnit == 4) {
            return (int)(units * (float)PARTSFramer.pixelsPerMeter() / 100.0f);
        }
        return (int)units;
    }

    protected boolean isBottomInset() {
        return (this.mask & 2) > 0;
    }

    protected boolean isBottomStretched() {
        return (this.mask & 1) > 0;
    }

    protected boolean isHorizontallyCentered() {
        return !this.isLeftInset() && !this.isRightInset();
    }

    protected boolean isLeftInset() {
        return (this.mask & 0x80) > 0;
    }

    protected boolean isLeftStretched() {
        return (this.mask & 0x40) > 0;
    }

    protected boolean isRightInset() {
        return (this.mask & 0x20) > 0;
    }

    protected boolean isRightStretched() {
        return (this.mask & 0x10) > 0;
    }

    protected boolean isTopInset() {
        return (this.mask & 8) > 0;
    }

    protected boolean isTopStretched() {
        return (this.mask & 4) > 0;
    }

    protected boolean isVerticallyCentered() {
        return !this.isTopInset() && !this.isBottomInset();
    }

    protected PARTSFramer unrelativeTo(Rectangle r) {
        Dimension dim = new Dimension(r.width, r.height);
        float width = this.pixelToScaleUnit(dim.width);
        float height = this.pixelToScaleUnit(dim.height);
        float newLeft = this.left;
        float newTop = this.top;
        float newRight = this.right;
        float newBottom = this.bottom;
        if (this.isLeftStretched()) {
            newLeft = this.left * width;
        }
        if (this.isBottomStretched()) {
            newBottom = this.bottom * height;
        }
        if (this.isRightStretched()) {
            newRight = this.right * width;
        }
        if (this.isTopStretched()) {
            newTop = this.top * height;
        }
        PARTSFramer framer = new PARTSFramer(this.scaleUnit, newLeft, newTop, newRight, newBottom, this.mask);
        return framer;
    }

    public Rectangle scaleFrom(Rectangle r) {
        int newBottom;
        int newTop;
        int newRight;
        int newLeft;
        PARTSFramer fixedRect = this.unrelativeTo(r);
        int fixedLeft = this.scaleUnitToPixel(fixedRect.left);
        int fixedTop = this.scaleUnitToPixel(fixedRect.top);
        int fixedRight = this.scaleUnitToPixel(fixedRect.right);
        int fixedBottom = this.scaleUnitToPixel(fixedRect.bottom);
        if (this.isLeftInset()) {
            newLeft = r.x + fixedLeft;
            newRight = this.isRightInset() ? Math.max(r.x + r.width - fixedRight, newLeft + 1) : newLeft + fixedRight;
        } else if (this.isRightInset()) {
            newRight = r.x + r.width - fixedRight;
            newLeft = newRight - fixedLeft;
        } else {
            newLeft = r.x + fixedLeft - fixedRight / 2;
            newRight = newLeft + fixedRight;
        }
        if (this.isTopInset()) {
            newTop = r.y + fixedTop;
            newBottom = this.isBottomInset() ? Math.max(r.y + r.height - fixedBottom, newTop + 1) : newTop + fixedBottom;
        } else if (this.isBottomInset()) {
            newBottom = r.y + r.height - fixedBottom;
            newTop = newBottom - fixedTop;
        } else {
            newTop = r.y + fixedTop - fixedBottom / 2;
            newBottom = newTop + fixedBottom;
        }
        return new Rectangle(newLeft, newTop, newRight - newLeft, newBottom - newTop);
    }

    public Rectangle scaleFromScreen() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        return this.scaleFrom(new Rectangle(screenSize));
    }

    static {
        PixelsPerInch = 0;
        PixelsPerMeter = 0;
    }
}

