/*
 * Decompiled with CFR 0.152.
 */
package com.glaivestone.toolbox.settings;

import com.glaivestone.javax.io.FileType;
import com.glaivestone.toolbox.settings.Settings;
import com.glaivestone.toolbox.settings.SettingsFileHolder;
import com.glaivestone.toolbox.settings.SettingsSection;
import com.glaivestone.toolbox.settings.StandardSettingsSection;
import com.glaivestone.toolbox.settings.StandardSettingsTextBackingAccessor;
import java.io.File;
import java.io.IOException;

public class StandardSettingsFileHolder
extends SettingsFileHolder {
    public static final FileType FILE_TYPE = FileType.defineConstant("INI", "ini", "settings");

    public StandardSettingsFileHolder(File backingFile) throws IOException {
        super(backingFile);
    }

    public StandardSettingsFileHolder(SettingsSection settings) {
        super(settings);
    }

    public StandardSettingsFileHolder(SettingsSection settings, File backingFile) {
        this(settings);
        this.setFile(backingFile);
    }

    protected SettingsSection constructSettings(String name) {
        return StandardSettingsFileHolder.createSettings(name);
    }

    @Override
    protected Settings loadSettingsFromBackingFile(File aFile) throws IOException {
        return StandardSettingsTextBackingAccessor.loadFromFile(aFile);
    }

    @Override
    protected void saveSettingsToBackingFile(File aFile) throws IOException {
        StandardSettingsTextBackingAccessor.writeToFile(this.getSettingsSection(), aFile);
    }

    public static SettingsSection createSettings(String name) {
        return new StandardSettingsSection(name);
    }
}

