/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.interchange;

import com.glaivestone.javax.util.PropagatedException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ussamasters.aces.racedata.interchange.FISXMLReader;
import org.ussamasters.aces.racedata.interchange.TimingSystemXMLDataImporter;
import org.ussamasters.aces.racedata.io.RaceDataIOException;
import org.ussamasters.aces.racedata.io.RaceDataIOServices;
import org.ussamasters.aces.racedata.models.CompetitorResultValue;
import org.ussamasters.aces.racedata.models.Country;
import org.ussamasters.aces.racedata.models.CourseArrangement;
import org.ussamasters.aces.racedata.models.Gender;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceDescriptor;
import org.ussamasters.aces.racedata.models.RaceEntryResult;
import org.ussamasters.aces.racedata.models.RaceIdentifier;
import org.ussamasters.aces.racedata.models.RaceOrganization;
import org.ussamasters.aces.racedata.models.Racer;
import org.ussamasters.aces.racedata.models.RacerList;
import org.ussamasters.aces.racedata.models.RacerResult;
import org.ussamasters.aces.racedata.models.SeasonIdentifier;
import org.ussamasters.aces.racedata.models.USSALicense;

public class FISXMLDataImporter
extends TimingSystemXMLDataImporter {
    public static final String[] COMPETITOR_ENTRY_COLUMN_NAMES = new String[]{"Bib", "Lastname", "Firstname", "Gender", "Yearofbirth", "NAT_code", "Class"};
    protected boolean processNonStarters = false;

    public static FISXMLDataImporter importCompetitorData(String timingData, Map<String, String> bibNumberMappingTable, Class<? extends RaceClass<?>> ageClassClass, SeasonIdentifier season, boolean processNonStarters) throws RaceDataIOException {
        FISXMLDataImporter loader = new FISXMLDataImporter();
        loader.processNonStarters = processNonStarters;
        loader.loadCompetitorData(timingData, bibNumberMappingTable, ageClassClass, season);
        return loader;
    }

    public static FISXMLDataImporter importTimingData(String timingData, Map<String, String> bibNumberMappingTable, Map<String, String> startGroupCodesMap, RaceDescriptor raceSpecification, SeasonIdentifier season) throws RaceDataIOException {
        FISXMLDataImporter loader = new FISXMLDataImporter();
        loader.loadData(timingData, bibNumberMappingTable, startGroupCodesMap, raceSpecification, season);
        return loader;
    }

    public static boolean isSupportedFormat(String timingData) {
        boolean ENABLE_XML = true;
        if (ENABLE_XML) {
            return FISXMLReader.isSupportedFormat(timingData);
        }
        return false;
    }

    protected FISXMLReader constructTimingDataReader() {
        return new FISXMLReader();
    }

    protected boolean isStarter(Map<String, Object> entryValues) {
        CompetitorResultValue competitorResult = (CompetitorResultValue)entryValues.get("Total");
        if (competitorResult == null) {
            System.out.println("###DEBUG: " + entryValues + " ###");
            CompetitorResultValue run1Result = (CompetitorResultValue)entryValues.get("FirstRun");
            return run1Result != null && run1Result.isStarter();
        }
        return competitorResult.isStarter();
    }

    public void loadCompetitorData(String timingData, Map<String, String> bibNumberMappingTable, Class<? extends RaceClass<?>> ageClassClass, SeasonIdentifier season) throws RaceDataIOException {
        this.processCompetitorData(this.loadUnprocessedTimingData(timingData), bibNumberMappingTable, ageClassClass, season);
    }

    public void loadData(String timingData, Map<String, String> bibNumberMappingTable, Map<String, String> startGroupCodesMap, RaceDescriptor aRaceSpecification, SeasonIdentifier season) throws RaceDataIOException {
        if (aRaceSpecification == null) {
            throw new IllegalArgumentException("Race specification not provided");
        }
        this.processTimingData(this.loadUnprocessedTimingData(timingData), bibNumberMappingTable, startGroupCodesMap, aRaceSpecification, season);
    }

    protected FISXMLReader loadUnprocessedTimingData(String data) throws RaceDataIOException {
        FISXMLReader dataReader = this.constructTimingDataReader();
        try {
            dataReader.load(data);
        }
        catch (RuntimeException ex) {
            throw new RaceDataIOException((Exception)ex, "Error loading race results timing data: " + ex.getMessage());
        }
        return dataReader;
    }

    protected void processCompetitorData(FISXMLReader dataReader, Map<String, String> bibNumberMappingTable, Class<? extends RaceClass<?>> ageClassClass, SeasonIdentifier season) throws RaceDataIOException {
        this.setResults(null, null);
        this.initLoadSpecifications(ageClassClass, season, bibNumberMappingTable, null);
        this.validateLoadSpecifications();
        RaceIdentifier raceID = new RaceIdentifier(dataReader.getRaceDate(), dataReader.getRaceLocation(), dataReader.getRaceType(), null);
        this.raceSpecification = new RaceDescriptor(raceID, ageClassClass, null, CourseArrangement.UNKNOWN);
        List<Map<String, Object>> competitorEntries = dataReader.getCompetitorEntries();
        RacerList competitors = this.constructEmptyRacerList();
        for (Map<String, Object> entryValues : competitorEntries) {
            if (!this.shouldProcessCompetitorEntry(entryValues)) continue;
            Racer aRacer = this.racerFromCompetitorEntry(entryValues);
            competitors.add(aRacer);
        }
        this.setResults(null, competitors);
    }

    protected void processTimingData(FISXMLReader dataReader, Map<String, String> bibNumberMappingTable, Map<String, String> startGroupCodesMap, RaceDescriptor aRaceSpecification, SeasonIdentifier season) throws RaceDataIOException {
        this.setResults(null, null);
        this.initLoadSpecifications(aRaceSpecification, season, bibNumberMappingTable, startGroupCodesMap);
        this.validateLoadSpecifications();
        this.validateRaceSpecification(dataReader);
        List<Map<String, Object>> competitorEntries = dataReader.getCompetitorEntries();
        RacerList competitors = this.constructEmptyRacerList();
        ArrayList<RacerResult> resultsList = new ArrayList<RacerResult>(competitorEntries.size());
        for (Map<String, Object> entryValues : competitorEntries) {
            if (!this.shouldProcessCompetitorEntry(entryValues)) continue;
            Racer aRacer = this.racerFromCompetitorEntry(entryValues);
            RaceEntryResult racerResult = this.racerResultFromCompetitorEntry(entryValues, aRacer);
            competitors.add(aRacer);
            resultsList.add(racerResult);
        }
        this.setResults(this.constructRaceResult(resultsList), competitors);
    }

    protected Racer racerFromCompetitorEntry(Map<String, Object> entryValues) throws RaceDataIOException {
        Racer aRacer;
        String valueDescription = null;
        String fieldValue = null;
        String[] justTheEntryValues = this.toValues(entryValues);
        try {
            RaceClass<?> nationalClass;
            valueDescription = "gender";
            fieldValue = (String)entryValues.get("Gender");
            Gender gender = Gender.getConstant(fieldValue);
            if (gender == null) {
                throw this.constructRacerDataException("Invalid gender - '" + fieldValue.toString() + "' must be M or F", justTheEntryValues);
            }
            valueDescription = "bib";
            fieldValue = (String)entryValues.get("Bib");
            int bibNumber = this.resolveBibNumber(fieldValue, justTheEntryValues);
            if (bibNumber < 0) {
                throw this.constructRacerDataException("Racer entry has missing or invalid bib number", justTheEntryValues);
            }
            valueDescription = "lastName";
            String lastName = (String)entryValues.get("LastName");
            valueDescription = "firstName";
            String firstName = (String)entryValues.get("FirstName");
            if (lastName == null || lastName.trim().length() == 0) {
                throw this.constructRacerDataException("Racer entry has no name", justTheEntryValues);
            }
            if (firstName == null || firstName.trim().length() == 0) {
                boolean nameOrderLastFirst = true;
                String[] nameElements = this.parseNameField(lastName, nameOrderLastFirst);
                if (nameElements[RaceDataIOServices.INDEX_FIRST_NAME] != "") {
                    lastName = nameElements[RaceDataIOServices.INDEX_LAST_NAME];
                    firstName = nameElements[RaceDataIOServices.INDEX_FIRST_NAME];
                } else {
                    firstName = "(unknown)";
                }
            }
            valueDescription = "yearBorn";
            fieldValue = (String)entryValues.get("YearBorn");
            int yearBorn = this.resolveYearBorn(fieldValue, justTheEntryValues);
            valueDescription = "age class (from gender/yearBorn)";
            RaceClass<?> ageClass = this.resolveRaceClassFromYOB(gender, yearBorn);
            if (ageClass != null) {
                nationalClass = ageClass.isNationalClass() ? ageClass : this.resolveRaceClassFromYOB(gender, yearBorn, this.nationalClassClass);
            } else {
                ageClass = this.raceClassHelper.getUnknownClass(this.raceClassClass, gender);
                nationalClass = this.raceClassHelper.getUnknownClass(this.nationalClassClass, gender);
            }
            valueDescription = "USSA number";
            String ussaNumber = ((String)entryValues.get("USSANumber")).toUpperCase();
            RaceOrganization licenseAffiliation = USSALicense.getAffiliation(ussaNumber);
            RaceOrganization affiliation = null;
            if (licenseAffiliation == null || licenseAffiliation == RaceOrganization.FOREIGN) {
                valueDescription = "affiliation";
                if (licenseAffiliation == RaceOrganization.FOREIGN) {
                    fieldValue = (String)entryValues.get("Team");
                    Country nationality = Country.getConstant(fieldValue);
                    if (nationality != null && nationality != Country.USA && nationality != Country.UNKNOWN) {
                        affiliation = RaceOrganization.getConstant(nationality.name);
                    }
                } else {
                    fieldValue = (String)entryValues.get("Nation");
                    RaceOrganization orgCandidate = RaceOrganization.getConstant(fieldValue);
                    if (orgCandidate != null && orgCandidate.isRecognizedOrganization() && orgCandidate != RaceOrganization.USSA) {
                        affiliation = orgCandidate;
                    }
                }
            }
            aRacer = new Racer(bibNumber, lastName, firstName);
            aRacer.initCompetitionClassValuesLenient(gender, ageClass, nationalClass, yearBorn);
            if (aRacer.getNationalClass().isUnknown() && aRacer.isBirthYearKnown()) {
                aRacer.initNationalClass(this.season);
            }
            aRacer.initLicenseValues(affiliation, ussaNumber);
        }
        catch (PropagatedException ex) {
            if (ex.getCause() instanceof Exception) {
                throw this.constructRacerDataException("Error processing " + valueDescription + " value '" + fieldValue + "'", justTheEntryValues, ex.getCause());
            }
            throw ex;
        }
        catch (RuntimeException ex) {
            throw this.constructRacerDataException("Error processing " + valueDescription + " value '" + fieldValue + "'", justTheEntryValues, ex);
        }
        return aRacer;
    }

    protected RaceEntryResult racerResultFromCompetitorEntry(Map<String, Object> entryValues, Racer aRacer) throws RaceDataIOException {
        RaceEntryResult racerResult;
        String valueDescription = null;
        String fieldValue = null;
        String[] justTheEntryValues = this.toValues(entryValues);
        try {
            RaceClass<?> racerAgeClass = aRacer.getAgeClass();
            String className = (String)entryValues.get("Class");
            RaceClass<?> raceClass = this.resolveRaceClass(aRacer.getGender(), className != null ? className.toUpperCase() : null);
            if (raceClass == null) {
                if (className == null || className.trim().isEmpty()) {
                    raceClass = racerAgeClass;
                } else {
                    throw this.constructRacerDataException("Unknown racer age class: " + className, justTheEntryValues);
                }
            }
            if (racerAgeClass.isUnknown() && raceClass.isAgeGroupClass()) {
                aRacer.setAgeClass(raceClass);
            }
            if (raceClass == null || raceClass.isUnknown()) {
                throw this.constructRacerDataException("Unable to determine racer age class", justTheEntryValues);
            }
            CompetitorResultValue firstRun = (CompetitorResultValue)entryValues.get("FirstRun");
            CompetitorResultValue secondRun = (CompetitorResultValue)entryValues.get("SecondRun");
            CompetitorResultValue total = (CompetitorResultValue)entryValues.get("Total");
            valueDescription = "RaceEntryResult creation";
            racerResult = RaceEntryResult.createResult(aRacer.getBibNumber(), raceClass, aRacer.getLastName(), aRacer.getFirstName(), this.nRaceRuns);
            valueDescription = "timing data";
            switch (this.nRaceRuns) {
                case 1: {
                    racerResult.setTimingData(total);
                    break;
                }
                case 2: {
                    racerResult.setTimingData(firstRun, secondRun, total);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Invalid race runs count: " + this.nRaceRuns);
                }
            }
            racerResult.validateTimingData();
        }
        catch (PropagatedException ex) {
            if (ex.getCause() instanceof Exception) {
                throw this.constructRacerDataException("Error processing " + valueDescription + " value '" + fieldValue + "'", justTheEntryValues, ex.getCause());
            }
            throw ex;
        }
        catch (RuntimeException ex) {
            throw this.constructRacerDataException("Error processing " + valueDescription + " value '" + fieldValue + "'", justTheEntryValues, ex);
        }
        return racerResult;
    }

    protected CompetitorResultValue<?>[] computeRunResults(Map<String, Object> entryValues) {
        return null;
    }

    protected boolean shouldProcessCompetitorEntry(Map<String, Object> entryValues) {
        if (this.processNonStarters) {
            return true;
        }
        return this.isStarter(entryValues);
    }

    protected String[] toValues(Map<String, Object> entryValues) {
        int nValues = entryValues.size();
        String[] values = new String[nValues];
        int i = 0;
        for (Object value : entryValues.values()) {
            if (value == null) {
                System.out.println("###DEBUG: " + entryValues + " ###");
            }
            values[i] = value.toString();
            ++i;
        }
        return values;
    }

    protected void validateRaceSpecification(FISXMLReader dataReader) throws RaceDataIOException {
        this.validateRaceSpecification(dataReader.getRaceType(), dataReader.getRaceDate(), dataReader.getRaceLocation());
    }
}

