/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.interchange;

import com.glaivestone.javax.util.PropagatedException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ussamasters.aces.racedata.interchange.TimingSystemDataImporter;
import org.ussamasters.aces.racedata.io.CSVInputDataReader;
import org.ussamasters.aces.racedata.io.RaceDataIOException;
import org.ussamasters.aces.racedata.io.RaceDataIOServices;
import org.ussamasters.aces.racedata.models.Gender;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceDescriptor;
import org.ussamasters.aces.racedata.models.RaceEntryResult;
import org.ussamasters.aces.racedata.models.Racer;
import org.ussamasters.aces.racedata.models.RacerList;
import org.ussamasters.aces.racedata.models.RacerResult;
import org.ussamasters.aces.racedata.models.SeasonIdentifier;

public class TimingSystemCSVDataImporter
extends TimingSystemDataImporter {
    public static final String[] SPLIT_SECOND_TIMING_DATA_COLUMN_NAMES = new String[]{"Bib", "Class", "division (ignored)", "Name", "FirstRun", "SecondRun", "Total"};
    protected String[] columnNames;
    protected boolean processNonStarters = false;
    protected Gender defaultGender;
    protected RaceClass<?> defaultClass;

    public static TimingSystemCSVDataImporter importCompetitorData(String timingData, String[] columnNames, Map<String, String> bibNumberMappingTable, Map<String, String> startGroupCodesMap, Class<? extends RaceClass<?>> ageClassClass, SeasonIdentifier season, boolean processNonStarters) throws RaceDataIOException {
        TimingSystemCSVDataImporter loader = new TimingSystemCSVDataImporter();
        loader.processNonStarters = processNonStarters;
        loader.loadCompetitorData(timingData, columnNames, bibNumberMappingTable, ageClassClass, season);
        return loader;
    }

    public static TimingSystemCSVDataImporter importTimingData(File timingDataFile, String[] columnNames, Map<String, String> bibNumberMappingTable, Map<String, String> startGroupCodesMap, RaceDescriptor raceSpecification, SeasonIdentifier season) throws RaceDataIOException {
        TimingSystemCSVDataImporter loader = new TimingSystemCSVDataImporter();
        loader.loadFile(timingDataFile, columnNames, bibNumberMappingTable, startGroupCodesMap, raceSpecification, season);
        return loader;
    }

    public static TimingSystemCSVDataImporter importTimingData(String timingData, String[] columnNames, Map<String, String> bibNumberMappingTable, Map<String, String> startGroupCodesMap, RaceDescriptor raceSpecification, SeasonIdentifier season) throws RaceDataIOException {
        TimingSystemCSVDataImporter loader = new TimingSystemCSVDataImporter();
        loader.loadData(timingData, columnNames, bibNumberMappingTable, startGroupCodesMap, raceSpecification, season);
        return loader;
    }

    protected void checkEntryFormat(List<String[]> competitorEntries) throws RaceDataIOException {
        String[] firstLine = competitorEntries.get(0);
        if (firstLine.length > 0 && firstLine[0].toLowerCase().startsWith("<?xml")) {
            throw new RaceDataIOException("Loading race results from XML format data is not yet supported.");
        }
    }

    protected void clearOptionDefaults() {
        this.defaultGender = null;
        this.defaultClass = null;
    }

    protected CSVInputDataReader constructTimingDataReader(String[] columnNames) {
        CSVInputDataReader csvReader = new CSVInputDataReader(columnNames);
        csvReader.setFilterCommentLines(true);
        return csvReader;
    }

    public void loadCompetitorData(String timingData, String[] columnNames, Map<String, String> bibNumberMappingTable, Class<? extends RaceClass<?>> ageClassClass, SeasonIdentifier season) throws RaceDataIOException {
        this.processCompetitorData(this.loadUnprocessedTimingData(timingData, columnNames), columnNames, bibNumberMappingTable, ageClassClass, season);
    }

    public void loadData(String timingData, String[] columnNames, Map<String, String> bibNumberMappingTable, Map<String, String> startGroupCodesMap, RaceDescriptor aRaceSpecification, SeasonIdentifier season) throws RaceDataIOException {
        this.processTimingData(this.loadUnprocessedTimingData(timingData, columnNames), columnNames, bibNumberMappingTable, startGroupCodesMap, aRaceSpecification, season);
    }

    public void loadFile(File timingDataFile, String[] columnNames, Map<String, String> bibNumberMappingTable, Map<String, String> startGroupCodesMap, RaceDescriptor aRaceSpecification, SeasonIdentifier season) throws RaceDataIOException {
        this.processTimingData(this.loadUnprocessedTimingData(timingDataFile, columnNames), columnNames, bibNumberMappingTable, startGroupCodesMap, aRaceSpecification, season);
    }

    protected CSVInputDataReader loadUnprocessedTimingData(File aFile, String[] columnNames) throws RaceDataIOException {
        CSVInputDataReader dataReader = this.constructTimingDataReader(columnNames);
        try {
            dataReader.loadData(aFile);
        }
        catch (FileNotFoundException ex) {
            throw new RaceDataIOException("Race results timing data file not found: '" + aFile.getAbsolutePath() + "'");
        }
        catch (IOException | RuntimeException ex) {
            throw new RaceDataIOException(ex, String.format("Error loading race results timing data file '%s': %s", aFile.getAbsolutePath(), ex.getMessage()));
        }
        return dataReader;
    }

    protected CSVInputDataReader loadUnprocessedTimingData(String data, String[] columnNames) throws RaceDataIOException {
        CSVInputDataReader dataReader = this.constructTimingDataReader(columnNames);
        try {
            dataReader.loadData(data);
        }
        catch (IOException | RuntimeException ex) {
            throw new RaceDataIOException(ex, "Error loading race results timing data: " + ex.getMessage());
        }
        return dataReader;
    }

    protected boolean processLoadOptionSetting(String[] entryValues) throws RaceDataIOException {
        if (entryValues.length < 3 || !"_SetDefault".equals(entryValues[0])) {
            return false;
        }
        String optionName = entryValues[1];
        String optionValue = entryValues[2];
        if (optionName.equals("Gender")) {
            Gender gender = Gender.getConstant(optionValue);
            if (optionValue.equals("null")) {
                gender = null;
                optionValue = "";
            }
            if (optionValue.length() > 0 && gender == null) {
                throw new RaceDataIOException("Invalid default setting for " + optionName + ": " + optionValue);
            }
            if (gender != null) {
                this.defaultGender = gender;
            }
            return true;
        }
        if (optionName.equals("Class")) {
            RaceClass<?> raceClass = this.resolveRaceClassName(optionValue);
            if (optionValue.equals("null")) {
                raceClass = null;
                optionValue = "";
            }
            if (optionValue.length() > 0 && raceClass == null) {
                throw new RaceDataIOException("Invalid default setting for " + optionName + ": " + optionValue);
            }
            this.defaultClass = raceClass;
            return true;
        }
        throw new RaceDataIOException("Unknown option: " + optionName + " (" + optionValue + ")");
    }

    protected void processCompetitorData(CSVInputDataReader dataReader, String[] columnNames, Map<String, String> bibNumberMappingTable, Class<? extends RaceClass<?>> ageClassClass, SeasonIdentifier season) throws RaceDataIOException {
        this.setResults(null, null);
        this.initLoadSpecifications(ageClassClass, season, bibNumberMappingTable, null);
        this.raceSpecification = RaceDescriptor.constructPlaceholderSpec(season);
        this.columnNames = columnNames;
        this.validateLoadSpecifications();
        List<String[]> competitorEntries = dataReader.getEntries();
        if (competitorEntries.size() > 0) {
            this.checkEntryFormat(competitorEntries);
        }
        RacerList competitors = this.constructEmptyRacerList();
        this.clearOptionDefaults();
        for (String[] entryValues : competitorEntries) {
            Map<String, String> entryMap = dataReader.asEntryMap(entryValues);
            if (this.processLoadOptionSetting(entryValues)) continue;
            Racer aRacer = this.racerFromCompetitorEntry(entryValues, entryMap);
            competitors.add(aRacer);
        }
        this.clearOptionDefaults();
        this.setResults(null, competitors);
    }

    protected void processTimingData(CSVInputDataReader dataReader, String[] columnNames, Map<String, String> bibNumberMappingTable, Map<String, String> startGroupCodesMap, RaceDescriptor aRaceSpecification, SeasonIdentifier season) throws RaceDataIOException {
        this.setResults(null, null);
        this.initLoadSpecifications(aRaceSpecification, season, bibNumberMappingTable, startGroupCodesMap);
        this.columnNames = columnNames;
        this.validateLoadSpecifications();
        List<String[]> competitorEntries = dataReader.getEntries();
        if (competitorEntries.size() > 0) {
            this.checkEntryFormat(competitorEntries);
        }
        RacerList competitors = this.constructEmptyRacerList();
        ArrayList<RacerResult> resultsList = new ArrayList<RacerResult>(competitorEntries.size());
        this.clearOptionDefaults();
        for (String[] entryValues : competitorEntries) {
            Map<String, String> entryMap = dataReader.asEntryMap(entryValues);
            if (this.processLoadOptionSetting(entryValues)) continue;
            Racer aRacer = this.racerFromCompetitorEntry(entryValues, entryMap);
            RaceEntryResult racerResult = this.racerResultFromCompetitorEntry(entryValues, entryMap, aRacer);
            competitors.add(aRacer);
            resultsList.add(racerResult);
        }
        this.clearOptionDefaults();
        this.setResults(this.constructRaceResult(resultsList), competitors);
    }

    protected Racer racerFromCompetitorEntry(String[] entryValues, Map<String, String> fieldMap) throws RaceDataIOException {
        Racer aRacer;
        String valueDescription = null;
        String fieldValue = null;
        try {
            RaceClass<?> ageClass;
            String startGroupCode;
            String firstName;
            String lastName;
            Gender gender = null;
            valueDescription = "Bib";
            fieldValue = fieldMap.get("Bib");
            int bibNumber = this.resolveBibNumber(fieldValue, entryValues);
            if (bibNumber < 0) {
                throw this.constructRacerDataException("Racer entry has missing or invalid bib number", entryValues);
            }
            valueDescription = "Name";
            fieldValue = fieldMap.get("Name");
            boolean nameOrderLastFirst = true;
            if (fieldValue == null && (fieldValue = fieldMap.get("NameFirstLast")) != null) {
                nameOrderLastFirst = false;
            }
            if (fieldValue != null) {
                String[] nameElements = this.parseNameField(fieldValue, nameOrderLastFirst);
                lastName = nameElements[RaceDataIOServices.INDEX_LAST_NAME];
                firstName = nameElements[RaceDataIOServices.INDEX_FIRST_NAME];
            } else {
                valueDescription = "LastName, FirstName";
                lastName = fieldMap.get("LastName");
                firstName = fieldMap.get("FirstName");
            }
            if (lastName == null || lastName.trim().length() == 0) {
                throw this.constructRacerDataException("Racer entry has no name", entryValues);
            }
            if (firstName == null || firstName.trim().length() == 0) {
                firstName = "(unknown)";
            }
            valueDescription = "gender";
            gender = Gender.getConstant(fieldMap.get("Gender"));
            valueDescription = "yearBorn";
            int yearBorn = this.resolveYearBorn(fieldMap.get("YearBorn"), entryValues);
            valueDescription = "Class";
            fieldValue = fieldMap.get("Class");
            RaceClass<?> raceClass = this.resolveRaceClass(fieldValue);
            if (raceClass == null && fieldValue != null && fieldValue.length() > 0 && !Character.isLetter(fieldValue.charAt(0))) {
                if (gender != null) {
                    raceClass = this.resolveRaceClass(gender.name + fieldValue);
                } else if (this.defaultGender != null) {
                    raceClass = this.resolveRaceClass(this.defaultGender.name + fieldValue);
                }
            }
            if (raceClass != null && gender == null) {
                gender = raceClass.getGender();
            }
            RaceClass<?> calculatedAgeClass = this.resolveRaceClassFromYOB(gender, yearBorn);
            if (raceClass == null || raceClass.isUnknown()) {
                raceClass = calculatedAgeClass;
            }
            if ((startGroupCode = fieldMap.get("StartGroupCode")) != null && startGroupCode.length() > 0) {
                valueDescription = "Class (from StartGroupCode)";
                raceClass = this.resolveRaceClassFromStartGroupCode(startGroupCode, raceClass, entryValues);
            }
            if (raceClass == null) {
                raceClass = this.defaultClass;
            }
            if (raceClass != null && calculatedAgeClass != null && raceClass.isAgeGroupClass() && !raceClass.equals(calculatedAgeClass)) {
                throw this.constructRacerDataException("Inconsistent racer age class for age", entryValues);
            }
            RaceClass<?> raceClass2 = ageClass = raceClass != null & raceClass.isAgeGroupClass() ? raceClass : calculatedAgeClass;
            if (gender == null) {
                if (raceClass != null) {
                    gender = raceClass.getGender();
                } else if (this.defaultGender != null) {
                    gender = this.defaultGender;
                }
            }
            if (gender == null) {
                throw this.constructRacerDataException("Unable to determine racer gender", entryValues);
            }
            valueDescription = "USSA number";
            String ussaNumber = fieldMap.get("USSANumber");
            if (ussaNumber != null) {
                ussaNumber = ussaNumber.toUpperCase();
            }
            aRacer = new Racer(bibNumber, lastName, firstName);
            aRacer.initCompetitionClassValuesLenient(gender, ageClass, null, yearBorn);
            if (aRacer.getNationalClass().isUnknown() && aRacer.isBirthYearKnown()) {
                aRacer.initNationalClass(this.season);
            }
            aRacer.initLicenseValues(null, ussaNumber);
        }
        catch (PropagatedException ex) {
            if (ex.getCause() instanceof Exception) {
                throw this.constructRacerDataException("Error processing " + valueDescription + " value '" + fieldValue + "'", entryValues, ex.getCause());
            }
            throw ex;
        }
        catch (RuntimeException ex) {
            throw this.constructRacerDataException("Error processing " + valueDescription + " value '" + fieldValue + "'", entryValues, ex);
        }
        return aRacer;
    }

    protected RaceEntryResult racerResultFromCompetitorEntry(String[] entryValues, Map<String, String> fieldMap, Racer aRacer) throws RaceDataIOException {
        RaceEntryResult racerResult;
        String valueDescription = null;
        String fieldValue = null;
        try {
            String startGroupCode;
            RaceClass<?> racerAgeClass;
            RaceClass<?> raceClass = racerAgeClass = aRacer.getAgeClass();
            valueDescription = "Class";
            fieldValue = fieldMap.get("Class");
            raceClass = this.resolveRaceClass(fieldValue);
            if (raceClass == null && fieldValue != null && fieldValue.length() > 0 && !Character.isLetter(fieldValue.charAt(0))) {
                raceClass = this.resolveRaceClass(aRacer.getGender().name + fieldValue);
            }
            if (!(raceClass != null && !raceClass.isUnknown() || !aRacer.hasValidAgeClass() || this.defaultClass != null && this.defaultClass.isAbilityGroupClass())) {
                raceClass = racerAgeClass;
            }
            if ((startGroupCode = fieldMap.get("StartGroupCode")) != null && startGroupCode.length() > 0) {
                valueDescription = "Class (from StartGroupCode)";
                raceClass = this.resolveRaceClassFromStartGroupCode(startGroupCode, raceClass, entryValues);
            }
            if (raceClass == null) {
                raceClass = this.defaultClass;
            }
            if (raceClass == null) {
                throw this.constructRacerDataException("Unable to determine racer age class", entryValues);
            }
            String firstRun = fieldMap.get("FirstRun");
            String secondRun = fieldMap.get("SecondRun");
            String total = fieldMap.get("Total");
            valueDescription = "RaceEntryResult creation";
            racerResult = RaceEntryResult.createResult(aRacer.getBibNumber(), raceClass, aRacer.getLastName(), aRacer.getFirstName(), this.nRaceRuns);
            valueDescription = "timing data";
            switch (this.nRaceRuns) {
                case 1: {
                    racerResult.setTimingData(total);
                    break;
                }
                case 2: {
                    racerResult.setTimingData(firstRun, secondRun, total);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Invalid race runs count: " + this.nRaceRuns);
                }
            }
            racerResult.validateTimingData();
        }
        catch (PropagatedException ex) {
            if (ex.getCause() instanceof Exception) {
                throw this.constructRacerDataException("Error processing " + valueDescription + " value '" + fieldValue + "'", entryValues, ex.getCause());
            }
            throw ex;
        }
        catch (RuntimeException ex) {
            throw this.constructRacerDataException("Error processing " + valueDescription + " value '" + fieldValue + "'", entryValues, ex);
        }
        return racerResult;
    }

    protected boolean shouldProcessCompetitorEntry(String[] entryValues, Map<String, String> fieldMap, Racer aRacer) throws RaceDataIOException {
        if (this.processNonStarters) {
            return true;
        }
        RaceEntryResult racerResult = this.racerResultFromCompetitorEntry(entryValues, fieldMap, aRacer);
        return racerResult.isStarter();
    }

    @Override
    protected void validateLoadSpecifications() throws RaceDataIOException {
        super.validateLoadSpecifications();
        if (this.startGroupCodesMap == null) {
            for (int i = 0; i < this.columnNames.length; ++i) {
                if (!this.columnNames[i].equals("StartGroupCode")) continue;
                throw new RaceDataIOException("Specification for mapping start group code to age class is required but was not provided.");
            }
        }
    }
}

