/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.io;

import java.io.PrintStream;
import java.io.PrintWriter;

public class RaceDataIOException
extends Exception {
    private static final long serialVersionUID = -543531065167297918L;
    protected Object data;
    protected Throwable originalException;

    public RaceDataIOException(Exception originalException) {
        this(originalException, null, originalException.getMessage());
    }

    public RaceDataIOException(Exception originalException, Object data) {
        this(originalException, data, originalException.getMessage());
    }

    public RaceDataIOException(Exception originalException, Object data, String message) {
        super(message);
        this.data = data;
        this.originalException = originalException;
    }

    public RaceDataIOException(Exception originalException, String message) {
        this(originalException, null, message);
    }

    public RaceDataIOException(Object data, String message) {
        this(null, data, message);
    }

    public RaceDataIOException(String message) {
        this(null, null, message);
    }

    public Object getData() {
        return this.data;
    }

    public Throwable getOriginalException() {
        return this.originalException;
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintStream ps) {
        PrintStream printStream = ps;
        synchronized (printStream) {
            if (this.data != null) {
                ps.println("***I/O ERROR processing race data: " + this.data);
            }
            super.printStackTrace(ps);
            if (this.originalException != null) {
                ps.println("***FROM ORIGINAL EXCEPTION:");
                this.originalException.printStackTrace(ps);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintWriter pw) {
        PrintWriter printWriter = pw;
        synchronized (printWriter) {
            if (this.data != null) {
                pw.println("***I/O ERROR processing race data: " + this.data);
            }
            super.printStackTrace(pw);
            if (this.originalException != null) {
                pw.println("***FROM ORIGINAL EXCEPTION:");
                this.originalException.printStackTrace(pw);
            }
        }
    }
}

