/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.io;

import com.glaivestone.javax.io.FileType;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.ussamasters.aces.racedata.io.RaceDataIOException;
import org.ussamasters.javax.lang.SubclassResponsibility;

public abstract class RaceDataWriter {
    protected RaceDataWriter() {
    }

    public String composeFileName(String baseFileName) {
        return this.fileType().composeFileName(baseFileName);
    }

    protected String constructFileName() {
        throw new SubclassResponsibility();
    }

    protected Writer constructWriter(FileWriter fs) {
        return new PrintWriter(new BufferedWriter(fs));
    }

    protected FileType fileType() {
        throw new SubclassResponsibility();
    }

    public abstract void write(Writer var1) throws RaceDataIOException;

    public File writeFile(File aFile) throws RaceDataIOException {
        try (FileWriter fs = new FileWriter(aFile);){
            Writer aWriter = this.constructWriter(fs);
            this.write(aWriter);
            aWriter.flush();
        }
        catch (IOException ex) {
            throw new RaceDataIOException(ex);
        }
        return aFile;
    }

    public File writeFile(String aPathName) throws RaceDataIOException {
        return this.writeFile(new File(aPathName));
    }

    public File writeFileIn(File aDirectory) throws RaceDataIOException {
        return this.writeFileIn(aDirectory, this.constructFileName());
    }

    public File writeFileIn(File aDirectory, String fileName) throws RaceDataIOException {
        return this.writeFile(new File(aDirectory, fileName));
    }
}

