/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.io;

import com.glaivestone.javax.io.FileType;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.jdom2.Document;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.ussamasters.aces.racedata.io.RaceDataIOConstants;
import org.ussamasters.aces.racedata.io.RaceDataIOException;
import org.ussamasters.aces.racedata.io.RaceDataWriter;

public class RaceDataXMLWriter
extends RaceDataWriter {
    public static final Format FORMAT_OPTIONS = RaceDataXMLWriter.constructStandardFormat();
    protected Document document;

    public RaceDataXMLWriter(Document aDocument) {
        this.document = aDocument;
    }

    protected static Format constructStandardFormat() {
        Format formatOptions = Format.getPrettyFormat();
        formatOptions.setIndent("    ");
        return formatOptions;
    }

    @Override
    protected Writer constructWriter(FileWriter fs) {
        return new BufferedWriter(fs);
    }

    @Override
    protected FileType fileType() {
        return RaceDataIOConstants.FILE_TYPE_XML;
    }

    @Override
    public void write(Writer aWriter) throws RaceDataIOException {
        XMLOutputter xmlWriter = new XMLOutputter(FORMAT_OPTIONS);
        try {
            xmlWriter.output(this.document, aWriter);
        }
        catch (IOException ex) {
            throw new RaceDataIOException(ex);
        }
    }
}

