/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.models;

import org.ussamasters.aces.racedata.models.FISMastersGroup;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceClassGroup;
import org.ussamasters.aces.racedata.models.RaceClassType;
import org.ussamasters.aces.racedata.models.RaceOrganization;

public abstract class FISMastersClass<K extends FISMastersClass<K>>
extends RaceClass<K> {
    private static final Class<FISMastersClass> THIS_CLASS = FISMastersClass.class;
    public static final RaceClassType RACE_CLASS_TYPE = RaceClassType.fis_masters;
    protected static final int AGE_RANGE = 5;
    public final FISMastersGroup<?> group;

    protected FISMastersClass(String name, int startAge, String description, FISMastersGroup<?> group) {
        this(name, startAge, startAge + 5 - 1, description, group);
    }

    protected FISMastersClass(String name, int startAge, int endAge, String description, FISMastersGroup<?> group) {
        super(name, startAge, endAge, description, RaceOrganization.USSA);
        this.group = group;
        this.validateGroup();
    }

    @Override
    public int getAgeRange() {
        return 5;
    }

    @Override
    public RaceClassGroup<?> getGroup() {
        return this.group;
    }

    @Override
    public RaceClassType getRaceClassType() {
        return RACE_CLASS_TYPE;
    }

    @Override
    public boolean isInternationalClass() {
        return true;
    }

    @Override
    protected String toAttributeDescriptionString() {
        return super.toAttributeDescriptionString() + (this.isAgeGroupClass() && this.group != null ? " -> " + this.group.toConstantName() : "");
    }

    protected void validateGroup() {
        if (this.group != null && !this.group.isUnknown()) {
            if (this.group.gender != this.gender) {
                throw new IllegalArgumentException("Invalid FIS Masters group for " + this.toConstantName() + ": " + this.group + " has different gender");
            }
            if (this.isAgeGroupClass() && !this.group.includesAgeRange(this)) {
                throw new IllegalArgumentException("Invalid FIS Masters group for " + this.toConstantName() + ": " + this.group + " has disjoint age range");
            }
        }
    }

    @Override
    protected void validateNameSuffix(String classNameSuffix) {
        if (classNameSuffix.equals("UNK")) {
            return;
        }
        this.validateNameSuffixLength(classNameSuffix, 2);
        super.validateNameSuffix(classNameSuffix);
    }
}

