/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.models;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ussamasters.aces.racedata.models.PolicyID;

public class PolicyRegistry<PT> {
    protected List<PolicyID> policyIDs = new ArrayList<PolicyID>();
    protected List<String> policyNames = new ArrayList<String>();
    protected List<PT> policies = new ArrayList<PT>();
    protected Map<PolicyID, PT> policyRegistry = new HashMap<PolicyID, PT>();

    public List<PolicyID> getPolicyIDs() {
        return this.policyIDs;
    }

    public List<String> getPolicyNames() {
        return this.policyNames;
    }

    public PT get(PolicyID policyID) {
        return this.policyRegistry.get(policyID);
    }

    public PolicyID getPolicyID(String policyName) {
        for (PolicyID policyID : this.policyRegistry.keySet()) {
            if (!policyID.name.equals(policyName)) continue;
            return policyID;
        }
        return null;
    }

    public List<PT> getPolicies() {
        return this.policies;
    }

    public void registerPolicy(PolicyID policyID, PT policy) {
        this.policyIDs.add(policyID);
        this.policyNames.add(policyID.name);
        this.policies.add(policy);
        this.policyRegistry.put(policyID, policy);
    }
}

