/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.models;

import com.glaivestone.javax.execution.EvaluableAction;
import com.glaivestone.javax.execution.MessageAction;
import com.glaivestone.javax.execution.StaticMethodAction;
import com.glaivestone.javax.lang.ClassX;
import com.glaivestone.javax.lang.ConstantValue;
import com.glaivestone.javax.lang.ConstantValueWithDescription;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.NotImplementedException;
import org.ussamasters.aces.racedata.models.Gender;
import org.ussamasters.aces.racedata.models.NationalClass_2000;
import org.ussamasters.aces.racedata.models.NationalClass_2016;
import org.ussamasters.aces.racedata.models.RaceClassGroup;
import org.ussamasters.aces.racedata.models.RaceClassType;
import org.ussamasters.aces.racedata.models.RaceDataConstant;
import org.ussamasters.aces.racedata.models.RaceOrganization;
import org.ussamasters.aces.racedata.models.StandingsCategory;
import org.ussamasters.javax.lang.SubclassResponsibility;

public abstract class RaceClass<K extends RaceClass<K>>
extends ConstantValueWithDescription<K>
implements RaceDataConstant,
StandingsCategory {
    private static final Class<RaceClass> THIS_CLASS = RaceClass.class;
    public static final int MAX_AGE = 999;
    private static boolean staticDataResolved = false;
    private static final List<String> nationalRaceClassNames = Arrays.asList("NationalClass_2000", "NationalClass_2016");
    private static final List<String> divisionRaceClassNames = Arrays.asList("FarWestClass_10yr", "FarWestClass_2010", "FarWestClass_2016", "IntermountainClass_2000", "IntermountainClass_2016", "IntermountainClass_2025", "RockyMountainClass", "NorthernClass");
    private static final List<String> internationalRaceClassNames = Arrays.asList("FISMastersClass_2000", "FISMastersClass_2020", "FISMastersClass_2025");
    private static final List<String> generation2016ClassNames = Arrays.asList("NationalClass_2016", "FarWestClass_2016", "IntermountainClass_2016", "IntermountainClass_2025", "FISMastersClass_2020");
    private static List<Class<? extends RaceClass<?>>> divisionRaceClasses;
    private static List<Class<? extends RaceClass<?>>> nationalRaceClasses;
    private static List<Class<? extends RaceClass<?>>> allRaceClasses;
    private static Map<Class<? extends RaceClass<?>>, EvaluableAction> divisionClassFromNationalClassActionRegistry;
    private static Map<Class<? extends RaceClass<?>>, EvaluableAction> getConstantActionRegistry;
    private static Map<Class<? extends RaceClass<?>>, RaceClass<?>[]> unknownClassConstantsRegistry;
    private static Map<Class<? extends RaceClass<?>>, RaceClass<?>[]> abilityGroupClassConstantsRegistry;
    public final Gender gender;
    public final int startAge;
    public final int endAge;
    public final RaceOrganization affiliation;

    protected RaceClass(String name, int startAge, int endAge, String description, RaceOrganization affiliation) {
        super(-1, name, description);
        this.gender = RaceClass.getGender(name);
        this.validateName();
        this.startAge = startAge;
        this.endAge = endAge;
        this.affiliation = affiliation;
    }

    protected static MessageAction constructAction(Class<? extends RaceClass<?>> raceClassClass, String selector, Class<?>[] parmTypes, Class<?> returnType, boolean isRequiredService) {
        StaticMethodAction anAction = StaticMethodAction.create(raceClassClass, selector, parmTypes);
        if (anAction == null) {
            if (isRequiredService) {
                throw new NotImplementedException(String.format("Required static method not implemented by %s: %s", raceClassClass.getSimpleName(), ClassX.toSimpleSignatureDescription(selector, parmTypes, returnType)));
            }
            return null;
        }
        if (!anAction.getMethod().getReturnType().equals(returnType)) {
            throw new UnsupportedOperationException(String.format("Incorrect return type on static method implemented by %s: %s", raceClassClass.getSimpleName(), ClassX.toSimpleSignatureDescription(anAction.getMethod())));
        }
        return anAction;
    }

    protected static Map<Class<? extends RaceClass<?>>, EvaluableAction> constructDivisionClassFromNationalClassActionRegistry() {
        String selector = "forNationalClass";
        Class[] parmTypes_2000 = new Class[]{NationalClass_2000.class};
        Class[] parmTypes_2016 = new Class[]{NationalClass_2016.class};
        boolean isRequiredService = true;
        HashMap mappingTable = new HashMap();
        for (Class<RaceClass<?>> raceClassClass : allRaceClasses) {
            if (nationalRaceClasses.contains(raceClassClass)) continue;
            String raceClassName = raceClassClass.getSimpleName();
            Class[] parmTypes = generation2016ClassNames.contains(raceClassName) ? parmTypes_2016 : parmTypes_2000;
            Class<RaceClass<?>> returnType = raceClassClass;
            MessageAction anAction = RaceClass.constructAction(raceClassClass, selector, parmTypes, returnType, isRequiredService);
            mappingTable.put(raceClassClass, anAction);
        }
        return mappingTable;
    }

    protected static Map<Class<? extends RaceClass<?>>, EvaluableAction> constructGetConstantActionRegistry() {
        String selector = "getConstant";
        Class[] parmTypes = new Class[]{String.class};
        boolean isRequiredService = true;
        HashMap mappingTable = new HashMap();
        Iterator<Class<RaceClass<?>>> iterator = allRaceClasses.iterator();
        while (iterator.hasNext()) {
            Class<RaceClass<?>> raceClassClass;
            Class<RaceClass<?>> returnType = raceClassClass = iterator.next();
            MessageAction anAction = RaceClass.constructAction(raceClassClass, selector, parmTypes, returnType, isRequiredService);
            mappingTable.put(raceClassClass, anAction);
        }
        return mappingTable;
    }

    protected static RaceClass<?>[] constructAbilityGroupClassConstantsEntry(Class<? extends RaceClass<?>> raceClassClass) {
        int nValues = Gender.values().size();
        RaceClass[] specialConstants = new RaceClass[nValues];
        int nFound = 0;
        for (ConstantValue<?> cnst : RaceClass.getConstantValues(raceClassClass)) {
            RaceClass aRaceClass = (RaceClass)cnst;
            if (!aRaceClass.isAbilityGroupClass()) continue;
            ++nFound;
            specialConstants[aRaceClass.getGender().ord] = aRaceClass;
        }
        if (nFound == 0) {
            return null;
        }
        return specialConstants;
    }

    protected static RaceClass<?>[] constructUnknownClassConstantsEntry(Class<? extends RaceClass<?>> raceClassClass) {
        int nValues = Gender.values().size();
        RaceClass[] specialConstants = new RaceClass[nValues];
        int nFound = 0;
        for (ConstantValue<?> cnst : RaceClass.getConstantValues(raceClassClass)) {
            RaceClass aRaceClass = (RaceClass)cnst;
            if (!aRaceClass.isUnknown()) continue;
            ++nFound;
            specialConstants[aRaceClass.getGender().ord] = aRaceClass;
        }
        if (nFound != nValues) {
            throw new IllegalStateException("Required UNK constants not defined in " + raceClassClass.getSimpleName());
        }
        return specialConstants;
    }

    public static void ensureInitialized() {
        if (!staticDataResolved) {
            RaceClass.resolveStaticData();
        }
    }

    public static RaceClass<?> forAge(Gender gender, int age, Class<? extends RaceClass<?>> raceClassClass) {
        List<ConstantValue<?>> definedConstants = RaceClass.getConstantValues(raceClassClass);
        if (definedConstants == null) {
            return null;
        }
        for (ConstantValue<?> cnst : definedConstants) {
            RaceClass aRaceClass = (RaceClass)cnst;
            if (aRaceClass.getGender() != gender || !aRaceClass.includesAge(age)) continue;
            return aRaceClass;
        }
        return null;
    }

    public static RaceClass<?> forAgeRange(Gender gender, int startAge, int endAge, Class<? extends RaceClass<?>> raceClassClass) {
        List<ConstantValue<?>> definedConstants = RaceClass.getConstantValues(raceClassClass);
        if (definedConstants == null) {
            return null;
        }
        for (ConstantValue<?> cnst : definedConstants) {
            RaceClass aRaceClass = (RaceClass)cnst;
            if (aRaceClass.isUnknown() || aRaceClass.isAbilityGroupClass() || aRaceClass.getGender() != gender || !aRaceClass.includesAgeRange(startAge, endAge)) continue;
            return aRaceClass;
        }
        return null;
    }

    public static List<Class<? extends RaceClass<?>>> getAllRaceClasses() {
        if (!staticDataResolved) {
            RaceClass.resolveStaticData();
        }
        return allRaceClasses;
    }

    public static List<? extends RaceClass<?>> getRaceClassValues(Class<? extends RaceClass<?>> raceClassClass) {
        return RaceClass.getConstantValues(raceClassClass);
    }

    public static List<? extends StandingsCategory> getStandingsCategories(Class<? extends RaceClass<?>> raceClassClass) {
        return RaceClass.getConstantValues(raceClassClass);
    }

    public static EvaluableAction getConverter(Class<? extends RaceClass<?>> aRaceClassClass, Class<? extends RaceClass<?>> targetRaceClassClass) {
        if (RaceClass.getNationalRaceClasses().contains(aRaceClassClass)) {
            return divisionClassFromNationalClassActionRegistry.get(targetRaceClassClass);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RaceClass<?> getDivisionAgeClass(RaceClass<?> nationalClass, Class<? extends RaceClass<?>> divisionRaceClassClass) {
        RaceClass aRaceClass;
        if (!nationalClass.isNationalClass()) {
            return null;
        }
        Class<?> nationalClassClass = nationalClass.getClass();
        EvaluableAction getDivisionAgeClassAction = RaceClass.getConverter(nationalClassClass, divisionRaceClassClass);
        if (getDivisionAgeClassAction == null) {
            return null;
        }
        EvaluableAction evaluableAction = getDivisionAgeClassAction;
        synchronized (evaluableAction) {
            aRaceClass = (RaceClass)getDivisionAgeClassAction.evaluate(nationalClass);
        }
        return aRaceClass;
    }

    public static List<Class<? extends RaceClass<?>>> getDivisionRaceClasses() {
        if (!staticDataResolved) {
            RaceClass.resolveStaticData();
        }
        return divisionRaceClasses;
    }

    public static String getGenderPrefix(String raceClassName) {
        return raceClassName.substring(0, 1);
    }

    public static Gender getGender(String raceClassName) {
        return Gender.getConstant(raceClassName.charAt(0));
    }

    public static List<Class<? extends RaceClass<?>>> getNationalRaceClasses() {
        if (!staticDataResolved) {
            RaceClass.resolveStaticData();
        }
        return nationalRaceClasses;
    }

    public static RaceClass<?>[] getAbilityGroupClassConstants(Class<? extends RaceClass<?>> raceClassClass) {
        if (!staticDataResolved) {
            RaceClass.resolveStaticData();
        }
        return abilityGroupClassConstantsRegistry.get(raceClassClass);
    }

    public static EvaluableAction getResolveNameAction(Class<? extends RaceClass<?>> raceClassClass) {
        if (!staticDataResolved) {
            RaceClass.resolveStaticData();
        }
        return getConstantActionRegistry.get(raceClassClass);
    }

    public static RaceClass<?> getUnknownClass(Class<? extends RaceClass<?>> raceClassClass, Gender gender) {
        RaceClass<?>[] unknowns = RaceClass.getUnknownClassConstants(raceClassClass);
        return unknowns[gender.ord];
    }

    public static RaceClass<?>[] getUnknownClassConstants(Class<? extends RaceClass<?>> raceClassClass) {
        if (!staticDataResolved) {
            RaceClass.resolveStaticData();
        }
        return unknownClassConstantsRegistry.get(raceClassClass);
    }

    public static boolean hasAbilityGroupClasses(Class<? extends RaceClass<?>> raceClassClass) {
        return RaceClass.getAbilityGroupClassConstants(raceClassClass) != null;
    }

    protected static void registerClassNumberSynonyms(Class<? extends RaceClass<?>> raceClassClass, char altWomensPrefix) {
        for (ConstantValue<?> cnst : RaceClass.getConstantValues(raceClassClass)) {
            RaceClass aRaceClass = (RaceClass)cnst;
            if (!aRaceClass.isAgeGroupClass()) continue;
            String realName = aRaceClass.name;
            Gender gender = aRaceClass.gender;
            String classNumber = realName.substring(1);
            while (classNumber.length() > 0 && classNumber.charAt(0) == '0') {
                classNumber = classNumber.substring(1);
                RaceClass.registerSynonym("" + gender.letter + classNumber, realName, raceClassClass);
                if (gender != Gender.WOMEN) continue;
                RaceClass.registerSynonym("" + altWomensPrefix + classNumber, realName, raceClassClass);
            }
        }
    }

    protected static void registerGenderPrefixSynonyms(Gender gender, char altGenderPrefix, Class<? extends RaceClass<?>> raceClassClass) {
        for (ConstantValue<?> cnst : RaceClass.getConstantValues(raceClassClass)) {
            RaceClass aRaceClass = (RaceClass)cnst;
            if (!aRaceClass.isAgeGroupClass() || aRaceClass.getGender() != gender) continue;
            String realName = aRaceClass.name;
            String classNumber = realName.substring(1);
            RaceClass.registerSynonym("" + altGenderPrefix + classNumber, realName, raceClassClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RaceClass<?> resolveName(String name, Class<? extends RaceClass<?>> raceClassClass) {
        RaceClass aRaceClass;
        EvaluableAction getConstantAction = RaceClass.getResolveNameAction(raceClassClass);
        if (getConstantAction == null) {
            return null;
        }
        EvaluableAction evaluableAction = getConstantAction;
        synchronized (evaluableAction) {
            aRaceClass = (RaceClass)getConstantAction.evaluate(name);
        }
        return aRaceClass;
    }

    protected static void resolveStaticData() {
        String packagePrefix = THIS_CLASS.getPackage().getName() + ".";
        int nDivisionClasses = divisionRaceClassNames.size();
        int nNationalClasses = nationalRaceClassNames.size();
        int nInternationalClasses = internationalRaceClassNames.size();
        String className = "";
        try {
            Class<?> raceClassClass;
            ArrayList arrayList = new ArrayList(nDivisionClasses);
            for (String divisionClassName : divisionRaceClassNames) {
                className = packagePrefix + divisionClassName;
                raceClassClass = Class.forName(className);
                arrayList.add(raceClassClass);
            }
            divisionRaceClasses = Collections.unmodifiableList(arrayList);
            ArrayList arrayList2 = new ArrayList(nDivisionClasses + nNationalClasses);
            for (String nationalClassName : nationalRaceClassNames) {
                className = packagePrefix + nationalClassName;
                raceClassClass = Class.forName(className);
                arrayList2.add(raceClassClass);
            }
            nationalRaceClasses = Collections.unmodifiableList(arrayList2);
            ArrayList arrayList3 = new ArrayList(nDivisionClasses + nNationalClasses + nInternationalClasses);
            arrayList3.addAll(divisionRaceClasses);
            arrayList3.addAll(nationalRaceClasses);
            for (String nationalClassName : internationalRaceClassNames) {
                className = packagePrefix + nationalClassName;
                raceClassClass = Class.forName(className);
                arrayList3.add(raceClassClass);
            }
            allRaceClasses = Collections.unmodifiableList(arrayList3);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("Invalid RaceClass reference: " + className);
        }
        unknownClassConstantsRegistry = new HashMap();
        abilityGroupClassConstantsRegistry = new HashMap();
        for (Class<? extends RaceClass<?>> clazz : allRaceClasses) {
            RaceClass<?>[] specialConstants = RaceClass.constructUnknownClassConstantsEntry(clazz);
            unknownClassConstantsRegistry.put(clazz, specialConstants);
            specialConstants = RaceClass.constructAbilityGroupClassConstantsEntry(clazz);
            if (specialConstants == null) continue;
            abilityGroupClassConstantsRegistry.put(clazz, specialConstants);
        }
        divisionClassFromNationalClassActionRegistry = RaceClass.constructDivisionClassFromNationalClassActionRegistry();
        getConstantActionRegistry = RaceClass.constructGetConstantActionRegistry();
        staticDataResolved = true;
    }

    protected static String[][] standardEliteSeedSynonymSpecs() {
        String[][] synonymSpecs = new String[][]{{"WE", "WEL"}, {"ME", "MEL"}, {"WELT", "WEL"}, {"MELT", "MEL"}, {"WX", "WEL"}, {"MX", "MEL"}};
        return synonymSpecs;
    }

    protected static String[][] standardOpenSeedSynonymSpecs() {
        String[][] synonymSpecs = new String[][]{{"WOPN", "WOP"}, {"MOPN", "MOP"}, {"WELT", "WOP"}, {"MELT", "MOP"}, {"FO", "WOP"}, {"WO", "WOP"}, {"MO", "MOP"}, {"WX", "WOP"}, {"MX", "MOP"}};
        return synonymSpecs;
    }

    protected static String[][] standardSuperSeedSynonymSpecs() {
        String[][] synonymSpecs = new String[][]{{"WS", "WSS"}, {"MS", "MSS"}, {"WELT", "WSS"}, {"MELT", "MSS"}, {"WX", "WSS"}, {"MX", "MSS"}};
        return synonymSpecs;
    }

    @Override
    protected boolean allowSynonyms() {
        return true;
    }

    public int compareAge(RaceClass<?> otherClass) {
        if (!otherClass.getClass().equals(this.getClass())) {
            throw new ClassCastException();
        }
        if (this.isAbilityGroupClass() || this.isUnknown() || otherClass.isAbilityGroupClass() || otherClass.isUnknown()) {
            throw new IllegalArgumentException("Can't compare open seed or unknown race classes by age: " + this.toConstantName() + ".compareAge(" + otherClass.toConstantName() + ")");
        }
        if (this.startAge == otherClass.startAge) {
            Gender theirGender = otherClass.getGender();
            if (this.getGender() == theirGender) {
                return 0;
            }
            return this.getGender() == Gender.WOMEN ? -1 : 1;
        }
        return this.startAge > otherClass.startAge ? -1 : 1;
    }

    public int compareStartOrder(RaceClass<?> otherClass) {
        int otherOrd = otherClass.ord;
        if (this.ord == otherOrd) {
            return 0;
        }
        return this.ord < otherOrd ? -1 : 1;
    }

    public boolean equalAgeRange(RaceClass<?> aClass) {
        return this.startAge == aClass.startAge && this.endAge == aClass.endAge;
    }

    public abstract int getAgeRange();

    public int getClassNumber() {
        return Integer.parseInt(this.name.substring(1));
    }

    public Gender getGender() {
        return this.gender;
    }

    public RaceClassGroup<?> getGroup() {
        return null;
    }

    public abstract RaceClassType getRaceClassType();

    public String getStartOrderSortCode() {
        int startGroupCode;
        int letterACode = 65;
        int letterZCode = 90;
        int nLetters = 26;
        String sortCode = "";
        for (startGroupCode = 65 + this.ord; startGroupCode > 90; startGroupCode -= nLetters) {
            sortCode = "Z" + sortCode;
        }
        sortCode = sortCode + (char)startGroupCode;
        return sortCode;
    }

    public boolean includesAge(int age) {
        return age >= this.startAge && age <= this.endAge;
    }

    public boolean includesAgeRange(RaceClass<?> aRaceClass) {
        return this.includesAgeRange(aRaceClass.startAge, aRaceClass.endAge);
    }

    protected boolean includesAgeRange(int startAge, int endAge) {
        return startAge >= this.startAge && startAge <= this.endAge && endAge <= this.endAge;
    }

    public boolean isAbilityGroupClass() {
        return false;
    }

    public boolean isAgeGroupClass() {
        return !this.isAbilityGroupClass() && !this.isUnknown();
    }

    public boolean isMensClass() {
        return this.gender == Gender.MEN;
    }

    public boolean isDivisionClass() {
        return false;
    }

    public boolean isNationalClass() {
        return false;
    }

    public boolean isInternationalClass() {
        return false;
    }

    public boolean isUnknown() {
        return false;
    }

    public boolean isWomensClass() {
        return this.gender == Gender.WOMEN;
    }

    @Override
    public String toDescriptionString() {
        return super.toDescriptionString() + " - " + this.toAttributeDescriptionString();
    }

    protected String toAttributeDescriptionString() {
        return this.description + (this.isAgeGroupClass() ? " ( " + this.gender.description + " ages [" + this.startAge + ".." + this.endAge + "])" : "");
    }

    @Override
    public String toString() {
        return this.name;
    }

    public RaceClass<?> toNationalClass() {
        if (this.isNationalClass()) {
            return this;
        }
        if (!this.isDivisionClass()) {
            throw new UnsupportedOperationException("No mapping to US NationalClass from " + this.getClass().getSimpleName());
        }
        throw new SubclassResponsibility();
    }

    protected void validateName() {
        if (this.gender == null) {
            throw new IllegalArgumentException("Invalid race class name + '" + this.name + "': first letter must indicate gender(" + Gender.MEN.letter + " or " + Gender.WOMEN.letter + ")");
        }
        this.validateNameSuffix(this.name.substring(1, this.name.length()));
    }

    protected void validateNameSuffix(String classNameSuffix) {
        for (int i = 0; i < classNameSuffix.length(); ++i) {
            if (Character.isDigit(classNameSuffix.charAt(i))) continue;
            throw new IllegalArgumentException("Race class name must be of the form <{M|W}dd>: " + this.name);
        }
    }

    protected void validateNameSuffixLength(String classNameSuffix, int expectedLength) {
        if (classNameSuffix.length() != expectedLength) {
            throw new IllegalArgumentException("Race class name must be of the form <{M|W}dd>: " + this.name);
        }
    }
}

