/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.models;

import com.glaivestone.javax.devx.Assert;
import org.ussamasters.aces.racedata.models.CompetitorResultValue;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceDataServices;
import org.ussamasters.aces.racedata.models.RaceEntryResult;
import org.ussamasters.aces.racedata.models.UnqualifiedResult;

public class RaceEntryResult1Run
extends RaceEntryResult {
    public RaceEntryResult1Run(int bibNumber, RaceClass<?> raceClass, String lastName, String firstName) {
        super(bibNumber, raceClass, lastName, firstName);
    }

    @Override
    public int getNumberOfRuns() {
        return 1;
    }

    @Override
    public boolean isStarter() {
        return this.getResultValue().isStarter();
    }

    @Override
    public void setTimingData(CompetitorResultValue<?> result) {
        this.setResultValue(result);
        this.clearFinishStatistics();
    }

    @Override
    public void setTimingData(String resultString) {
        this.setTimingData(RaceDataServices.current.raceResultValueFromString(resultString));
    }

    @Override
    public void validateTimingData() {
        if (this.getResultValue() == null) {
            Assert.shouldNotBe("Invalid RaceEntryResult (null result): " + this.getBib() + " - " + this.getName());
            this.setNoResultValue(UnqualifiedResult.DNS);
        }
    }
}

