/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.models;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.ussamasters.aces.racedata.models.DivisionsCupPoints;
import org.ussamasters.aces.racedata.models.Gender;
import org.ussamasters.aces.racedata.models.NamedRacerResult;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceEntryResult;
import org.ussamasters.aces.racedata.models.RaceStartResult;
import org.ussamasters.aces.racedata.models.RaceTime;
import org.ussamasters.aces.racedata.models.Racer;
import org.ussamasters.aces.racedata.models.RacerResult;
import org.ussamasters.aces.racedata.models.SeriesRacerSummary;
import org.ussamasters.aces.racedata.models.SiseCupPoints;
import org.ussamasters.aces.racedata.models.StandingsCategory;

public class RaceSeriesResult
extends NamedRacerResult {
    private SeriesRacerSummary racerSummary;
    private RaceClass<?> raceClass;
    private StandingsCategory category;
    private List<RaceStartResult> seriesResults;
    private int numStarts;
    private int numFinishes;
    private boolean isQualifiedForStandingsPosition;
    protected RaceTime actualTime;
    protected DivisionsCupPoints dcPoints;
    protected SiseCupPoints scPoints;

    public RaceSeriesResult(SeriesRacerSummary racerSummary, RaceClass<?> raceClass, StandingsCategory category, int numRaces) {
        this.racerSummary = racerSummary;
        this.raceClass = raceClass;
        this.category = category;
        this.seriesResults = this.constructSeriesResultsList(numRaces);
        this.numStarts = 0;
        this.numFinishes = 0;
        this.isQualifiedForStandingsPosition = true;
        this.clearResults();
    }

    @Override
    public void clearPoints() {
        super.clearPoints();
        this.setDivisionsCupPoints(null);
        this.setSiseCupPoints(null);
    }

    public void clearResults() {
        this.clearTime();
        this.clearFinishStatistics();
    }

    @Override
    protected void clearTime() {
        super.clearTime();
        this.actualTime = null;
    }

    public int compareByDivisionsCupPoints(RaceSeriesResult otherResult) {
        int comparison = this.compareByQualification(otherResult);
        if (comparison != 0) {
            return comparison;
        }
        return this.compareByNameIfTied(this.compareScoringValues(this.getDivisionsCupPoints(), otherResult.getDivisionsCupPoints()), otherResult);
    }

    @Override
    public int compareByPoints(RacerResult otherResult) {
        int comparison = this.compareByQualification(otherResult);
        return comparison == 0 ? super.compareByPoints(otherResult) : comparison;
    }

    protected int compareByQualification(RacerResult otherResult) {
        return this.isQualified() == ((RaceSeriesResult)otherResult).isQualified() ? 0 : (this.isQualified() ? -1 : 1);
    }

    @Override
    public int compareByRacePoints(RacerResult otherResult) {
        int comparison = this.compareByQualification(otherResult);
        return comparison == 0 ? (this.isQualified() ? super.compareByRacePoints(otherResult) : this.compareByName((RaceSeriesResult)otherResult)) : comparison;
    }

    public int compareBySiseCupPoints(RaceSeriesResult otherResult) {
        int comparison = this.compareByQualification(otherResult);
        if (comparison != 0) {
            return comparison;
        }
        return this.compareByNameIfTied(this.compareScoringValues(this.getSiseCupPoints(), otherResult.getSiseCupPoints()), otherResult);
    }

    @Override
    public int compareByTime(RacerResult otherResult) {
        int comparison = this.compareByQualification(otherResult);
        return comparison == 0 ? (this.isQualified() ? super.compareByTime(otherResult) : this.compareByName((RaceSeriesResult)otherResult)) : comparison;
    }

    protected List<RaceStartResult> constructSeriesResultsList(int numRaces) {
        return Arrays.asList(new RaceStartResult[numRaces]);
    }

    protected RaceStartResult constructStartResult(RaceEntryResult racerResult) {
        return new RaceStartResult(racerResult);
    }

    public RaceTime getActualTime() {
        return this.actualTime;
    }

    @Override
    public int getBibNumber() {
        return this.getRacer().getBibNumber();
    }

    public StandingsCategory getCategory() {
        return this.category;
    }

    public DivisionsCupPoints getDivisionsCupPoints() {
        return this.dcPoints;
    }

    public SiseCupPoints getSiseCupPoints() {
        return this.scPoints;
    }

    @Override
    public String getFirstName() {
        return this.getRacer().getFirstName();
    }

    @Override
    public Gender getGender() {
        return this.getRacer().getGender();
    }

    @Override
    public String getLastName() {
        return this.getRacer().getLastName();
    }

    public int getNumberOfFinishes() {
        return this.numFinishes;
    }

    public int getNumberOfStarts() {
        return this.numStarts;
    }

    @Override
    public RaceClass<?> getRaceClass() {
        return this.raceClass;
    }

    public Racer getRacer() {
        return this.racerSummary.getRacer();
    }

    public SeriesRacerSummary getRacerSummary() {
        return this.racerSummary;
    }

    public RaceStartResult getStartResult(int raceIndex) {
        return this.seriesResults.get(raceIndex);
    }

    protected int getNumberOfRaces() {
        return this.seriesResults.size();
    }

    public void incrementNumberOfFinishes(int count) {
        this.numFinishes += count;
    }

    public void incrementNumberOfStarts(int count) {
        this.numStarts += count;
    }

    @Override
    public boolean isFinisher() {
        return this.isQualified() && super.isFinisher();
    }

    public boolean isQualified() {
        return this.isQualifiedForStandingsPosition;
    }

    public void markUnqualified() {
        this.isQualifiedForStandingsPosition = false;
    }

    public void putSpecialResult(int raceIndex, RaceStartResult seriesStartResult) {
        this.storeStartResult(raceIndex, seriesStartResult);
    }

    public void pruneStartResult(int raceIndex) {
        this.seriesResults.set(raceIndex, null);
    }

    public void putStartResult(int raceIndex, RaceEntryResult racerResult) {
        if (racerResult == null || !racerResult.isStarter()) {
            return;
        }
        this.putStartResult(raceIndex, this.constructStartResult(racerResult));
    }

    public void putStartResult(int raceIndex, RaceStartResult seriesStartResult) {
        this.storeStartResult(raceIndex, seriesStartResult);
        this.updateSummaryStatistics(seriesStartResult);
        this.racerSummary.updateSummaryStatistics(seriesStartResult, this.category);
    }

    public void setAdjustedTime(RaceTime adjustedTotalTime) {
        this.actualTime = this.getTime();
        super.setTime(adjustedTotalTime);
    }

    public void setDivisionsCupPoints(DivisionsCupPoints dcPoints) {
        this.dcPoints = dcPoints;
    }

    public void setSiseCupPoints(SiseCupPoints scPoints) {
        this.scPoints = scPoints;
    }

    public List<RaceStartResult> starts() {
        return Collections.unmodifiableList(this.seriesResults);
    }

    protected void storeStartResult(int raceIndex, RaceStartResult seriesStartResult) {
        if (this.getStartResult(raceIndex) != null) {
            throw new IllegalStateException("Attempt to store duplicate series race result for racer " + this.racerSummary.getBib() + " (race #" + raceIndex + ")");
        }
        this.seriesResults.set(raceIndex, seriesStartResult);
    }

    public String toString() {
        return String.format("%s<%s, %s, %s: %s starts, %s finishes>", this.getClass().getSimpleName(), this.getBib(), this.category, this.getLastName(), this.numStarts, this.numFinishes);
    }

    protected void updateSummaryStatistics(RaceStartResult raceStartResult) {
        ++this.numStarts;
        if (raceStartResult.isFinisher()) {
            ++this.numFinishes;
        }
    }
}

