/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.models;

import com.glaivestone.javax.lang.ConstantValueWithDescription;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.ussamasters.aces.racedata.models.RaceDataConstant;
import org.ussamasters.aces.racedata.models.StandingsCategory;

public class RaceType
extends ConstantValueWithDescription<RaceType>
implements RaceDataConstant,
StandingsCategory {
    public static final RaceType SL;
    public static final RaceType GS;
    public static final RaceType SG;
    public static final RaceType DH;
    public static final RaceType SC;
    public static final RaceType AC;
    public static final RaceType P;
    public static final RaceType PGS;
    public static final RaceType PSL;
    public static final RaceType SL_1;
    public static final RaceType GS_1;
    public static final RaceType P_1;
    public static final RaceType SG_2;
    public static final RaceType DH_2;
    public static final RaceType DH_T;
    public static final RaceType SG_T;
    public static final RaceType COMBINED;
    public static final RaceType DUAL_SL;
    public static final RaceType DUAL_GS;
    public static final int SL_ORD = 0;
    public static final int GS_ORD = 1;
    public static final int SG_ORD = 2;
    public static final int DH_ORD = 3;
    public static final int SC_ORD = 4;
    public static final int AC_ORD = 5;
    public static final int P_ORD = 6;
    public static final int FIRST_STANDARD_RACE_TYPE_ORD = 0;
    public static final int LAST_STANDARD_RACE_TYPE_ORD = 6;
    public static final List<RaceType> STANDARD_RACE_TYPES;
    private static final Class<RaceType> THIS_CLASS;
    public final int nRuns;
    public final RaceType basicType;

    public static RaceType getConstant(int ordinalValue) {
        return RaceType.getConstant(ordinalValue, THIS_CLASS);
    }

    public static RaceType getConstant(String name) {
        return RaceType.getConstant(name, THIS_CLASS);
    }

    public static List<RaceType> values() {
        return RaceType.values(THIS_CLASS);
    }

    public static List<RaceType> standardRaceTypes() {
        return STANDARD_RACE_TYPES;
    }

    protected RaceType(String name, String description, int nRuns) {
        this(name, description, nRuns, null);
    }

    public RaceType(String name, String description, int nRuns, RaceType basicType) {
        super(name, description);
        this.nRuns = nRuns;
        this.basicType = basicType == null && nRuns > 0 ? this : basicType;
    }

    public RaceType getRunCountVariant(int nRuns) {
        switch (this.ord) {
            case 0: {
                if (nRuns == 1) {
                    return SL_1;
                }
            }
            case 1: {
                if (nRuns == 1) {
                    return GS_1;
                }
            }
            case 6: {
                if (nRuns == 1) {
                    return P_1;
                }
            }
            case 2: {
                if (nRuns == 2) {
                    return SG_2;
                }
            }
            case 3: {
                if (nRuns != 2) break;
                return DH_2;
            }
        }
        throw new IllegalArgumentException("Invalid run count variation for " + this.toConstantName() + ": " + nRuns);
    }

    static {
        THIS_CLASS = RaceType.class;
        SL = new RaceType("SL", "Slalom", 2);
        GS = new RaceType("GS", "Giant Slalom", 2);
        SG = new RaceType("SG", "Super Giant Slalom", 1);
        DH = new RaceType("DH", "Downhill", 1);
        SC = new RaceType("SC", "Super Combined", 2);
        AC = new RaceType("AC", "Alpine Combined", 2);
        P = new RaceType("P", "Parallel", 2);
        PGS = new RaceType("PGS", "Parallel GS", 2, P);
        PSL = new RaceType("PSL", "Parallel SL", 2, P);
        SL_1 = new RaceType("SL_1", "Slalom (1 run)", 1, SL);
        GS_1 = new RaceType("GS_1", "Giant Slalom (1 run)", 1, GS);
        P_1 = new RaceType("P_1", "Parallell (1 run)", 1, P);
        SG_2 = new RaceType("SG_2", "Super G (2 runs)", 2, SG);
        DH_2 = new RaceType("DH_2", "Downhill (2 runs)", 2, DH);
        SG_T = new RaceType("SG_T", "SuperG (training)", 1, SG);
        DH_T = new RaceType("DH_T", "DH (training)", 1, DH);
        COMBINED = new RaceType("Combined", "Combined", -1);
        DUAL_SL = new RaceType("DualSL", "Dual Slalom", -1);
        DUAL_GS = new RaceType("DualGS", "Dual Giant Slalom", -1);
        STANDARD_RACE_TYPES = Collections.unmodifiableList(Arrays.asList(SL, GS, SG, DH, SC, AC, P));
    }
}

