/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.models;

import com.glaivestone.javax.util.MapX;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceClassHelper;
import org.ussamasters.aces.racedata.models.RaceOrganization;
import org.ussamasters.aces.racedata.models.Racer;
import org.ussamasters.aces.racedata.models.SeasonIdentifier;
import org.ussamasters.aces.racedata.models.USSALicense;

public class RacerList {
    public static Comparator<Racer> BY_BIB_SORTER = new Comparator<Racer>(){

        @Override
        public int compare(Racer racer1, Racer racer2) {
            return racer1.compareByBib(racer2);
        }
    };
    public static Comparator<Racer> BY_AGE_CLASS_SORTER = new Comparator<Racer>(){

        @Override
        public int compare(Racer racer1, Racer racer2) {
            return racer1.compareByAgeClass(racer2);
        }
    };
    public static Comparator<Racer> BY_NAME_SORTER = new Comparator<Racer>(){

        @Override
        public int compare(Racer racer1, Racer racer2) {
            return racer1.compareByName(racer2);
        }
    };
    private final SeasonIdentifier season;
    private RaceOrganization affiliation;
    private Class<? extends RaceClass<?>> ageClassClass;
    private List<Racer> racersList;
    private Map<Object, Racer> bibLookupTable;
    private final RaceClassHelper raceClassHelper;

    public static RacerList emptyCopy(RacerList aRacerList) {
        RacerList emptyCopy = new RacerList(aRacerList);
        emptyCopy.clear();
        return emptyCopy;
    }

    public RacerList(SeasonIdentifier season, RaceOrganization affiliation, Class<? extends RaceClass<?>> ageClassClass) {
        this(season, affiliation, ageClassClass, new ArrayList<Racer>());
    }

    public RacerList(SeasonIdentifier season, RaceOrganization affiliation, Class<? extends RaceClass<?>> ageClassClass, List<Racer> racersList) {
        this.season = season;
        this.affiliation = affiliation;
        this.ageClassClass = ageClassClass;
        this.racersList = racersList;
        this.raceClassHelper = new RaceClassHelper(season);
    }

    protected RacerList(RacerList aRacerList) {
        this(aRacerList.getSeason(), aRacerList.getAffiliation(), aRacerList.getAgeClassClass(), aRacerList.racersList);
    }

    public void add(Racer aRacer) {
        Object bibNumberKey;
        this.racersList.add(aRacer);
        if (this.bibLookupTable != null && (bibNumberKey = this.asBibNumberKey(aRacer.getBibNumber())) != null) {
            this.bibLookupTable.put(bibNumberKey, aRacer);
        }
    }

    protected Object asBibNumberKey(int bibNumber) {
        return this.isValidBibNumber(bibNumber) ? "" + bibNumber : null;
    }

    protected void clear() {
        this.racersList = new ArrayList<Racer>();
    }

    protected Map<Object, Racer> constructBibLookupTable() {
        HashMap<Object, Racer> lookupTable = new HashMap<Object, Racer>(this.size());
        for (Racer aRacer : this.racersList) {
            Object bibNumberKey = this.asBibNumberKey(aRacer.getBibNumber());
            if (bibNumberKey == null) continue;
            if (lookupTable.containsKey(bibNumberKey)) {
                Racer otherRacer = (Racer)lookupTable.get(bibNumberKey);
                throw new IllegalArgumentException(String.format("Dup bib number %s for racer %s (already assigned to %s)", bibNumberKey, aRacer.getNameFirstLast(), otherRacer.getNameFirstLast()));
            }
            lookupTable.put(bibNumberKey, aRacer);
        }
        return lookupTable;
    }

    public Racer findBib(int bibNumber) {
        return this.getRacer(bibNumber);
    }

    public Racer findLastName(String lastName, boolean exactMatch) {
        if (lastName == null || (lastName = lastName.trim()).length() == 0) {
            return null;
        }
        return exactMatch ? this.findLastNameExact(lastName) : this.findLastNameInexact(lastName);
    }

    protected Racer findLastNameExact(String lastName) {
        for (Racer aRacer : this.racersList) {
            if (!lastName.equals(aRacer.getLastName())) continue;
            return aRacer;
        }
        return null;
    }

    protected Racer findLastNameInexact(String lastName) {
        String lastNamePrefix = lastName.toLowerCase();
        for (Racer aRacer : this.racersList) {
            String racerLastName = aRacer.getLastName();
            if (racerLastName == null || !racerLastName.toLowerCase().startsWith(lastNamePrefix)) continue;
            return aRacer;
        }
        return null;
    }

    public Racer findUSSANumber(String ussaNumber) {
        if (!USSALicense.isValid(ussaNumber)) {
            return null;
        }
        ussaNumber = ussaNumber.toUpperCase();
        for (Racer aRacer : this.racersList) {
            String racerUSSANumber = aRacer.getUSSALicense().toString();
            if (racerUSSANumber == null || !racerUSSANumber.toUpperCase().equals(ussaNumber)) continue;
            return aRacer;
        }
        return null;
    }

    public RaceOrganization getAffiliation() {
        return this.affiliation;
    }

    public Class<? extends RaceClass<?>> getAgeClassClass() {
        return this.ageClassClass;
    }

    public SeasonIdentifier getSeason() {
        return this.season;
    }

    public int getSeasonYear() {
        return this.season.getSeasonYear();
    }

    @Deprecated
    public int getSeasonEndYear() {
        return this.season.endYear;
    }

    @Deprecated
    public int getSeasonStartYear() {
        return this.season.startYear;
    }

    public Racer getRacer(int aBibNumber) {
        Object bibNumberKey = this.asBibNumberKey(aBibNumber);
        if (bibNumberKey == null) {
            return null;
        }
        if (this.bibLookupTable == null) {
            this.bibLookupTable = this.constructBibLookupTable();
        }
        return this.bibLookupTable.get(bibNumberKey);
    }

    public List<Racer> getRacers() {
        return Collections.unmodifiableList(this.racersList);
    }

    protected boolean isValidBibNumber(int bibNumber) {
        return bibNumber > 0;
    }

    public void remove(Racer aRacer) {
        Object bibNumberKey;
        this.racersList.remove(aRacer);
        if (this.bibLookupTable != null && (bibNumberKey = this.asBibNumberKey(aRacer.getBibNumber())) != null) {
            this.bibLookupTable.remove(bibNumberKey);
        }
    }

    public void setAgeClassClass(Class<? extends RaceClass<?>> ageClassClass) {
        if (this.size() > 0) {
            throw new IllegalStateException("Cannot change age class system of non-empty racer list");
        }
        this.ageClassClass = ageClassClass;
    }

    public int size() {
        return this.racersList.size();
    }

    public void sortByAgeClass() {
        Collections.sort(this.racersList, BY_AGE_CLASS_SORTER);
    }

    public void sortByBib() {
        Collections.sort(this.racersList, BY_BIB_SORTER);
    }

    public void sortByName() {
        Collections.sort(this.racersList, BY_NAME_SORTER);
    }

    public String toString() {
        return String.format("%s<%s, %s, %s racers>", this.getClass().getSimpleName(), this.affiliation.name, this.raceClassHelper.raceClassClassToLiteral(this.ageClassClass), this.racersList.size());
    }

    public void update(Racer aRacer) {
        int bibNumber = aRacer.getBibNumber();
        if (this.bibLookupTable != null) {
            Object previousBibNumberKey = MapX.getKey(aRacer, this.bibLookupTable);
            Object bibNumberKey = this.asBibNumberKey(bibNumber);
            if (previousBibNumberKey != null && !previousBibNumberKey.equals(bibNumberKey)) {
                this.bibLookupTable.remove(previousBibNumberKey);
            }
            if (bibNumberKey != null && !bibNumberKey.equals(previousBibNumberKey)) {
                this.bibLookupTable.put(bibNumberKey, aRacer);
            }
        }
    }

    public void validateEntries() {
        this.findBib(Integer.MAX_VALUE);
    }
}

