/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.models;

import com.glaivestone.javax.util.Numbers;
import org.ussamasters.aces.racedata.models.FinishPositionPoints;
import org.ussamasters.aces.racedata.models.RacePoints;

public class ScoringResult {
    public static final int NO_FINISH_POSITION = 0;
    public static final int NULL_POSITION = -1000;
    public static final String POSITION_TIE_SUFFIX = "(t)";
    private int position;
    private boolean tie;

    public ScoringResult() {
        this.clearPosition();
    }

    protected void checkComparable(ScoringResult otherResult) {
        if (!this.isComparable(otherResult)) {
            throw new IllegalArgumentException("Cannot compare " + otherResult + " with " + this);
        }
    }

    public void clearPosition() {
        this.setPosition(-1000);
        this.setTied(false);
    }

    public int compareByPosition(ScoringResult otherResult) {
        this.checkComparable(otherResult);
        int comparison = this.compareByQualification(otherResult);
        if (comparison == 0 && this.hasFinishPosition()) {
            comparison = Numbers.compare(this.getPosition(), otherResult.getPosition());
        }
        return comparison;
    }

    protected int compareByQualification(ScoringResult otherResult) {
        return this.hasFinishPosition() == otherResult.hasFinishPosition() ? 0 : (this.hasFinishPosition() ? -1 : 1);
    }

    protected int compareScoringValues(FinishPositionPoints<?> thisValue, FinishPositionPoints<?> otherValue) {
        boolean otherHasValue;
        boolean thisHasValue = thisValue != null;
        boolean bl = otherHasValue = otherValue != null;
        return thisHasValue && otherHasValue ? thisValue.compareQuantities(otherValue) : (thisHasValue ? -1 : 1);
    }

    protected int compareScoringValues(RacePoints thisValue, RacePoints otherValue) {
        boolean otherHasValue;
        boolean thisHasValue = thisValue != null;
        boolean bl = otherHasValue = otherValue != null;
        return thisHasValue && otherHasValue ? thisValue.compareQuantities(otherValue) : (thisHasValue ? -1 : 1);
    }

    public int getPosition() {
        return this.position;
    }

    public String getPositionString() {
        if (this.position == -1000) {
            return null;
        }
        if (this.position == 0) {
            return "";
        }
        return ScoringResult.composePositionString(this.position, this.isTied());
    }

    protected boolean hasFinishPosition() {
        return this.getPosition() > 0;
    }

    protected boolean isComparable(ScoringResult otherResult) {
        return otherResult.getClass().equals(this.getClass());
    }

    public boolean isTied() {
        return this.tie;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public void setTied(boolean isTied) {
        this.tie = isTied;
    }

    public static final String composePositionString(int position, boolean isTied) {
        return isTied ? "" + position + POSITION_TIE_SUFFIX : "" + position;
    }
}

