/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.models;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceClassGroup;
import org.ussamasters.aces.racedata.models.RaceClassGroupType;
import org.ussamasters.aces.racedata.models.RaceClassType;
import org.ussamasters.aces.racedata.models.RaceDate;
import org.ussamasters.aces.racedata.models.RaceType;
import org.ussamasters.aces.racedata.models.SeasonIdentifier;
import org.ussamasters.javax.io.ConstantLoader;
import org.ussamasters.javax.io.ConstantSpecifications;

public class SeasonConfiguration {
    private static final Class<SeasonConfiguration> THIS_CLASS = SeasonConfiguration.class;
    private static final String CONFIG_DIR_REF = "/" + THIS_CLASS.getPackage().getName().replaceAll("\\.", "/").replace("/models", "/configuration");
    public static final String BUILTIN_CONSTANT_SPECS = CONFIG_DIR_REF + "/constants/SeasonConfiguration.yml";
    public static final String SPEC_FIELD_SEASON_RANGE = "seasonRange";
    public static final String SPEC_FIELD_RACE_CLASSES = "raceClasses";
    public static final String SPEC_FIELD_RACE_CLASS_GROUPS = "raceClassGroups";
    public static final List<String> CONSTANT_SPEC_FIELDS = Collections.unmodifiableList(Arrays.asList("seasonRange", "raceClasses", "raceClassGroups"));
    public static final Map<SeasonIdentifier, SeasonConfiguration> registry = new HashMap<SeasonIdentifier, SeasonConfiguration>();
    public static final Map<String, RaceClassType> raceClassClassLiterals = SeasonConfiguration.constructRaceClassClassLiterals();
    public static final Map<String, RaceClassGroupType> raceClassGroupLiterals = SeasonConfiguration.constructRaceClassGroupLiterals();
    public static final Map<String, Class<? extends RaceClass<?>>> raceClassClasses = SeasonConfiguration.constructRaceClassClassesRegistry();
    public static final Map<String, Class<? extends RaceClassGroup<?>>> raceClassGroupClasses = SeasonConfiguration.constructGroupClassesRegistry();
    protected SeasonIdentifier season;
    protected Map<RaceClassType, Class<? extends RaceClass<?>>> raceClasses;
    protected Map<RaceClassGroupType, Class<? extends RaceClassGroup<?>>> raceClassGroups;
    protected Map<RaceType, Integer> fFactors;

    public static SeasonIdentifier getCurrentSeason() {
        int currentSeasonYear = RaceDate.currentSeasonYear();
        return SeasonIdentifier.forSeason(currentSeasonYear);
    }

    public static SeasonConfiguration getCurrentSeasonConfig() {
        return SeasonConfiguration.getSeasonConfig(SeasonConfiguration.getCurrentSeason());
    }

    public static SeasonConfiguration getSeasonConfig(SeasonIdentifier season) {
        return registry.get(season);
    }

    public static Class<? extends RaceClass<?>> resolveRaceClassLiteral(String raceClassLiteral, SeasonIdentifier season) {
        if (season.endYear <= 2019 && raceClassLiteral.equals("InternationalClasses")) {
            raceClassLiteral = "FISMastersClasses";
        }
        Class<? extends RaceClass<?>> raceClassClass = null;
        SeasonConfiguration seasonConfig = SeasonConfiguration.getSeasonConfig(season);
        RaceClassType raceClassType = raceClassClassLiterals.get(raceClassLiteral);
        if (raceClassType != null) {
            raceClassClass = seasonConfig.raceClasses.get(raceClassType);
        } else {
            String className = raceClassLiteral.replaceFirst("es$", "");
            raceClassClass = raceClassClasses.get(className);
        }
        if (raceClassClass == null) {
            throw new IllegalArgumentException(String.format("Unknown race classes '%s' for %s", raceClassLiteral, season));
        }
        return raceClassClass;
    }

    private static Map<String, RaceClassType> constructRaceClassClassLiterals() {
        HashMap<String, RaceClassType> mappingTable = new HashMap<String, RaceClassType>(RaceClassType.values().length);
        for (RaceClassType raceClassType : RaceClassType.values()) {
            String raceClassId = raceClassType.raceClassId;
            mappingTable.put(raceClassId + "es", raceClassType);
        }
        mappingTable.put("FarWest5yrClasses", RaceClassType.farwest_masters);
        return mappingTable;
    }

    private static Map<String, RaceClassGroupType> constructRaceClassGroupLiterals() {
        HashMap<String, RaceClassGroupType> mappingTable = new HashMap<String, RaceClassGroupType>(RaceClassGroupType.values().length);
        for (RaceClassGroupType groupType : RaceClassGroupType.values()) {
            mappingTable.put(groupType.groupId, groupType);
        }
        return mappingTable;
    }

    private static Map<String, Class<? extends RaceClass<?>>> constructRaceClassClassesRegistry() {
        HashMap mappingTable = new HashMap();
        for (Class<RaceClass<?>> raceClassClass : RaceClass.getAllRaceClasses()) {
            mappingTable.put(raceClassClass.getSimpleName(), raceClassClass);
        }
        return mappingTable;
    }

    private static Map<String, Class<? extends RaceClassGroup<?>>> constructGroupClassesRegistry() {
        HashMap mappingTable = new HashMap();
        for (Class<RaceClassGroup<?>> groupClass : RaceClassGroup.getAllGroupClasses()) {
            mappingTable.put(groupClass.getSimpleName(), groupClass);
        }
        return mappingTable;
    }

    public static void loadConstants(String fileRef) {
        ConstantSpecifications specs = ConstantLoader.loadSpecificationsFromFile(fileRef);
        specs.ensureWellFormed(CONSTANT_SPEC_FIELDS);
        for (Map<String, Object> entry : specs.getEntries()) {
            Object spec2;
            int lastSeasonYear;
            List seasonRange = (List)entry.get(SPEC_FIELD_SEASON_RANGE);
            List raceClassSpecs = (List)entry.get(SPEC_FIELD_RACE_CLASSES);
            List raceClassGroupSpecs = (List)entry.get(SPEC_FIELD_RACE_CLASS_GROUPS);
            if (seasonRange.size() != 2) {
                throw new RuntimeException(String.format("Invalid specs for %s: expected '%s: [ start, end ]' years but got %s", specs.getConstantType(), SPEC_FIELD_SEASON_RANGE, seasonRange));
            }
            int firstSeasonYear = (Integer)seasonRange.get(0);
            if (firstSeasonYear > (lastSeasonYear = ((Integer)seasonRange.get(1)).intValue())) {
                throw new RuntimeException(String.format("Invalid specs for %s: '%s: [ start, end ]' interval invalid %s", specs.getConstantType(), SPEC_FIELD_SEASON_RANGE, seasonRange));
            }
            HashMap raceClasses = new HashMap(raceClassSpecs.size());
            for (Object spec2 : raceClassSpecs) {
                String raceClassTypeName = (String)spec2.get(0);
                String raceClassClassName = (String)spec2.get(1);
                RaceClassType raceClassType = RaceClassType.valueOf(raceClassTypeName);
                Class<? extends RaceClass<?>> raceClassClass = raceClassClasses.get(raceClassClassName);
                if (raceClassType == null) {
                    throw new IllegalArgumentException(String.format("Unknown race class type '%s' for %s..%s", raceClassTypeName, firstSeasonYear, lastSeasonYear));
                }
                if (raceClassClass == null) {
                    throw new IllegalArgumentException(String.format("Unknown %s race class '%s' for %s..%s", raceClassType.name(), raceClassClassName, firstSeasonYear, lastSeasonYear));
                }
                Class registeredClass = (Class)raceClasses.get(raceClassType);
                if (registeredClass != null) {
                    throw new IllegalArgumentException(String.format("Duplicate %s race class '%s' (%s already registered)", raceClassType.name(), raceClassClassName, registeredClass.getSimpleName()));
                }
                raceClasses.put(raceClassType, raceClassClass);
            }
            HashMap raceClassGroups = new HashMap(raceClassGroupSpecs.size());
            spec2 = raceClassGroupSpecs.iterator();
            while (spec2.hasNext()) {
                List spec3 = (List)spec2.next();
                String groupTypeName = (String)spec3.get(0);
                String groupClassName = (String)spec3.get(1);
                RaceClassGroupType raceClassGroupType = RaceClassGroupType.valueOf(groupTypeName);
                Class<? extends RaceClassGroup<?>> raceClassGroupClass = raceClassGroupClasses.get(groupClassName);
                raceClassGroups.put(raceClassGroupType, raceClassGroupClass);
            }
            for (int seasonYear = firstSeasonYear; seasonYear <= lastSeasonYear; ++seasonYear) {
                SeasonIdentifier season = SeasonIdentifier.forSeason(seasonYear);
                if (registry.get(season) != null) {
                    throw new IllegalArgumentException("Duplicate season config specification for " + season);
                }
                SeasonConfiguration seasonConfig = new SeasonConfiguration(season);
                seasonConfig.raceClasses = Collections.unmodifiableMap(raceClasses);
                seasonConfig.raceClassGroups = Collections.unmodifiableMap(raceClassGroups);
                registry.put(season, seasonConfig);
            }
        }
        SeasonIdentifier currentSeason = SeasonConfiguration.getCurrentSeason();
        if (currentSeason == null || !registry.containsKey(currentSeason)) {
            int currentSeasonYear = RaceDate.currentSeasonYear();
            SeasonConfiguration prevConfig = null;
            int seasonYear = currentSeasonYear;
            while (prevConfig == null && seasonYear > 2000) {
                prevConfig = SeasonConfiguration.getSeasonConfig(SeasonIdentifier.forSeason(--seasonYear));
            }
            if (prevConfig != null) {
                for (seasonYear = prevConfig.getSeasonYear() + 1; seasonYear <= currentSeasonYear; ++seasonYear) {
                    SeasonIdentifier season = SeasonIdentifier.forSeason(seasonYear);
                    SeasonConfiguration seasonConfig = new SeasonConfiguration(season);
                    seasonConfig.raceClasses = prevConfig.raceClasses;
                    seasonConfig.raceClassGroups = prevConfig.raceClassGroups;
                    registry.put(season, seasonConfig);
                }
            }
        }
    }

    public static void registerFFactors(SeasonIdentifier season, Map<RaceType, Integer> fFactors) {
        SeasonConfiguration seasonConfig = SeasonConfiguration.getSeasonConfig(season);
        if (seasonConfig == null) {
            throw new IllegalStateException("No season configuration for F factors in " + season.toDescriptionString());
        }
        if (seasonConfig.fFactors != null) {
            throw new IllegalStateException("F factors already registered for " + season.toDescriptionString());
        }
        seasonConfig.fFactors = Collections.unmodifiableMap(fFactors);
    }

    public SeasonConfiguration(SeasonIdentifier season) {
        this.season = season;
    }

    public SeasonIdentifier getSeason() {
        return this.season;
    }

    public int getSeasonYear() {
        return this.season.getSeasonYear();
    }

    public Class<? extends RaceClass<?>> getRaceClassClass(RaceClassType raceClassType) {
        return this.raceClasses.get(raceClassType);
    }

    public List<Class<? extends RaceClass<?>>> getRaceClasses() {
        return new ArrayList(this.raceClasses.values());
    }

    public List<RaceClassType> getRaceClassTypes() {
        return new ArrayList<RaceClassType>(this.raceClasses.keySet());
    }

    public Map<RaceType, Integer> getFFactorTable() {
        return this.fFactors;
    }

    public int getFFactor(RaceType raceType) {
        if (this.fFactors == null) {
            throw new RuntimeException("Configuration error: no F factors registered for " + this.season.toDescriptionString());
        }
        return this.fFactors.get(raceType.basicType);
    }

    public String toString() {
        return String.format("%s[%s]", this.getClass().getSimpleName(), this.season);
    }

    public static void main(String[] args) {
        System.out.println("Current season: " + SeasonConfiguration.getCurrentSeason());
        ConstantLoader.checkSpecificationLoading(BUILTIN_CONSTANT_SPECS);
    }

    static {
        SeasonConfiguration.loadConstants(BUILTIN_CONSTANT_SPECS);
    }
}

