/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.models;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ussamasters.aces.racedata.models.AllRacersCategory;
import org.ussamasters.aces.racedata.models.CourseArrangement;
import org.ussamasters.aces.racedata.models.FISMastersClass_2000;
import org.ussamasters.aces.racedata.models.FISMastersClass_2020;
import org.ussamasters.aces.racedata.models.FISMastersGroup;
import org.ussamasters.aces.racedata.models.FISMastersGroup_2000;
import org.ussamasters.aces.racedata.models.FISMastersGroup_2020;
import org.ussamasters.aces.racedata.models.Gender;
import org.ussamasters.aces.racedata.models.NationalClassGroup;
import org.ussamasters.aces.racedata.models.NationalClassGroupYOW;
import org.ussamasters.aces.racedata.models.NationalClassGroupYOW_2000;
import org.ussamasters.aces.racedata.models.NationalClassGroupYOW_2016;
import org.ussamasters.aces.racedata.models.NationalClassGroup_2000;
import org.ussamasters.aces.racedata.models.NationalClassGroup_2016;
import org.ussamasters.aces.racedata.models.NationalClass_2000;
import org.ussamasters.aces.racedata.models.NationalClass_2016;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceOrganization;
import org.ussamasters.aces.racedata.models.StandingsCategory;
import org.ussamasters.aces.racedata.models.StandingsCategoryType;
import org.ussamasters.aces.racedata.models.StandingsOrganizationType;

public class StandardOrganizationType
implements StandingsOrganizationType {
    public static final StandingsOrganizationType BY_CLASS;
    public static final StandingsOrganizationType BY_GENDER;
    public static final StandingsOrganizationType BY_NATIONAL_GROUP;
    public static final StandingsOrganizationType BY_NATIONAL_GROUP_YOW;
    public static final StandingsOrganizationType BY_FIS_MASTERS_GROUP;
    public static final StandingsOrganizationType BY_ALL_RACERS;
    public static final StandingsOrganizationType BY_AFFILIATION;
    protected static final List<StandingsOrganizationType> standardOrganizationTypes;
    protected static Map<Class<? extends StandingsCategory>, StandingsOrganizationType> organizationTypeRegistry;
    protected static List<Class<? extends StandingsCategory>> supportedCategoryClasses;
    protected static Map<String, StandingsOrganizationType> organizationTypeNameIndex;
    protected String name;
    protected String description;
    protected StandingsCategoryType categoryType;
    protected Class<? extends StandingsCategory> categoryClass;
    protected List<? extends StandingsCategory> categories;
    protected Class<? extends RaceClass<?>> raceClassClass;
    protected Map<Class<? extends RaceClass<?>>, StandardOrganizationType> raceClassGroupOrganizations;

    public static StandardOrganizationType constructForRaceClass(String name, String description, Class<? extends RaceClass<?>> raceClassClass, List<? extends StandingsCategory> classes) {
        StandardOrganizationType organizationType = new StandardOrganizationType(name, description, StandingsCategoryType.race_class, raceClassClass, (List)classes){

            @Override
            public boolean isSupportedOnRaceClass(Class<? extends RaceClass<?>> raceClassClass) {
                return raceClassClass.equals(this.categoryClass());
            }
        };
        return organizationType;
    }

    public static StandardOrganizationType constructForGender() {
        String name = "ByGender";
        String description = "By Gender";
        StandardOrganizationType organizationType = new StandardOrganizationType(name, description, StandingsCategoryType.gender, Gender.class, Gender.values()){

            @Override
            public String categoryDescription(StandingsCategory category) {
                return "All " + super.categoryDescription(category);
            }

            @Override
            public boolean isSupportedOnCourseArrangement(CourseArrangement courseArrangement) {
                return courseArrangement.allMenOnSameCourse && courseArrangement.allWomenOnSameCourse;
            }
        };
        return organizationType;
    }

    public static StandardOrganizationType constructForOverall() {
        String name = "Overall";
        String description = "By Overall Finish";
        StandardOrganizationType organizationType = new StandardOrganizationType(name, description, StandingsCategoryType.overall, AllRacersCategory.class, AllRacersCategory.values()){

            @Override
            public boolean isSupportedOnCourseArrangement(CourseArrangement courseArrangement) {
                return courseArrangement.allRacersOnSameCourse;
            }
        };
        return organizationType;
    }

    public static StandardOrganizationType constructForNationalGroup(String name, String description, Class<? extends NationalClassGroup<?>> nationalGroupClass, List<? extends NationalClassGroup<?>> groups, Class<? extends RaceClass<?>> nationalClassClass) {
        StandardOrganizationType organizationType = new StandardOrganizationType(name, description, StandingsCategoryType.national_group, nationalGroupClass, groups, (Class)nationalClassClass){

            @Override
            public boolean isSupportedOnRaceClass(Class<? extends RaceClass<?>> raceClassClass) {
                return raceClassClass.equals(this.raceClassClass);
            }

            @Override
            public boolean isSupportedOnCourseArrangement(CourseArrangement courseArrangement) {
                return courseArrangement.allGroupClassesOnSameCourse;
            }
        };
        return organizationType;
    }

    public static StandardOrganizationType constructForNationalGroupYOW(String name, String description, Class<? extends NationalClassGroupYOW<?>> nationalGroupClass, List<? extends NationalClassGroupYOW<?>> groups, Class<? extends RaceClass<?>> nationalClassClass) {
        StandardOrganizationType organizationType = new StandardOrganizationType(name, description, StandingsCategoryType.national_group_yow, nationalGroupClass, groups, (Class)nationalClassClass){

            @Override
            public boolean isSupportedOnRaceClass(Class<? extends RaceClass<?>> raceClassClass) {
                return raceClassClass.equals(this.raceClassClass);
            }

            @Override
            public boolean isSupportedOnCourseArrangement(CourseArrangement courseArrangement) {
                return courseArrangement.allGroupClassesOnSameCourse || courseArrangement == CourseArrangement.SEPARATE_COURSES_BY_NATIONAL_GROUPS_AB_CD;
            }
        };
        return organizationType;
    }

    public static StandardOrganizationType constructForFISMastersGroup(String name, String description, Class<? extends FISMastersGroup<?>> fisMastersGroupClass, List<? extends FISMastersGroup<?>> groups, Class<? extends RaceClass<?>> fisMastersClassClass) {
        StandardOrganizationType organizationType = new StandardOrganizationType(name, description, StandingsCategoryType.international_group, fisMastersGroupClass, groups, (Class)fisMastersClassClass){

            @Override
            public boolean isSupportedOnRaceClass(Class<? extends RaceClass<?>> raceClassClass) {
                return raceClassClass.equals(this.raceClassClass);
            }

            @Override
            public boolean isSupportedOnCourseArrangement(CourseArrangement courseArrangement) {
                return courseArrangement.allGroupClassesOnSameCourse;
            }
        };
        return organizationType;
    }

    public static StandardOrganizationType constructForAffiliation() {
        StandardOrganizationType organizationType = new StandardOrganizationType("ByAffiliation", "By Affiliation", StandingsCategoryType.affiliation, RaceOrganization.class, RaceOrganization.values()){
            List<RaceOrganization> sortedValues = null;

            @Override
            public String categoryDescription(StandingsCategory category) {
                return ((RaceOrganization)category).isUSSADivision() ? super.categoryDescription(category) + " Division" : super.categoryDescription(category);
            }

            protected void initSortedValues() {
                this.sortedValues = new ArrayList<RaceOrganization>();
                for (RaceOrganization anOrganization : RaceOrganization.values()) {
                    if (!anOrganization.isUSSADivision()) continue;
                    this.sortedValues.add(anOrganization);
                }
                Collections.sort(this.sortedValues, new Comparator<RaceOrganization>(){

                    @Override
                    public int compare(RaceOrganization org1, RaceOrganization org2) {
                        return org1.name.compareTo(org2.name);
                    }
                });
                for (RaceOrganization anOrganization : RaceOrganization.values()) {
                    if (!anOrganization.isNationalOrganization()) continue;
                    this.sortedValues.add(anOrganization);
                }
                for (RaceOrganization anOrganization : RaceOrganization.values()) {
                    if (anOrganization.isUSSADivision() || anOrganization.isNationalOrganization()) continue;
                    this.sortedValues.add(anOrganization);
                }
            }

            @Override
            public List<? extends StandingsCategory> categories() {
                if (this.sortedValues == null) {
                    this.initSortedValues();
                }
                return this.sortedValues;
            }
        };
        return organizationType;
    }

    public static void registerOrganizationType(StandingsOrganizationType anOrganizationType) {
        Class<? extends StandingsCategory> categoryClass = anOrganizationType.categoryClass();
        StandingsOrganizationType existingType = StandardOrganizationType.forCategoryClass(categoryClass);
        if (existingType != null && existingType != anOrganizationType) {
            throw new IllegalStateException("Organization type already registered for category class " + categoryClass.getName());
        }
        organizationTypeRegistry.put(categoryClass, anOrganizationType);
        supportedCategoryClasses.add(categoryClass);
        organizationTypeNameIndex.put(anOrganizationType.name(), anOrganizationType);
    }

    protected static void registerStandardOrganizationType(StandingsOrganizationType organizationType, List<StandingsOrganizationType> standardTypes) {
        StandardOrganizationType.registerOrganizationType(organizationType);
        standardTypes.add(organizationType);
    }

    public static StandingsOrganizationType forCategoryClass(Class<? extends StandingsCategory> categoryClass) {
        return organizationTypeRegistry.get(categoryClass);
    }

    public static StandingsOrganizationType forName(String organizationTypeName) {
        return organizationTypeNameIndex.get(organizationTypeName);
    }

    public static List<StandingsOrganizationType> getStandardOrganizationTypes() {
        return standardOrganizationTypes;
    }

    public StandardOrganizationType(String name, String description, StandingsCategoryType categoryType, Class<? extends StandingsCategory> categoryClass, List<? extends StandingsCategory> categories) {
        this.name = name;
        this.description = description;
        this.categoryType = categoryType;
        this.categoryClass = categoryClass;
        this.categories = categories;
        this.raceClassGroupOrganizations = null;
    }

    protected StandardOrganizationType(String name, String description, StandingsCategoryType categoryType, Class<? extends StandingsCategory> categoryClass, List<? extends StandingsCategory> categories, Class<? extends RaceClass<?>> raceClassClass) {
        this(name, description, categoryType, categoryClass, categories);
        this.raceClassClass = raceClassClass;
    }

    protected StandardOrganizationType(String name, String description, StandingsCategoryType categoryType, Class<? extends StandingsCategory> categoryClass, List<? extends StandingsCategory> categories, Map<Class<? extends RaceClass<?>>, StandardOrganizationType> raceClassGroupOrganizations) {
        this(name, description, categoryType, categoryClass, categories);
        this.raceClassGroupOrganizations = raceClassGroupOrganizations;
    }

    @Override
    public Class<? extends StandingsCategory> categoryClass() {
        return this.categoryClass;
    }

    @Override
    public StandingsCategoryType categoryType() {
        return this.categoryType;
    }

    @Override
    public String categoryDescription(StandingsCategory category) {
        return category.description();
    }

    @Override
    public String categoryName(StandingsCategory category) {
        return category.name();
    }

    @Override
    public List<? extends StandingsCategory> categories() {
        return this.categories;
    }

    @Override
    public String description() {
        return this.description;
    }

    public StandingsOrganizationType getActualOrganizationType(Class<? extends RaceClass<?>> raceClassClass) {
        StandingsOrganizationType organizationType = this.raceClassGroupOrganizations.get(raceClassClass);
        if (organizationType != null && !((StandardOrganizationType)organizationType).raceClassClass.equals(raceClassClass)) {
            throw new IllegalStateException("OOPS: mismatch in race group placeholder binding");
        }
        return organizationType;
    }

    public boolean isGroupPlaceholder() {
        return this.categories == null && this.raceClassGroupOrganizations != null;
    }

    @Override
    public boolean isSupportedOnCourseArrangement(CourseArrangement courseArrangement) {
        return true;
    }

    @Override
    public boolean isSupportedOnRaceClass(Class<? extends RaceClass<?>> raceClassClass) {
        return true;
    }

    @Override
    public String name() {
        return this.name;
    }

    public String toString() {
        return String.format("a %s {%s, %s}", this.getClass().getSimpleName(), this.name, this.categoryClass.getSimpleName());
    }

    protected static List<StandingsOrganizationType> registerStandardOrganizationTypes() {
        ArrayList<StandingsOrganizationType> standardTypes = new ArrayList<StandingsOrganizationType>();
        for (Class<RaceClass<?>> raceClassClass : RaceClass.getAllRaceClasses()) {
            StandardOrganizationType organizationType = StandardOrganizationType.constructForRaceClass("ByClass", "By Class", raceClassClass, RaceClass.getStandingsCategories(raceClassClass));
            StandardOrganizationType.registerOrganizationType(organizationType);
        }
        StandardOrganizationType.registerStandardOrganizationType(new StandardOrganizationType("ByClass", "By Class [PLACEHOLDER]", StandingsCategoryType.race_class, RaceClass.class, null), standardTypes);
        StandardOrganizationType.registerStandardOrganizationType(StandardOrganizationType.constructForGender(), standardTypes);
        HashMap<Class<RaceClass<?>>, StandardOrganizationType> raceClassGroupOrganizations = new HashMap();
        Class groupRaceClassClass = NationalClass_2000.class;
        StandardOrganizationType groupOrganization = StandardOrganizationType.constructForNationalGroup("ByNationalGroup", "By National Group", NationalClassGroup_2000.class, NationalClassGroup_2000.values(), groupRaceClassClass);
        StandardOrganizationType.registerOrganizationType(groupOrganization);
        raceClassGroupOrganizations.put(groupRaceClassClass, groupOrganization);
        groupRaceClassClass = NationalClass_2016.class;
        groupOrganization = StandardOrganizationType.constructForNationalGroup("ByNationalGroup", "By National Group", NationalClassGroup_2016.class, NationalClassGroup_2016.values(), groupRaceClassClass);
        StandardOrganizationType.registerOrganizationType(groupOrganization);
        raceClassGroupOrganizations.put(groupRaceClassClass, groupOrganization);
        StandardOrganizationType.registerStandardOrganizationType(new StandardOrganizationType("ByNationalGroup", "By National Group [PLACEHOLDER]", StandingsCategoryType.national_group, NationalClassGroup.class, null, raceClassGroupOrganizations), standardTypes);
        raceClassGroupOrganizations = new HashMap();
        groupRaceClassClass = NationalClass_2000.class;
        groupOrganization = StandardOrganizationType.constructForNationalGroupYOW("ByNationalGroupYOW", "By National Group (young/old men & women)", NationalClassGroupYOW_2000.class, NationalClassGroupYOW_2000.values(), groupRaceClassClass);
        StandardOrganizationType.registerOrganizationType(groupOrganization);
        raceClassGroupOrganizations.put(groupRaceClassClass, groupOrganization);
        groupRaceClassClass = NationalClass_2016.class;
        groupOrganization = StandardOrganizationType.constructForNationalGroupYOW("ByNationalGroupYOW", "By National Group (young/old men & women)", NationalClassGroupYOW_2016.class, NationalClassGroupYOW_2016.values(), groupRaceClassClass);
        StandardOrganizationType.registerOrganizationType(groupOrganization);
        raceClassGroupOrganizations.put(groupRaceClassClass, groupOrganization);
        StandardOrganizationType.registerStandardOrganizationType(new StandardOrganizationType("ByNationalGroupYOW", "By National Group YOW [PLACEHOLDER]", StandingsCategoryType.national_group_yow, NationalClassGroupYOW.class, null, raceClassGroupOrganizations), standardTypes);
        raceClassGroupOrganizations = new HashMap();
        groupRaceClassClass = FISMastersClass_2000.class;
        groupOrganization = StandardOrganizationType.constructForFISMastersGroup("ByFISMastersGroup", "By FIS Masters Group", FISMastersGroup_2000.class, FISMastersGroup_2000.values(), groupRaceClassClass);
        StandardOrganizationType.registerOrganizationType(groupOrganization);
        raceClassGroupOrganizations.put(groupRaceClassClass, groupOrganization);
        groupRaceClassClass = FISMastersClass_2020.class;
        groupOrganization = StandardOrganizationType.constructForFISMastersGroup("ByFISMastersGroup", "By FIS Masters Group", FISMastersGroup_2020.class, FISMastersGroup_2020.values(), groupRaceClassClass);
        StandardOrganizationType.registerOrganizationType(groupOrganization);
        raceClassGroupOrganizations.put(groupRaceClassClass, groupOrganization);
        StandardOrganizationType.registerStandardOrganizationType(new StandardOrganizationType("ByFISMastersGroup", "By FIS Masters Group [PLACEHOLDER]", StandingsCategoryType.international_group, FISMastersGroup.class, null, raceClassGroupOrganizations), standardTypes);
        StandardOrganizationType.registerStandardOrganizationType(StandardOrganizationType.constructForOverall(), standardTypes);
        StandardOrganizationType.registerStandardOrganizationType(StandardOrganizationType.constructForAffiliation(), standardTypes);
        return standardTypes;
    }

    static {
        organizationTypeRegistry = new HashMap<Class<? extends StandingsCategory>, StandingsOrganizationType>();
        supportedCategoryClasses = new ArrayList<Class<? extends StandingsCategory>>();
        organizationTypeNameIndex = new HashMap<String, StandingsOrganizationType>();
        standardOrganizationTypes = Collections.unmodifiableList(StandardOrganizationType.registerStandardOrganizationTypes());
        BY_CLASS = StandardOrganizationType.forName("ByClass");
        BY_GENDER = StandardOrganizationType.forName("ByGender");
        BY_NATIONAL_GROUP = StandardOrganizationType.forName("ByNationalGroup");
        BY_NATIONAL_GROUP_YOW = StandardOrganizationType.forName("ByNationalGroupYOW");
        BY_FIS_MASTERS_GROUP = StandardOrganizationType.forName("ByFISMastersGroup");
        BY_AFFILIATION = StandardOrganizationType.forName("ByAffiliation");
        BY_ALL_RACERS = StandardOrganizationType.forName("Overall");
    }
}

