/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.models;

import com.glaivestone.javax.util.MapX;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ussamasters.aces.racedata.models.CompetitorLicense;
import org.ussamasters.aces.racedata.models.RaceOrganization;

public class USSALicense
implements CompetitorLicense {
    public static final String FOREIGN_LICENSE_PREFIX = "X";
    public static final String UNKNOWN_LICENSE_NUMBER = "9999999";
    public static final int NUM_DIGITS_USSA_LICENSE = 7;
    public static final int NUM_DIGITS_FOREIGN_LICENSE = 6;
    public static final String TEMP_LICENSE_NUMBER = "9999999";
    public static final USSALicense TEMP_LICENSE = new USSALicense("", "9999999");
    public static final USSALicense UNKNOWN_LICENSE = new USSALicense("", "");
    protected static final Set<String> specialNumbers;
    protected static final Pattern USSA_LICENSE_REGEX;
    protected static final Map<String, RaceOrganization> ussaDivisionPrefixMap;
    protected final String prefix;
    protected final String licenseNumber;

    public static RaceOrganization getAffiliation(String ussaNumber) {
        if (ussaNumber == null) {
            return null;
        }
        RaceOrganization ussaDivision = USSALicense.getDivision(ussaNumber);
        if (ussaDivision != null) {
            return ussaDivision;
        }
        return USSALicense.isForeignLicenseNumber(ussaNumber) ? RaceOrganization.FOREIGN : null;
    }

    public static RaceOrganization getDivision(String ussaNumber) {
        return ussaDivisionPrefixMap.get(USSALicense.getPrefix(ussaNumber));
    }

    public static String getDivisionPrefix(RaceOrganization ussaDivision) {
        return MapX.getKey(ussaDivision, ussaDivisionPrefixMap);
    }

    public static String getPrefix(String ussaNumber) {
        String[] parts = USSALicense.parseLicenseString(ussaNumber);
        String prefix = parts == null ? null : parts[0];
        return prefix == null || prefix.isEmpty() ? null : prefix;
    }

    public static String getLicenseNumber(String ussaNumber) {
        String[] parts = USSALicense.parseLicenseString(ussaNumber);
        String number = parts == null ? null : parts[1];
        return number == null || number.isEmpty() ? null : number;
    }

    public static boolean isForeignOrganization(RaceOrganization anOrganization) {
        return anOrganization == RaceOrganization.FOREIGN || anOrganization.isForeignOrganization();
    }

    public static boolean isForeignLicenseNumber(String ussaNumber) {
        return ussaNumber.startsWith(FOREIGN_LICENSE_PREFIX);
    }

    public static boolean isValid(String ussaNumber) {
        String affiliationPrefix = USSALicense.getPrefix(ussaNumber);
        String licenseNumber = USSALicense.getLicenseNumber(ussaNumber);
        if (affiliationPrefix == null || licenseNumber == null) {
            return false;
        }
        if (specialNumbers.contains(ussaNumber.toUpperCase())) {
            return false;
        }
        int nDigits = licenseNumber.length();
        int[] digitCount = new int[10];
        for (int i = 0; i < nDigits; ++i) {
            char c = licenseNumber.charAt(i);
            if (!Character.isDigit(c)) {
                return false;
            }
            int n = Character.getNumericValue(c);
            digitCount[n] = digitCount[n] + 1;
        }
        if (digitCount[0] == nDigits || digitCount[9] == nDigits) {
            return false;
        }
        return USSALicense.getAffiliation(ussaNumber) != null;
    }

    public static boolean isUSSADivision(RaceOrganization anOrganization) {
        return ussaDivisionPrefixMap.containsValue(anOrganization);
    }

    public static String[] parseLicenseString(String ussaNumber) {
        String[] parts = new String[]{"", ""};
        if (ussaNumber == null || ussaNumber.trim().isEmpty()) {
            return parts;
        }
        Matcher mo = USSA_LICENSE_REGEX.matcher(ussaNumber);
        if (!mo.matches()) {
            return null;
        }
        String prefix = mo.group(1);
        String number = mo.group(2);
        if (prefix != null) {
            parts[0] = prefix;
        }
        parts[1] = number;
        return parts;
    }

    public static USSALicense fromString(String ussaNumber) {
        String[] parts = USSALicense.parseLicenseString(ussaNumber);
        if (parts == null) {
            return UNKNOWN_LICENSE;
        }
        if (parts[1].equals("9999999")) {
            return TEMP_LICENSE;
        }
        return new USSALicense(parts[0], parts[1]);
    }

    public USSALicense(String prefix, String licenseNumber) {
        this.prefix = prefix == null ? "" : prefix.trim();
        this.licenseNumber = licenseNumber == null ? "" : licenseNumber.trim();
    }

    public boolean equals(Object other) {
        return other instanceof USSALicense && this.equals((USSALicense)other);
    }

    public boolean equals(USSALicense other) {
        return this.prefix.equals(other.prefix) && this.licenseNumber.equals(other.licenseNumber);
    }

    public int hashCode() {
        return this.prefix.hashCode() + this.licenseNumber.hashCode();
    }

    @Override
    public String getLicenseNumber() {
        return this.licenseNumber;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String toString() {
        return this.prefix + this.licenseNumber;
    }

    static {
        USSA_LICENSE_REGEX = Pattern.compile("\\s*([A-Z]?)(\\d+)\\s*");
        ussaDivisionPrefixMap = Collections.unmodifiableMap(new HashMap<String, RaceOrganization>(){
            {
                this.put("F", RaceOrganization.FAR_WEST);
                this.put("P", RaceOrganization.PNSA);
                this.put("N", RaceOrganization.NORTHERN);
                this.put("I", RaceOrganization.INTERMOUNTAIN);
                this.put("R", RaceOrganization.ROCKY);
                this.put("C", RaceOrganization.CENTRAL);
                this.put("E", RaceOrganization.EASTERN);
                this.put("A", RaceOrganization.ALASKA);
            }
        });
        if (ussaDivisionPrefixMap.size() != RaceOrganization.ussaDivisions.size()) {
            throw new IllegalStateException("USSANumber division prefix map inconsistent with USSA division definitions");
        }
        specialNumbers = Collections.unmodifiableSet(new HashSet<String>(){
            {
                this.add("9999999");
            }
        });
    }
}

