/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.scoring;

import java.util.List;
import org.ussamasters.aces.racedata.models.ParameterSpecification;
import org.ussamasters.aces.racedata.models.ParameterType;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceClassRegistry;
import org.ussamasters.aces.racedata.models.RaceClassType;
import org.ussamasters.aces.racedata.models.RaceSeriesResult;
import org.ussamasters.aces.racedata.models.RaceStartResult;
import org.ussamasters.aces.racedata.models.RaceTime;
import org.ussamasters.aces.racedata.models.ScoringElement;
import org.ussamasters.aces.racedata.models.StandingsCategory;
import org.ussamasters.aces.racedata.scoring.BernardCupHandicapFormula;
import org.ussamasters.aces.racedata.scoring.MustFinishAllRacesScoringPolicy;
import org.ussamasters.aces.racedata.scoring.ScoringPolicySpecification;
import org.ussamasters.aces.racedata.scoring.SeriesResultsOrganizer;
import org.ussamasters.aces.racedata.scoring.SeriesStandingsScoringPolicy;

public class BernardCupScoringPolicy
extends MustFinishAllRacesScoringPolicy {
    public static final String PARM_FORMULA_NAME = "formula";
    public static final String DEFAULT_FORMULA_NAME = "automatic";
    protected BernardCupHandicapFormula scoringFormula;

    public static ParameterSpecification createFormulaParmSpec(String formulaName) {
        return new ParameterSpecification(PARM_FORMULA_NAME, "Handicap formula", "Age handicap formula for event and age class ranges", ParameterType.STRING, true, formulaName);
    }

    public static SeriesStandingsScoringPolicy forElement(ScoringElement scoringElement) {
        if (scoringElement != ScoringElement.ADJUSTED_TIME) {
            throw new IllegalArgumentException("Bernard Cup is scored by handicap-adjusted finish time");
        }
        return new BernardCupScoringPolicy();
    }

    public BernardCupScoringPolicy() {
        super(ScoringElement.ADJUSTED_TIME);
    }

    protected RaceTime computeAdjustedTime(RaceTime actualTime, RaceClass<?> ageClass) {
        return this.scoringFormula.computeAdjustedTime(actualTime, ageClass);
    }

    @Override
    protected void computeSeriesTotals(StandingsCategory category, RaceSeriesResult seriesResult, List<RaceStartResult> starts) {
        super.computeSeriesTotals(category, seriesResult, starts);
        if (seriesResult.isFinisher()) {
            RaceTime actualTime = seriesResult.getTime();
            RaceClass<?> ageClass = this.getRacerAgeClass(seriesResult);
            seriesResult.setAdjustedTime(this.computeAdjustedTime(actualTime, ageClass));
            seriesResult.clearPoints();
        }
    }

    @Override
    public void configureOptions(ScoringPolicySpecification policySpec) {
        String formulaName = (String)policySpec.getParameter(PARM_FORMULA_NAME, DEFAULT_FORMULA_NAME);
        if (!formulaName.equals(DEFAULT_FORMULA_NAME)) {
            this.setScoringFormula(formulaName);
        }
    }

    protected RaceClass<?> getRacerAgeClass(RaceSeriesResult seriesResult) {
        return RaceClassRegistry.current().getRaceClassType(this.getSeriesRaceClass()) == RaceClassType.us_masters ? seriesResult.getRacer().getNationalClass() : seriesResult.getRacer().getAgeClass();
    }

    @Override
    protected String getScoringElementDescription(ScoringElement aScoringElement) {
        return "age-adjusted total time (" + this.scoringFormula.description + ")";
    }

    protected void initHandicapComputationFactors() {
        if (this.scoringFormula == null) {
            this.setScoringFormula(BernardCupHandicapFormula.formulaForSeries(this.getResultsData().getRaceSeries()));
        }
    }

    @Override
    public String name() {
        return "BernardCup";
    }

    protected void setResultsData(SeriesResultsOrganizer seriesResultsData) {
        super.setResultsData(seriesResultsData);
        this.initHandicapComputationFactors();
    }

    protected void setScoringFormula(BernardCupHandicapFormula scoringFormula) {
        this.scoringFormula = scoringFormula;
    }

    public void setScoringFormula(String formulaName) {
        BernardCupHandicapFormula scoringFormula = BernardCupHandicapFormula.formulaForName(formulaName);
        if (scoringFormula == null) {
            throw new IllegalArgumentException("Unknown Bernard Cup scoring formula name: " + formulaName);
        }
        this.setScoringFormula(scoringFormula);
    }
}

