/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.scoring;

import java.util.List;
import org.ussamasters.aces.racedata.models.RaceSeriesResult;
import org.ussamasters.aces.racedata.models.RaceStartResult;
import org.ussamasters.aces.racedata.models.StandingsCategory;
import org.ussamasters.aces.racedata.models.WorldCupPointsFactory;
import org.ussamasters.aces.racedata.scoring.AgeClassAbilityBonusScoringPolicy;
import org.ussamasters.aces.racedata.scoring.ScoringPolicySpecification;

public class BestNFinishesAgeClassAbilityBonusScoringPolicy
extends AgeClassAbilityBonusScoringPolicy {
    public static final String PARM_MAX_FINISHES_TO_COUNT = "maxFinishes";
    private int bestNCount;

    public BestNFinishesAgeClassAbilityBonusScoringPolicy(int bestNCount) {
        this.bestNCount = bestNCount;
    }

    public BestNFinishesAgeClassAbilityBonusScoringPolicy(int bestNCount, WorldCupPointsFactory pointsFactory, int ageClassAbilityScore, boolean includeAbilityClasses) {
        super(pointsFactory, ageClassAbilityScore, includeAbilityClasses);
        this.bestNCount = bestNCount;
    }

    @Override
    protected void completeAgeClassAbilityResultsUpdate(RaceSeriesResult ageClassResults, RaceSeriesResult abilityClassResults) {
        super.completeAgeClassAbilityResultsUpdate(ageClassResults, abilityClassResults);
        if (ageClassResults.getNumberOfFinishes() > this.bestNCount) {
            this.computeSeriesTotals(ageClassResults.getCategory(), ageClassResults);
        }
    }

    @Override
    public void configureOptions(ScoringPolicySpecification policySpec) {
        Integer maxFinishesToCount = (Integer)policySpec.getParameter(PARM_MAX_FINISHES_TO_COUNT);
        if (maxFinishesToCount != null) {
            this.bestNCount = maxFinishesToCount;
        }
        super.configureOptions(policySpec);
    }

    @Override
    protected void computeSeriesTotals(StandingsCategory category, RaceSeriesResult seriesResult) {
        List<RaceStartResult> finishes = this.selectBestNFinishes(this.bestNCount, seriesResult);
        this.computeSeriesTotals(category, seriesResult, finishes);
    }

    @Override
    protected String getScoringQualificationDescription() {
        return String.format("best %s finishes%s", this.bestNCount, this.getAbilityBonusQualificationDescription());
    }

    @Override
    public String name() {
        return "BestNFinishesACAB";
    }
}

