/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.scoring;

import java.util.Iterator;
import java.util.List;
import org.ussamasters.aces.racedata.models.RaceOrganization;
import org.ussamasters.aces.racedata.models.RaceSeries;
import org.ussamasters.aces.racedata.models.RaceSeriesResult;
import org.ussamasters.aces.racedata.models.RaceStartResult;
import org.ussamasters.aces.racedata.models.RacerList;
import org.ussamasters.aces.racedata.models.StandingsCategory;
import org.ussamasters.aces.racedata.models.StandingsOrganizationType;
import org.ussamasters.aces.racedata.scoring.BasicEventStandings;
import org.ussamasters.aces.racedata.scoring.BasicRaceSeriesResultsOrganizer;
import org.ussamasters.aces.racedata.scoring.CategoryResultsList;
import org.ussamasters.aces.racedata.scoring.MedalCountsResult;
import org.ussamasters.aces.racedata.scoring.MedalCountsResultsOrganizer;
import org.ussamasters.aces.racedata.scoring.MedalCountsScoringPolicy;
import org.ussamasters.aces.racedata.scoring.SeriesStandingsScoringPolicy;

public class MedalCountsStandings
extends BasicEventStandings {
    protected static final StandingsOrganizationType MEDAL_COUNTS_ORGANIZATION_TYPE = MedalCountsResultsOrganizer.ORGANIZATION_TYPE;

    public static MedalCountsStandings computeStandings(String eventShortName, RaceSeries raceSeries, RacerList registeredRacers) {
        MedalCountsStandings standings = new MedalCountsStandings(eventShortName, raceSeries, registeredRacers);
        standings.computeStandings();
        return standings;
    }

    public static MedalCountsStandings forRaceSeries(String eventShortName, RaceSeries raceSeries, RacerList registeredRacers, StandingsOrganizationType organizationType) {
        if (organizationType != MEDAL_COUNTS_ORGANIZATION_TYPE) {
            throw new IllegalArgumentException("Invalid results organization: " + organizationType.name());
        }
        return new MedalCountsStandings(eventShortName, raceSeries, registeredRacers);
    }

    public MedalCountsStandings(String eventShortName, RaceSeries raceSeries, RacerList registeredRacers) {
        this(eventShortName, raceSeries, registeredRacers, new MedalCountsScoringPolicy());
    }

    public MedalCountsStandings(String eventShortName, RaceSeries raceSeries, RacerList registeredRacers, SeriesStandingsScoringPolicy scoringPolicy) {
        super(eventShortName, raceSeries, (BasicRaceSeriesResultsOrganizer)MedalCountsResultsOrganizer.forRaceSeries(raceSeries, registeredRacers));
        this.setScoringPolicy(scoringPolicy);
    }

    @Override
    public void computeStandings(SeriesStandingsScoringPolicy scoringPolicy) {
        super.computeStandings(scoringPolicy);
        this.pruneToMedalFinishes();
    }

    public List<MedalCountsResult> getTeamResults() {
        return ((MedalCountsResultsOrganizer)this.getResultsData()).getTeamResults();
    }

    protected void pruneToMedalFinishes() {
        MedalCountsResultsOrganizer myResultsData = (MedalCountsResultsOrganizer)this.getResultsData();
        for (StandingsCategory category : myResultsData.getCategories()) {
            RaceOrganization affiliation = (RaceOrganization)category;
            CategoryResultsList categoryResultsList = myResultsData.getCategoryResults(affiliation);
            if (categoryResultsList == null) continue;
            Iterator iter = categoryResultsList.iterator();
            while (iter.hasNext()) {
                RaceSeriesResult seriesResult = (RaceSeriesResult)iter.next();
                if (!seriesResult.isQualified()) {
                    iter.remove();
                    continue;
                }
                List<RaceStartResult> starts = seriesResult.starts();
                for (int raceIndex = 0; raceIndex < starts.size(); ++raceIndex) {
                    int position;
                    RaceStartResult racerResult = starts.get(raceIndex);
                    if (racerResult == null || (position = racerResult.getPosition()) > 0 && position <= 3) continue;
                    seriesResult.pruneStartResult(raceIndex);
                }
            }
        }
    }
}

