/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.scoring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ussamasters.aces.racedata.models.CourseArrangement;
import org.ussamasters.aces.racedata.models.FiveYearRangeRaceClass;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceClassRegistry;
import org.ussamasters.aces.racedata.models.RaceClassType;
import org.ussamasters.aces.racedata.models.RaceEntryResult;
import org.ussamasters.aces.racedata.models.RaceResult;
import org.ussamasters.aces.racedata.models.RaceSummaryStatistics;
import org.ussamasters.aces.racedata.models.RacerResult;
import org.ussamasters.aces.racedata.models.StandardOrganizationType;
import org.ussamasters.aces.racedata.models.StandingsCategory;
import org.ussamasters.aces.racedata.models.StandingsOrganizationType;
import org.ussamasters.aces.racedata.models.StandingsSummaryData;
import org.ussamasters.aces.racedata.models.StandingsType;
import org.ussamasters.aces.racedata.scoring.CategoryResultsList;
import org.ussamasters.aces.racedata.scoring.RaceResultOrganizer;
import org.ussamasters.aces.racedata.scoring.RaceStandingsScoringPolicy;
import org.ussamasters.aces.racedata.scoring.RacerResultOrganizingPolicy;
import org.ussamasters.aces.racedata.scoring.ScoringPolicy;
import org.ussamasters.aces.racedata.scoring.StandardRaceScoringPolicy;
import org.ussamasters.aces.racedata.scoring.Standings;

public class RaceStandings
extends Standings {
    public static final List<StandingsOrganizationType> STANDARD_ORGANIZATION_TYPES = RaceStandings.constructStandardOrganizationTypes();
    private RaceResult raceResult;
    private RaceResultOrganizer resultsData;

    protected RaceStandings(RaceResult raceResult, RaceResultOrganizer resultsData) {
        super(StandingsType.RACE, resultsData.getOrganizationType());
        this.raceResult = raceResult;
        this.resultsData = resultsData;
    }

    public static RaceResult computeCanonicalStandings(RaceResult aRaceResult) {
        RaceStandings canonicalForm = RaceStandings.computeStandings(aRaceResult, StandardOrganizationType.BY_CLASS);
        return canonicalForm.getRaceResult();
    }

    public static void computeRacePoints(RaceResult aRaceResult, StandingsOrganizationType organizationType) {
        RacerResultOrganizingPolicy<RaceEntryResult> organizingPolicy = RaceResultOrganizer.getOrganizingPolicy(RaceStandings.getActualOrganizationType(organizationType, aRaceResult.getRaceClassClass()));
        StandardRaceScoringPolicy scoringPolicy = StandardRaceScoringPolicy.forRaceResult(aRaceResult);
        Object currentCategory = null;
        ArrayList<RaceEntryResult> categoryResultList = new ArrayList<RaceEntryResult>();
        for (RacerResult rr : aRaceResult.getRacerResults()) {
            RaceEntryResult racerResult = (RaceEntryResult)rr;
            StandingsCategory category = organizingPolicy.getCategory(racerResult);
            if (category != currentCategory) {
                scoringPolicy.computeRacePoints(categoryResultList);
                categoryResultList = new ArrayList();
            }
            categoryResultList.add(racerResult);
        }
        aRaceResult.setFValue(scoringPolicy.getFValue());
    }

    public static List<RaceStandings> computeStandings(RaceResult raceResult) {
        ArrayList<RaceStandings> allStandings = new ArrayList<RaceStandings>();
        for (StandingsOrganizationType organizationType : STANDARD_ORGANIZATION_TYPES) {
            RaceStandings standings = RaceStandings.computeStandings(raceResult, organizationType);
            if (standings == null) continue;
            allStandings.add(standings);
        }
        return allStandings;
    }

    public static RaceStandings computeStandings(RaceResult raceResult, StandingsOrganizationType organizationType) {
        RaceStandings standings = RaceStandings.forRaceResult(raceResult, organizationType);
        if (standings == null) {
            return null;
        }
        standings.computeStandings();
        return standings;
    }

    public static RaceStandings constructStandings(RaceResult raceResult, StandingsOrganizationType actualOrganizationType) {
        RaceResult copiedResults = raceResult.copy();
        return new RaceStandings(copiedResults, RaceResultOrganizer.forRaceResult(copiedResults, actualOrganizationType));
    }

    public static RaceStandings forRaceResult(RaceResult raceResult, StandingsOrganizationType organizationType) {
        StandingsOrganizationType actualOrganizationType = RaceStandings.getActualOrganizationType(organizationType, raceResult);
        return actualOrganizationType != null ? RaceStandings.constructStandings(raceResult, actualOrganizationType) : null;
    }

    public static StandingsOrganizationType getActualOrganizationType(StandingsOrganizationType organizationType, RaceResult raceResult) {
        StandingsOrganizationType actualOrganizationType = RaceStandings.getActualOrganizationType(organizationType, raceResult.getRaceClassClass());
        return RaceStandings.isActualOrganizationSupported(actualOrganizationType, raceResult) ? actualOrganizationType : null;
    }

    public static boolean isNationalsCourseSplitWithSeparateGroupDMensCourse(RaceResult raceResult) {
        Class<? extends RaceClass<?>> raceClassClass = raceResult.getRaceClassClass();
        RaceClassType raceClassType = RaceClassRegistry.current().getRaceClassType(raceClassClass);
        CourseArrangement courseArrangement = raceResult.getCourseArrangement();
        return (raceClassType == RaceClassType.us_masters || raceClassType == RaceClassType.intermountain_masters || raceClassType == RaceClassType.farwest_masters && FiveYearRangeRaceClass.class.isAssignableFrom(raceClassClass)) && courseArrangement == CourseArrangement.SEPARATE_COURSES_BY_NATIONAL_GROUPS_AB_CD;
    }

    protected static boolean isActualOrganizationSupported(StandingsOrganizationType actualOrganizationType, RaceResult raceResult) {
        if (actualOrganizationType == null) {
            return false;
        }
        if (RaceResultOrganizer.getOrganizingPolicy(actualOrganizationType) == null) {
            return false;
        }
        return actualOrganizationType.isSupportedOnRaceClass(raceResult.getRaceClassClass()) && actualOrganizationType.isSupportedOnCourseArrangement(raceResult.getCourseArrangement());
    }

    public static boolean isSupportedOrganization(StandingsOrganizationType organizationType, RaceResult raceResult) {
        StandingsOrganizationType actualOrganizationType = RaceStandings.getActualOrganizationType(organizationType, raceResult.getRaceClassClass());
        return RaceStandings.isActualOrganizationSupported(actualOrganizationType, raceResult);
    }

    @Override
    public void computeStandings() {
        this.computeStandings(StandardRaceScoringPolicy.forRace(this.getRaceResult()));
    }

    @Override
    public void computeStandings(ScoringPolicy scoringPolicy) {
        this.computeStandings((RaceStandingsScoringPolicy)scoringPolicy);
    }

    public void computeStandings(RaceStandingsScoringPolicy scoringPolicy) {
        boolean needToClearStats = false;
        if (needToClearStats) {
            this.getRaceResult().clearFinishStatistics();
        }
        this.resultsData.organizeResults();
        scoringPolicy.computeStandings(this.resultsData);
        this.installStandings(this.getRaceResult());
    }

    public CategoryResultsList<RaceEntryResult> getCategoryResults(StandingsCategory category) {
        return this.resultsData.getCategoryResults(category);
    }

    @Override
    public StandingsSummaryData[] getCompetitorStatistics() {
        return this.getSummaryStatistics().getCompetitorStatistics();
    }

    @Override
    public StandingsSummaryData[] getQualifierStatistics() {
        return this.getSummaryStatistics().getQualifierStatistics();
    }

    public RaceResult getRaceResult() {
        return this.raceResult;
    }

    public RaceSummaryStatistics getSummaryStatistics() {
        return this.raceResult.getSummaryStatistics();
    }

    public void installStandings(RaceResult aRaceResult) {
        aRaceResult.installStandings(this.resultsData.getFValue(), this.resultsData.concatenateCategoryLists());
    }

    @Override
    public String rootReferenceName() {
        return this.getRaceResult().getRaceId().toReferenceString();
    }

    public String toString() {
        return String.format("a %s using %s on %s", this.getClass().getSimpleName(), this.getOrganizationType(), this.getRaceResult());
    }

    protected static List<StandingsOrganizationType> constructStandardOrganizationTypes() {
        ArrayList<StandingsOrganizationType> standardTypes = new ArrayList<StandingsOrganizationType>();
        standardTypes.add(StandardOrganizationType.BY_CLASS);
        standardTypes.add(StandardOrganizationType.BY_GENDER);
        standardTypes.add(StandardOrganizationType.BY_NATIONAL_GROUP);
        standardTypes.add(StandardOrganizationType.BY_FIS_MASTERS_GROUP);
        standardTypes.add(StandardOrganizationType.BY_ALL_RACERS);
        return Collections.unmodifiableList(standardTypes);
    }
}

