/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.scoring;

import org.ussamasters.aces.racedata.models.RaceSeries;
import org.ussamasters.aces.racedata.models.RacerList;
import org.ussamasters.aces.racedata.models.StandardOrganizationType;
import org.ussamasters.aces.racedata.models.StandingsOrganizationType;
import org.ussamasters.aces.racedata.scoring.BasicEventStandings;
import org.ussamasters.aces.racedata.scoring.BasicRaceSeriesResultsOrganizer;
import org.ussamasters.aces.racedata.scoring.SeriesResultsOrganizer;
import org.ussamasters.aces.racedata.scoring.SeriesStandings;
import org.ussamasters.aces.racedata.scoring.SeriesStandingsScoringPolicy;
import org.ussamasters.aces.racedata.scoring.SiseCupScoringPolicy;

public class SiseCupStandings
extends BasicEventStandings {
    protected static final StandingsOrganizationType SISE_CUP_ORGANIZATION_TYPE = StandardOrganizationType.BY_CLASS;

    public static SiseCupStandings forRaceSeries(String eventShortName, RaceSeries raceSeries, RacerList registeredRacers) {
        StandingsOrganizationType actualOrganizationType = SiseCupStandings.getActualOrganizationType(SISE_CUP_ORGANIZATION_TYPE, raceSeries);
        if (actualOrganizationType == null) {
            throw new RuntimeException("OOPS: unable to determine series race class for Sise Cup standings");
        }
        return new SiseCupStandings(eventShortName, raceSeries, registeredRacers, actualOrganizationType);
    }

    public static SeriesStandings forRaceSeries(String eventShortName, RaceSeries raceSeries, RacerList registeredRacers, StandingsOrganizationType organizationType) {
        if (organizationType != SISE_CUP_ORGANIZATION_TYPE) {
            throw new IllegalArgumentException("Invalid results organization: " + organizationType.name());
        }
        return SiseCupStandings.forRaceSeries(eventShortName, raceSeries, registeredRacers);
    }

    private SiseCupStandings(String eventShortName, RaceSeries raceSeries, RacerList registeredRacers, StandingsOrganizationType actualOrganizationType) {
        super(eventShortName, raceSeries, (BasicRaceSeriesResultsOrganizer)SeriesResultsOrganizer.forRaceSeries(raceSeries, registeredRacers, actualOrganizationType));
    }

    @Override
    public void computeStandings(SeriesStandingsScoringPolicy scoringPolicy) {
        if (!(scoringPolicy instanceof SiseCupScoringPolicy)) {
            throw new UnsupportedOperationException("Only standard Sise Cup standings computation is allowed");
        }
        super.computeStandings(scoringPolicy);
    }
}

