/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.scoring;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ussamasters.aces.racedata.models.DivisionsCupPoints;
import org.ussamasters.aces.racedata.models.ParameterSpecification;
import org.ussamasters.aces.racedata.models.ParameterType;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RacePoints;
import org.ussamasters.aces.racedata.models.RaceSeriesResult;
import org.ussamasters.aces.racedata.models.RaceStartResult;
import org.ussamasters.aces.racedata.models.RaceTime;
import org.ussamasters.aces.racedata.models.RacerResult;
import org.ussamasters.aces.racedata.models.ScoringElement;
import org.ussamasters.aces.racedata.models.SiseCupPoints;
import org.ussamasters.aces.racedata.models.StandingsCategory;
import org.ussamasters.aces.racedata.models.StandingsOrganizationType;
import org.ussamasters.aces.racedata.models.WorldCupPoints;
import org.ussamasters.aces.racedata.models.WorldCupPointsFactory;
import org.ussamasters.aces.racedata.scoring.BasicRaceSeriesResultsOrganizer;
import org.ussamasters.aces.racedata.scoring.BasicScoringPolicy;
import org.ussamasters.aces.racedata.scoring.CategoryResultsList;
import org.ussamasters.aces.racedata.scoring.ScoringElementAccessor;
import org.ussamasters.aces.racedata.scoring.ScoringPolicySpecification;
import org.ussamasters.aces.racedata.scoring.SeriesStandingsScoringPolicy;

public class StandardSeriesScoringPolicy
extends BasicScoringPolicy
implements SeriesStandingsScoringPolicy {
    public static final int AGE_CLASS_ABILITY_BONUS_SCORE_POSITION = -999;
    public static final String PARM_MAX_FINISHES_TO_COUNT = "maxFinishes";
    protected static Map<ScoringElement, String> scoringElementDescriptions = Collections.unmodifiableMap(new HashMap<ScoringElement, String>(){
        {
            this.put(ScoringElement.TIME, "total time");
            this.put(ScoringElement.ADJUSTED_TIME, "handicapped total time");
            this.put(ScoringElement.POINTS, "total World Cup points");
            this.put(ScoringElement.RACE_POINTS, "total race points");
            this.put(ScoringElement.SISE_CUP_POINTS, "total Sise Cup points");
            this.put(ScoringElement.DIVISIONS_CUP_POINTS, "total Divisions Cup points");
        }
    });
    private boolean mustStartAllRaces;
    private boolean mustFinishAllRaces;
    private BasicRaceSeriesResultsOrganizer resultsData;
    private int nRaces;

    public static ParameterSpecification createMaxFinishesParmSpec(int maxFinishesToCount) {
        return new ParameterSpecification(PARM_MAX_FINISHES_TO_COUNT, "Max finishes", "Max number of finishes that count in scoring", ParameterType.INTEGER, true, new Integer(maxFinishesToCount));
    }

    public static SeriesStandingsScoringPolicy forElement(ScoringElement scoringElement) {
        return new StandardSeriesScoringPolicy(scoringElement);
    }

    public StandardSeriesScoringPolicy(ScoringElement scoringElement) {
        this(scoringElement, false, false);
    }

    public StandardSeriesScoringPolicy(ScoringElement scoringElement, boolean mustStartAllRaces, boolean mustFinishAllRaces) {
        super(scoringElement);
        this.setMustStartAllRaces(mustStartAllRaces);
        this.setMustFinishAllRaces(mustFinishAllRaces);
    }

    protected void addPoints(RaceSeriesResult seriesResult, WorldCupPoints<?> wcPoints) {
        WorldCupPoints<?> currentPoints = seriesResult.getPoints();
        int newPoints = currentPoints.intValue() + wcPoints.intValue();
        WorldCupPointsFactory factory = WorldCupPoints.getFactory(currentPoints);
        seriesResult.setPoints(factory.forPoints(newPoints));
    }

    @Override
    protected void clearFinishPosition(RacerResult racerResult) {
        racerResult.clearPosition();
    }

    protected void computeFinishPositions() {
        for (StandingsCategory category : this.resultsData.getCategories()) {
            CategoryResultsList<RaceSeriesResult> categoryResultsList = this.resultsData.getCategoryResults(category);
            if (categoryResultsList == null) continue;
            this.computeFinishPositions(category, categoryResultsList);
        }
    }

    protected void computeFinishPositions(StandingsCategory category, CategoryResultsList<RaceSeriesResult> categoryResultsList) {
        this.sortResults((List<? extends RacerResult>)categoryResultsList);
        this.assignFinishPositions(categoryResultsList);
    }

    protected void computeSeriesTotals() {
        for (StandingsCategory category : this.resultsData.getCategories()) {
            CategoryResultsList<RaceSeriesResult> categoryResultsList = this.resultsData.getCategoryResults(category);
            if (categoryResultsList == null) continue;
            this.computeSeriesTotals(category, categoryResultsList);
        }
    }

    protected void computeSeriesTotals(StandingsCategory category, CategoryResultsList<RaceSeriesResult> categoryResultsList) {
        for (RaceSeriesResult seriesResult : categoryResultsList) {
            this.computeSeriesTotals(seriesResult.getCategory(), seriesResult);
        }
    }

    protected void computeSeriesTotals(StandingsCategory category, RaceSeriesResult seriesResult) {
        this.computeSeriesTotals(category, seriesResult, seriesResult.starts());
    }

    protected void computeSeriesTotals(StandingsCategory category, RaceSeriesResult seriesResult, List<RaceStartResult> starts) {
        RaceTime totalTime = RaceTime.ZERO;
        int totalPoints = 0;
        RacePoints totalRacePoints = RacePoints.ZERO;
        DivisionsCupPoints totalDivisionsCupPoints = DivisionsCupPoints.ZERO;
        SiseCupPoints totalSiseCupPoints = SiseCupPoints.ZERO;
        for (RaceStartResult racerResult : starts) {
            if (racerResult == null || !racerResult.isFinisher()) continue;
            totalTime = totalTime.add(racerResult.getTime());
            totalPoints += racerResult.getPoints().intValue();
            totalRacePoints = totalRacePoints.add(racerResult.getRacePoints());
            totalDivisionsCupPoints = totalDivisionsCupPoints.add(racerResult.getDivisionsCupPoints());
            totalSiseCupPoints = totalSiseCupPoints.add(SiseCupPoints.forPosition(racerResult.getPosition()));
        }
        seriesResult.setTime(totalTime);
        seriesResult.setPoints(this.getPointsFactory().forPoints(totalPoints));
        seriesResult.setRacePoints(totalRacePoints);
        seriesResult.setDivisionsCupPoints(totalDivisionsCupPoints);
        seriesResult.setSiseCupPoints(totalSiseCupPoints);
        if (!this.isQualifiedForSeriesStandings(seriesResult)) {
            this.markRacerAsUnqualifiedForStandings(seriesResult);
        }
    }

    @Override
    public void computeStandings(BasicRaceSeriesResultsOrganizer seriesResultsData) {
        this.setResultsData(seriesResultsData);
        this.computeSeriesTotals();
        this.computeFinishPositions();
    }

    @Override
    public void configureOptions(ScoringPolicySpecification policySpec) {
    }

    @Override
    public String description() {
        return String.format("%s across %s", this.getScoringElementDescription(this.getScoringElement()), this.getScoringQualificationDescription());
    }

    @Override
    public String getDescription(StandingsOrganizationType organizationType) {
        return String.format("Standings scoring policy: %s - %s", organizationType.description(), this.description());
    }

    protected BasicRaceSeriesResultsOrganizer getResultsData() {
        return this.resultsData;
    }

    protected String getScoringElementDescription(ScoringElement aScoringElement) {
        return scoringElementDescriptions.get(aScoringElement);
    }

    protected WorldCupPointsFactory getPointsFactory() {
        return this.resultsData.getRaceSeries().getPointsFactory();
    }

    protected String getScoringQualificationDescription() {
        return this.mustFinishAllRaces ? "all races (must finish all races to qualify)" : (this.mustStartAllRaces ? "all races (must start all races to qualify)" : "all races");
    }

    protected Class<? extends RaceClass<?>> getSeriesRaceClass() {
        return this.resultsData.getRaceSeries().getRaceClassClass();
    }

    @Override
    protected boolean isQualifiedForFinishPosition(RacerResult racerResult) {
        return ((RaceSeriesResult)racerResult).isQualified();
    }

    protected boolean isQualifiedForSeriesStandings(RaceSeriesResult seriesResult) {
        if (this.mustStartAllRaces && seriesResult.getNumberOfStarts() != this.nRaces) {
            return false;
        }
        return !this.mustFinishAllRaces || seriesResult.getNumberOfFinishes() == this.nRaces;
    }

    protected void markRacerAsUnqualifiedForStandings(RaceSeriesResult seriesResult) {
        seriesResult.markUnqualified();
    }

    @Override
    public boolean mustStartAllRaces() {
        return this.mustStartAllRaces;
    }

    @Override
    public boolean mustFinishAllRaces() {
        return this.mustFinishAllRaces;
    }

    @Override
    public String name() {
        return "Standard";
    }

    public void setMustFinishAllRaces(boolean mustFinishAllRaces) {
        if (mustFinishAllRaces) {
            this.setMustStartAllRaces(true);
        }
        this.mustFinishAllRaces = mustFinishAllRaces;
    }

    public void setMustStartAllRaces(boolean mustStartAllRaces) {
        this.mustStartAllRaces = mustStartAllRaces;
    }

    protected void setResultsData(BasicRaceSeriesResultsOrganizer seriesResultsData) {
        this.resultsData = seriesResultsData;
        this.nRaces = seriesResultsData.getNumberOfRaces();
    }

    protected void sortStartResults(List<RaceStartResult> startResultsList, ScoringElement scoringElement) {
        ScoringElementAccessor.forScoringElement(scoringElement).sortResults(startResultsList);
    }

    public String toString() {
        return String.format("%s<%s, %s>", this.getClass().getSimpleName(), this.name(), this.policyDescriptionDetails());
    }

    protected String policyDescriptionDetails() {
        return String.format("%s, %s", this.getScoringElementDescription(this.getScoringElement()), this.getScoringQualificationDescription());
    }
}

