/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.foundation.models;

import com.glaivestone.toolbox.settings.SettingsSection;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.SeasonIdentifier;
import org.ussamasters.aces.racedata.models.WorldCupPointsType;
import org.ussamasters.aces.tools.foundation.models.SeriesScoringSpecification;

public class EventScoringSpecification
extends SeriesScoringSpecification {
    public static final String STANDARD_FILE_NAME_PREFIX = "Event-";
    public static final String SETTING_LAST_SELECTED_SCORING_POLICY = "selectedScoringPolicy";
    public static final String SETTING_BEST_N_FINISHES_COUNT = "bestN";
    public static final String SETTING_BERNARD_CUP_FORMULA = "bernardCupFormula";
    private static final String PROPERTY_ALLOW_GENDER_STANDINGS_HACK = "scoringPolicy-allowComputeGenderWithSeparateDCourse";
    private static final String SETTING_GENERATE_BY_CLASS_TSV = "generateByClassTSV";
    private static final String SETTING_GENERATE_DIVISIONS_CUP_TSV = "generateDivisionsCupTSV";

    public static String composeFileName(String shortName) {
        return FILE_TYPE.composeFileName(STANDARD_FILE_NAME_PREFIX + shortName);
    }

    public static EventScoringSpecification createSpecification(String eventName, String shortName, SeasonIdentifier season, Class<? extends RaceClass<?>> ageClassClass, WorldCupPointsType scoringType) {
        return new EventScoringSpecification(eventName, shortName, season, ageClassClass, scoringType);
    }

    public static synchronized EventScoringSpecification load(File configSettingsFile, SeasonIdentifier season) throws IOException {
        return new EventScoringSpecification(configSettingsFile, season);
    }

    public static List<EventScoringSpecification> loadAllFromDirectory(File aDirectory, SeasonIdentifier season) throws IOException {
        String prefix = STANDARD_FILE_NAME_PREFIX.toLowerCase();
        String extensionSuffix = FILE_TYPE.composeFileName("").toLowerCase();
        File[] fileList = aDirectory.listFiles();
        ArrayList<EventScoringSpecification> eventSpecs = new ArrayList<EventScoringSpecification>();
        for (int i = 0; i < fileList.length; ++i) {
            File aFile = fileList[i];
            String fileName = aFile.getName().toLowerCase();
            if (!fileName.startsWith(prefix) || !fileName.endsWith(extensionSuffix)) continue;
            eventSpecs.add(EventScoringSpecification.load(aFile, season));
        }
        return eventSpecs;
    }

    public static EventScoringSpecification loadFromDirectory(File aDirectory, String configSettingsFileName, SeasonIdentifier season) throws IOException {
        return EventScoringSpecification.load(new File(aDirectory, configSettingsFileName), season);
    }

    public EventScoringSpecification(File backingFile, SeasonIdentifier season) throws IOException {
        super(backingFile, season);
    }

    protected EventScoringSpecification(SettingsSection settings, SeasonIdentifier season) {
        super(settings, season);
    }

    protected EventScoringSpecification(String name, String shortName, SeasonIdentifier season, Class<? extends RaceClass<?>> ageClassClass, WorldCupPointsType scoringType) {
        super(EventScoringSpecification.createSettings(null), name, shortName, season, ageClassClass, scoringType);
    }

    @Override
    protected String fileNamePrefix() {
        return STANDARD_FILE_NAME_PREFIX;
    }

    public String getBernardCupFormula() {
        return this.getStringValueOrNull(SETTING_BERNARD_CUP_FORMULA);
    }

    public int getBestNFinishesCount(int defaultValue) {
        return this.getSettings().getIntValue(SETTING_BEST_N_FINISHES_COUNT, defaultValue);
    }

    public boolean getGenerateByClassTSV() {
        return this.getSettings().getBooleanValue(SETTING_GENERATE_BY_CLASS_TSV, false);
    }

    public boolean getGenerateDivisionsCupTSV() {
        return this.getSettings().getBooleanValue(SETTING_GENERATE_DIVISIONS_CUP_TSV, false);
    }

    public String getLastSelectedScoringPolicy() {
        return this.getStringValueOrNull(SETTING_LAST_SELECTED_SCORING_POLICY);
    }

    public boolean getAllowGenderStandingsHACK() {
        return this.getAllowGenderStandingsHACK(false);
    }

    public boolean getAllowGenderStandingsHACK(boolean defaultValue) {
        return this.getSettings().getBooleanValue(PROPERTY_ALLOW_GENDER_STANDINGS_HACK, defaultValue);
    }

    public void setBernardCupFormula(String formulaName) {
        this.getSettings().setStringValue(SETTING_BERNARD_CUP_FORMULA, formulaName);
    }

    public void setBestNFinishesCount(int value) {
        this.getSettings().setIntValue(SETTING_BEST_N_FINISHES_COUNT, value);
    }

    public void setLastSelectedScoringPolicy(String policyName) {
        this.getSettings().setStringValue(SETTING_LAST_SELECTED_SCORING_POLICY, policyName);
    }
}

