/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.foundation.models;

import com.glaivestone.javax.devx.Assert;
import com.glaivestone.javax.devx.DebugSupport;
import com.glaivestone.javax.devx.ui.DebugLogWindow;
import com.glaivestone.javax.execution.EvaluableAction;
import com.glaivestone.javax.execution.InstanceMethodAction;
import com.glaivestone.javax.execution.SessionManager;
import com.glaivestone.javax.io.FileSystemServices;
import com.glaivestone.javax.lang.ClassX;
import com.glaivestone.javax.lang.ConstantValue;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ussamasters.aces.racedata.io.CSVSpecDataReader;
import org.ussamasters.aces.racedata.io.RaceDataIOConstants;
import org.ussamasters.aces.racedata.io.RaceDataIOException;
import org.ussamasters.aces.racedata.io.RaceDataIOServices;
import org.ussamasters.aces.racedata.io.RaceResultCSVReader;
import org.ussamasters.aces.racedata.io.RaceResultCSVWriter;
import org.ussamasters.aces.racedata.io.RaceSeriesCSVReader;
import org.ussamasters.aces.racedata.io.RaceSeriesCSVWriter;
import org.ussamasters.aces.racedata.io.RacerListCSVReader;
import org.ussamasters.aces.racedata.io.RacerListCSVWriter;
import org.ussamasters.aces.racedata.models.PolicyID;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceIdentifier;
import org.ussamasters.aces.racedata.models.RaceLocation;
import org.ussamasters.aces.racedata.models.RaceOrganization;
import org.ussamasters.aces.racedata.models.RaceResult;
import org.ussamasters.aces.racedata.models.RaceSeries;
import org.ussamasters.aces.racedata.models.RacerList;
import org.ussamasters.aces.racedata.models.SeasonIdentifier;
import org.ussamasters.aces.racedata.models.WorldCupPointsType;
import org.ussamasters.aces.racedata.reports.RaceDataReportServices;
import org.ussamasters.aces.racedata.reports.ScoringDataDocument;
import org.ussamasters.aces.racedata.scoring.BernardCupHandicapFormula;
import org.ussamasters.aces.racedata.scoring.RaceStandings;
import org.ussamasters.aces.tools.foundation.models.EventScoringRaceSeries;
import org.ussamasters.aces.tools.foundation.models.EventScoringSpecification;
import org.ussamasters.aces.tools.foundation.models.RaceDataConstantHelper;
import org.ussamasters.aces.tools.foundation.models.RacerListManagementPolicy;
import org.ussamasters.aces.tools.foundation.models.RacerListManager;
import org.ussamasters.aces.tools.foundation.models.ScoringRaceSeries;
import org.ussamasters.aces.tools.foundation.models.SeasonScoringRaceSeries;
import org.ussamasters.aces.tools.foundation.models.SeasonScoringSpecification;
import org.ussamasters.aces.tools.foundation.models.SeriesScoringSpecification;
import org.ussamasters.aces.tools.foundation.models.ToolID;
import org.ussamasters.aces.tools.foundation.models.ToolServices;
import org.ussamasters.aces.tools.foundation.models.ToolSessionManager;
import org.ussamasters.aces.tools.foundation.models.ToolSessionRacerList;
import org.ussamasters.aces.tools.foundation.models.WorkingSetScoringData;
import org.ussamasters.aces.tools.foundation.processors.RacerNameChecker;
import org.ussamasters.aces.tools.foundation.processors.ToolConfigurationSettingsProcessor;
import org.ussamasters.aces.tools.foundation.processors.ToolSessionSettingsProcessor;
import org.ussamasters.aces.tools.foundation.processors.UserSessionSettingsProcessor;
import org.ussamasters.aces.tools.foundation.settings.ACESRootSettings;
import org.ussamasters.aces.tools.foundation.settings.SessionRootSettings;
import org.ussamasters.aces.tools.foundation.settings.ToolConfigurationSettings;
import org.ussamasters.aces.tools.foundation.settings.ToolDeveloperSettings;
import org.ussamasters.aces.tools.foundation.settings.ToolSessionSettings;
import org.ussamasters.aces.tools.foundation.settings.UserSettings;
import org.ussamasters.aces.tools.foundation.settings.WorkingSetSettings;
import org.ussamasters.javax.io.ResourceFileAccessor;

public class RaceScoringSessionManager
extends ToolSessionManager {
    public static RaceScoringSessionManager current;
    private static final Class<RaceScoringSessionManager> THIS_CLASS;
    public static final String PRODUCTION_CONFIG_DIR_REF = "org/ussamasters/aces/tools/configuration";
    public static final String PRODUCT_VERSION_INFO_RESOURCE_PATH = "org/ussamasters/aces/tools/configuration/application.properties";
    public static final String PRODUCT_VERSION_RESOURCE_REF = "org/ussamasters/aces/tools/configuration/version.txt";
    public static final String TIMING_DATA_IMPORTS_DIRECTORY_NAME = "TimingDataImports";
    public static final String RACE_IMPORTS_ARCHIVE_DIRECTORY_NAME = "TimingDataImports/RaceResultsImports";
    public static final String RACE_DATA_DIRECTORY_NAME = "ResultsData";
    public static final String SERIES_DATA_DIRECTORY_NAME = "ResultsData";
    public static final String SCORING_DATA_DIRECTORY_NAME = "ScoringData";
    public static boolean USE_SINGLE_REPORTS_DIRECTORY;
    public static boolean USE_COMBINED_SERIES_REPORTS_DIRECTORY;
    public static final String REPORTS_DIRECTORY_NAME = "Reports";
    public static final String RACE_REPORTS_DIRECTORY_NAME;
    public static final String SERIES_REPORTS_DIRECTORY_NAME;
    public static final String SEASON_REPORTS_DIRECTORY_NAME;
    public static final String EVENT_REPORTS_DIRECTORY_NAME;
    public static final String RACE_CALENDAR_DATA_FILE_NAME;
    public static final String SERIES_RACERS_FILE_NAME;
    public static final String SEASON_SCORING_RACES_SHORT_NAME = "StandardScoring";
    public static final String SEASON_SCORING_RACES_DATA_FILE_NAME;
    public static final String SYNONYM_SPECIFICATIONS_FILE_NAME;
    protected static final String DEFAULT_CONSTANT_CLASS_PACKAGE_NAME = "org.ussamasters.aces.racedata.models";
    public static final String SYSTEM_STYLES_DIRECTORY_NAME = "styles";
    public static final FileFilter STYLE_SHEET_FILTER;
    public static final String REPORT_TRANSFORMATION_STYLES_DIRECTORY_NAME = "transforms";
    public static final boolean USE_LAZY_WORKING_SET_DATA_MODEL_RESOLUTION = false;
    protected File currentWorkingSetDirectory;
    protected File timingDataImportsDirectory;
    protected File raceImportsArchiveDirectory;
    protected File raceDataDirectory;
    protected File seriesDataDirectory;
    protected File scoringDataDirectory;
    protected File raceReportsDirectory;
    protected File seriesReportsDirectory;
    protected File seasonReportsDirectory;
    protected File eventReportsDirectory;
    protected RaceSeries raceCalendar;
    protected Map<RaceIdentifier, WorkingSetScoringData> workingSetRaceDataTable;
    protected ToolSessionRacerList racerList;
    protected SeasonScoringRaceSeries seasonScoringRaces;
    protected Map<String, EventScoringRaceSeries> scoringEventsTable;

    public static RaceScoringSessionManager getCurrent() {
        return current;
    }

    private static void initCurrent() {
        current = new RaceScoringSessionManager();
        ToolSessionManager.current = current;
    }

    public static void initiateSession() throws IOException, RaceDataIOException {
        if (current != null) {
            return;
        }
        if (new File("debug").exists()) {
            DebugLogWindow.open();
        }
        DebugSupport.current().dump("\n***BEGIN ToolSessionManager STARTUP***");
        ToolSessionManager.toolInstallationDirectory = SessionManager.DEFAULT_DIRECTORY;
        RaceScoringSessionManager.initCurrent();
        ToolServices.initCurrent();
        DebugSupport.current().dump("... initiating tool session in " + ToolSessionManager.toolInstallationDirectory.getAbsolutePath());
        ToolDeveloperSettings.loadCurrent(ToolSessionManager.toolInstallationDirectory);
        if (ToolDeveloperSettings.current != null) {
            ToolSessionManager.toolInstallationDirectory = ToolDeveloperSettings.current.getDirectory();
        }
        DebugSupport.current().dump("... tool installation directory: " + ToolSessionManager.toolInstallationDirectory.getAbsolutePath());
        DebugSupport.current().dump("...loading session roots configuration settings");
        Assert.expected(SessionRootSettings.current == null, "Unexpected SessionRootSettings.current value encountered during ToolSessionManager sstartup (reloaded)");
        ACESRootSettings.loadCurrent(ToolSessionManager.toolInstallationDirectory, ToolSessionManager.getSessionRootSettingsFileName());
        DebugSupport.current().dump("...loading session configuration settings");
        Assert.expected(ToolSessionSettings.current == null, "Unexpected ToolSessionSettings.current value encountered during ToolSessionManager startup (reloaded)");
        ToolSessionSettings.loadCurrent(ToolSessionManager.toolInstallationDirectory, ToolSessionManager.getSessionConfigSettingsFileName());
        if (!SessionRootSettings.getCurrent().hasUserConfigurationFiles()) {
            ToolSessionSettings.getCurrent().bootstrapConfigurationSettingsDirectory(SessionRootSettings.getCurrent().getUserConfigurationDirectory());
        }
        DebugSupport.current().dump("...loading installation configuration specifications..");
        Assert.expected(ToolConfigurationSettings.current == null, "Unexpected ToolInstallationSettings.current value encountered during ToolSessionManager startup (reloaded)");
        ToolConfigurationSettings.loadCurrent(SessionRootSettings.current.getSystemDirectory(), ToolSessionManager.getSessionInstallationSettingsFileName());
        DebugSupport.current().dump("...loading user configuration specifications..");
        Assert.expected(UserSettings.current == null, "Unexpected UserSettings.current value encountered during ToolSessionManager startup (reloaded)");
        UserSettings.loadCurrent();
        DebugSupport.current().dump("...processing installation configuration specifications...");
        DebugSupport.current().dump("... tool installation settings: " + ToolConfigurationSettings.getCurrent().getFile().getAbsolutePath());
        ToolConfigurationSettingsProcessor.processConfigurationSpecifications(current, ToolConfigurationSettings.getCurrent(), ToolSessionManager.getSessionSplashScreenPathName());
        DebugSupport.current().dump("...processing tool session settings...");
        DebugSupport.current().dump("... tool session settings: " + ToolSessionSettings.current.getFile().getAbsolutePath());
        ToolSessionSettingsProcessor.processConfigurationSpecifications(current, ToolSessionSettings.current);
        RaceScoringSessionManager.loadSynonymSpecificationsIn(SessionRootSettings.current.getSystemDirectory());
        RaceScoringSessionManager.loadRacerNameVariations(SessionRootSettings.current.getSystemDirectory());
        DebugSupport.current().dump("...processing user configuration specifications...");
        DebugSupport.current().dump("... user settings: " + UserSettings.current.getFile().getAbsolutePath());
        UserSessionSettingsProcessor.processConfigurationSpecifications(current, UserSettings.current);
        RaceScoringSessionManager.loadRaceLocationDefinitionsIn(SessionRootSettings.current.getUserConfigurationDirectory());
        RaceScoringSessionManager.loadBernardCupFormulaSpecificationsIn(SessionRootSettings.current.getUserConfigurationDirectory());
        RaceScoringSessionManager.loadSynonymSpecificationsIn(SessionRootSettings.current.getUserConfigurationDirectory());
        RaceScoringSessionManager.loadRacerNameVariations(SessionRootSettings.current.getUserConfigurationDirectory());
        current.installProductConfigurationSettings();
        DebugSupport.current().dump("...installing working set...");
        File currentWorkingSetDirectory = UserSettings.current.getCurrentWorkingDirectory();
        DebugSupport.current().dump("... working sets directory: " + SessionRootSettings.current.getUserDataDirectory().getAbsolutePath());
        DebugSupport.current().dump("...current working set: " + currentWorkingSetDirectory.getName());
        if (!WorkingSetSettings.isWorkingSetDirectory(currentWorkingSetDirectory)) {
            DebugSupport.current().dump("***Initializing empty working set***");
            current.initializeDefaultWorkingSetDirectory(currentWorkingSetDirectory);
        }
        current.installWorkingSet(currentWorkingSetDirectory);
        DebugSupport.current().dump("...racer list management policy: " + WorkingSetSettings.getCurrent().getRacerListManagementPolicy());
        DebugSupport.current().dump("...    " + current.getRacerList().getManagementPolicy());
        DebugSupport.current().dump("...racer list merge policy: " + WorkingSetSettings.getCurrent().getRacerListMergePolicy());
        DebugSupport.current().dump("ToolSessionManager startup completed");
        DebugSupport.current().dump("");
        SessionManager.current.fireSessionStarted();
    }

    public static void launchTool(String toolName) {
        ToolID toolID = ToolID.getConstant(toolName);
        if (toolID == null) {
            System.out.println("WARNING: Tool session launch error: no tool registered as '" + toolName + ";");
            return;
        }
        EvaluableAction openAction = RaceScoringSessionManager.current.getToolInfo((ToolID)toolID).openAction;
        if (openAction == null) {
            System.out.println("WARNING: Tool session launch error: no tool open action implemented for '" + toolName + ";");
        }
        openAction.evaluate();
    }

    public static void loadBernardCupFormulaSpecifications(File specFile) {
        List<String[]> locationSpecs = RaceScoringSessionManager.loadSpecifications(specFile);
        if (locationSpecs == null) {
            return;
        }
        for (String[] spec : locationSpecs) {
            BernardCupHandicapFormula.defineConstant(spec[0], spec[1], Integer.parseInt(spec[2]), Float.parseFloat(spec[3]));
        }
    }

    public static void loadBernardCupFormulaSpecificationsIn(File aDirectory) {
        String specFileName = RaceDataIOConstants.FILE_TYPE_CFG.composeFileName("BernardCupFormulas");
        File specFile = new File(aDirectory, specFileName);
        RaceScoringSessionManager.loadBernardCupFormulaSpecifications(specFile);
    }

    public static void loadRaceLocationDefinitions(File specFile) {
        List<String[]> locationSpecs = RaceScoringSessionManager.loadSpecifications(specFile);
        if (locationSpecs == null) {
            return;
        }
        for (String[] spec : locationSpecs) {
            RaceLocation.defineConstant(spec[0], spec[1], RaceOrganization.getConstant(spec[2]));
        }
    }

    public static void loadRaceLocationDefinitionsIn(File aDirectory) {
        String specFileName = RaceDataIOConstants.FILE_TYPE_CFG.composeFileName("RaceLocations");
        File specFile = new File(aDirectory, specFileName);
        RaceScoringSessionManager.loadRaceLocationDefinitions(specFile);
    }

    protected static void loadRacerNameVariations(File aDirectory) {
        RacerNameChecker.loadNameVariationSpecifications(aDirectory);
    }

    public static List<String[]> loadSpecifications(File specFile) {
        if (!specFile.exists()) {
            return null;
        }
        try {
            return CSVSpecDataReader.loadValues(specFile);
        }
        catch (IOException ex) {
            return null;
        }
    }

    public static void loadSynonymSpecifications(Class<? extends ConstantValue<?>> constantClass, File specFile) {
        List<String[]> synonymSpecs = RaceScoringSessionManager.loadSpecifications(specFile);
        if (synonymSpecs == null) {
            return;
        }
        for (String[] spec : synonymSpecs) {
            RaceDataConstantHelper.registerSynonym(spec[0], spec[1], constantClass);
        }
    }

    public static void loadSynonymSpecifications(String constantClassName, File specFile) {
        Class<?> constantClass = ClassX.classForNameOrNull(constantClassName);
        if (constantClass == null) {
            constantClass = ClassX.classForNameOrNull("org.ussamasters.aces.racedata.models." + constantClassName);
        }
        if (constantClass == null) {
            DebugSupport.current().dump("***ERROR: unable to load synonym specifications for " + constantClassName + " (class not found)");
            return;
        }
        if (specFile == null) {
            DebugSupport.current().dump("***ERROR: unable to load synonym specifications for " + constantClassName + " (spec file null)");
            return;
        }
        RaceScoringSessionManager.loadSynonymSpecifications(constantClass, specFile);
    }

    public static void loadSynonymSpecificationsIn(File aDirectory) {
        File specListFile = new File(aDirectory, SYNONYM_SPECIFICATIONS_FILE_NAME);
        List<String[]> specList = RaceScoringSessionManager.loadSpecifications(specListFile);
        if (specList == null) {
            return;
        }
        for (String[] specSpec : specList) {
            String constantClassName = specSpec[0];
            String synonymFileName = specSpec[1];
            File specFile = new File(aDirectory, synonymFileName);
            RaceScoringSessionManager.loadSynonymSpecifications(constantClassName, specFile);
        }
    }

    public static List<String> processCommandLineArgs(String[] args) {
        return ToolSessionManager.processCommandLineArgs(args);
    }

    protected RaceScoringSessionManager() {
    }

    public void addEventScoringRace(String name, RaceIdentifier raceID) throws RaceDataIOException {
        EventScoringRaceSeries eventRaces = this.getEventScoringRaces(name);
        RaceResult aRaceResult = this.getRaceResult(raceID);
        eventRaces.add(aRaceResult);
        try {
            eventRaces.getSpecification().saveSettings();
        }
        catch (IOException ex) {
            throw new RaceDataIOException((Exception)ex, "Unable to save event scoring specification: " + ex.getMessage());
        }
    }

    public void addRace(RaceIdentifier raceID) throws RaceDataIOException {
        this.getRaceCalendar().add(raceID);
        this.saveRaceCalendar();
        WorkingSetScoringData wssData = new WorkingSetScoringData(raceID);
        this.workingSetRaceDataTable.put(raceID, wssData);
    }

    public void addSeasonScoringRace(RaceIdentifier raceID) throws RaceDataIOException {
        RaceResult aRaceResult = this.getRaceResult(raceID);
        this.getSeasonScoringRaces().add(aRaceResult);
        this.saveSeasonScoringRaces();
    }

    public boolean allowsSeasonScoring() {
        return WorkingSetSettings.getCurrent().isSeasonScoringSeries();
    }

    protected void clearWorkingSetSubdirectoryReferences() {
        this.timingDataImportsDirectory = null;
        this.raceImportsArchiveDirectory = null;
        this.raceDataDirectory = null;
        this.seriesDataDirectory = null;
        this.scoringDataDirectory = null;
        this.raceReportsDirectory = null;
        this.seriesReportsDirectory = null;
        this.seasonReportsDirectory = null;
        this.eventReportsDirectory = null;
    }

    protected void clearWorkingSetValues() {
        this.raceCalendar = null;
        this.workingSetRaceDataTable = null;
        this.racerList = null;
        this.seasonScoringRaces = null;
        this.scoringEventsTable = null;
        this.removeAllWorkingSetResources();
    }

    protected RaceSeries constructEmptyRaceCalender() {
        WorkingSetSettings wsSettings = WorkingSetSettings.getCurrent();
        return RaceSeries.createEmptySeries(wsSettings.getDescription(), wsSettings.getSeason(), wsSettings.getRaceClassClass(), wsSettings.getWorldCupPointsType());
    }

    protected RacerList constructEmptyRacerList() {
        WorkingSetSettings wsSettings = WorkingSetSettings.getCurrent();
        return new RacerList(wsSettings.getSeason(), wsSettings.getOrganizer(), wsSettings.getRaceClassClass());
    }

    protected EventScoringRaceSeries constructEventScoringRaces(EventScoringSpecification eventSpec) throws RaceDataIOException {
        EventScoringRaceSeries eventRaces = new EventScoringRaceSeries(eventSpec, this.getSeason());
        this.resolveScoringSeriesRaces(eventRaces);
        return eventRaces;
    }

    protected SeasonScoringRaceSeries constructSeasonScoringRaces(SeasonScoringSpecification seasonSpecification) throws RaceDataIOException {
        SeasonScoringRaceSeries seasonRaces = new SeasonScoringRaceSeries(seasonSpecification);
        this.resolveScoringSeriesRaces(seasonRaces);
        return seasonRaces;
    }

    protected File constructWorkingSetSubdirectory(String subdirectoryName, boolean createIfNotThere) {
        File aDirectory = new File(this.getWorkingSetDirectory(), subdirectoryName);
        if (createIfNotThere && !aDirectory.exists()) {
            try {
                FileSystemServices.getCurrent().realizeDirectory(aDirectory);
            }
            catch (IOException ex) {
                System.err.println("***FATAL ERROR: Missing or invalid user data directory:\n" + subdirectoryName);
                ex.printStackTrace();
                SessionManager.current.shutdown();
            }
        }
        return aDirectory;
    }

    public void createNewWorkingSet(WorkingSetSettings wsSettings, File wsDirectory) throws IOException {
        FileSystemServices fileServices = FileSystemServices.getCurrent();
        fileServices.realizeDirectory(wsDirectory);
        wsSettings.saveSettings(new File(wsDirectory, WorkingSetSettings.FILE_NAME));
        String defaultTimingFilesDirName = "TimingSystemFiles";
        File timingFilesDir = new File(wsDirectory, defaultTimingFilesDirName);
        fileServices.realizeDirectory(timingFilesDir);
        File defaultsDir = new File(ToolConfigurationSettings.getCurrent().getDefaultsSubdirectory(), defaultTimingFilesDirName);
        for (File aFile : defaultsDir.listFiles()) {
            fileServices.copyFile(aFile, timingFilesDir);
        }
    }

    public void deleteRaceResult(RaceIdentifier raceID) {
        WorkingSetScoringData wssData = this.getWorkingSetScoringData(raceID);
        wssData.deleteRaceData();
    }

    public void deleteScoringEvent(String eventName) {
        EventScoringRaceSeries eventRaces = this.getEventScoringRaces(eventName);
        this.scoringEventsTable.remove(eventName);
        File backingFile = eventRaces.getEventSpecification().getFile();
        backingFile.delete();
    }

    public List<WorkingSetSettings> getAvailableWorkingSets() {
        List<File> wsDirectories = this.getWorkingSetDirectories(this.getUserDataDirectory());
        int nWorkingSets = wsDirectories.size();
        ArrayList<WorkingSetSettings> wsSettingsList = new ArrayList<WorkingSetSettings>(wsDirectories.size());
        for (int i = 0; i < nWorkingSets; ++i) {
            File wsDirectory = wsDirectories.get(i);
            try {
                WorkingSetSettings settings = WorkingSetSettings.loadFromDirectory(wsDirectory);
                wsSettingsList.add(settings);
                continue;
            }
            catch (IOException ex) {
                DebugSupport.current().dump("ERROR: unable to load working set settings in " + wsDirectory.getAbsolutePath());
                DebugSupport.current().dumpStack(ex);
            }
        }
        return wsSettingsList;
    }

    public WorkingSetSettings getDefaultWorkingSetSettings() throws IOException {
        WorkingSetSettings wsSettings = WorkingSetSettings.loadFromDirectory(ToolConfigurationSettings.getCurrent().getDefaultsSubdirectory());
        wsSettings.prepareDefaultSettings();
        wsSettings.setFile(null);
        return wsSettings;
    }

    public File getEventReportsDirectory() {
        if (USE_COMBINED_SERIES_REPORTS_DIRECTORY) {
            return this.getSeriesReportsDirectory();
        }
        if (this.eventReportsDirectory == null) {
            this.eventReportsDirectory = this.constructWorkingSetSubdirectory(EVENT_REPORTS_DIRECTORY_NAME, false);
        }
        return this.eventReportsDirectory;
    }

    public File getEventScoringDataDirectory() {
        return this.getSeriesDataDirectory();
    }

    public EventScoringRaceSeries getEventScoringRaces(String name) {
        return this.scoringEventsTable.get(name);
    }

    public RaceSeries getRaceCalendar() {
        return this.raceCalendar;
    }

    public RaceResult getRaceResult(RaceIdentifier raceID) {
        WorkingSetScoringData wssData = this.getWorkingSetScoringData(raceID);
        if (wssData.raceResultFile == null) {
            return null;
        }
        return wssData.raceResult;
    }

    public RacerList getRaceResultCompetitorInfo(RaceIdentifier raceID) throws RaceDataIOException {
        return this.getRaceResultCompetitors(raceID, null);
    }

    protected RacerList getRaceResultCompetitors(RaceIdentifier raceID, RacerList valueIfReconciled) throws RaceDataIOException {
        WorkingSetScoringData wssData = this.getWorkingSetScoringData(raceID);
        if (wssData.racerInfoFile == null) {
            return valueIfReconciled;
        }
        if (wssData.racerInfo == null && wssData.racerInfoFile.length() > 0L) {
            wssData.racerInfo = RacerListCSVReader.loadFromFile(wssData.racerInfoFile);
        }
        return wssData.racerInfo;
    }

    public RacerList getRaceResultCompetitors(RaceIdentifier raceID) throws RaceDataIOException {
        return this.getRaceResultCompetitors(raceID, this.getRacerList());
    }

    public ToolSessionRacerList getRacerList() {
        return this.racerList;
    }

    public ToolSessionRacerList getRacerListForEdit() {
        RacerListManagementPolicy managementPolicy = this.getRacerList().getManagementPolicy().copy();
        try {
            return this.loadRacerList(managementPolicy);
        }
        catch (RaceDataIOException ex) {
            return new ToolSessionRacerList(this.constructEmptyRacerList(), managementPolicy);
        }
    }

    protected File getRacerListBackingFile() {
        return new File(this.getWorkingSetDirectory(), SERIES_RACERS_FILE_NAME);
    }

    public File getRaceDataDirectory() {
        return this.raceDataDirectory;
    }

    public File getRaceImportsArchiveDirectory() {
        if (this.raceImportsArchiveDirectory == null) {
            this.raceImportsArchiveDirectory = this.constructWorkingSetSubdirectory(RACE_IMPORTS_ARCHIVE_DIRECTORY_NAME, false);
        }
        return this.raceImportsArchiveDirectory;
    }

    public File getRaceReportsDirectory() {
        if (this.raceReportsDirectory == null) {
            this.raceReportsDirectory = this.constructWorkingSetSubdirectory(RACE_REPORTS_DIRECTORY_NAME, false);
        }
        return this.raceReportsDirectory;
    }

    public File getScoringDataDirectory() {
        if (this.scoringDataDirectory == null) {
            this.scoringDataDirectory = this.constructWorkingSetSubdirectory(SCORING_DATA_DIRECTORY_NAME, false);
        }
        return this.scoringDataDirectory;
    }

    public List<String> getScoringEventNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.addAll(this.scoringEventsTable.keySet());
        Collections.sort(names);
        return names;
    }

    public File getSeriesDataDirectory() {
        return this.seriesDataDirectory;
    }

    public File getSeriesReportsDirectory() {
        if (this.seriesReportsDirectory == null) {
            this.seriesReportsDirectory = this.constructWorkingSetSubdirectory(SERIES_REPORTS_DIRECTORY_NAME, false);
        }
        return this.seriesReportsDirectory;
    }

    public SeasonIdentifier getSeason() {
        return this.getRaceCalendar().getSeason();
    }

    public File getSeasonDataDirectory() {
        return this.getSeriesDataDirectory();
    }

    public SeasonScoringRaceSeries getSeasonScoringRaces() {
        return this.seasonScoringRaces;
    }

    public File getSeasonReportsDirectory() {
        if (USE_COMBINED_SERIES_REPORTS_DIRECTORY) {
            return this.getSeriesReportsDirectory();
        }
        if (this.seasonReportsDirectory == null) {
            this.seasonReportsDirectory = this.constructWorkingSetSubdirectory(SEASON_REPORTS_DIRECTORY_NAME, false);
        }
        return this.seasonReportsDirectory;
    }

    public File getTimingDataImportsDirectory() {
        if (this.timingDataImportsDirectory == null) {
            this.timingDataImportsDirectory = this.constructWorkingSetSubdirectory(TIMING_DATA_IMPORTS_DIRECTORY_NAME, false);
        }
        return this.timingDataImportsDirectory;
    }

    public File getTimingSystemFilesSourceDirectory() {
        return WorkingSetSettings.getCurrent().getTimingSystemFilesSourceDirectory();
    }

    public String getToolOption(ToolID toolID, String option) {
        return WorkingSetSettings.getCurrent().getToolOption(toolID, option);
    }

    public String getToolOption(ToolID toolID, String option, String defaultValue) {
        return WorkingSetSettings.getCurrent().getToolOption(toolID, option, defaultValue);
    }

    protected File getRaceCalendarBackingFile() {
        return new File(this.getWorkingSetDirectory(), RACE_CALENDAR_DATA_FILE_NAME);
    }

    public PolicyID getRacerListMergePolicy() {
        return WorkingSetSettings.getCurrent().getRacerListMergePolicy();
    }

    protected File getSeasonScoringRacesBackingFile() {
        return new File(this.getSeriesDataDirectory(), SEASON_SCORING_RACES_DATA_FILE_NAME);
    }

    public File getSystemFile(String fileName) {
        File aFile = new File(this.getSystemDirectory(), fileName);
        return aFile.exists() ? aFile : null;
    }

    public File getUserConfigFile(String fileName) {
        File aFile = new File(this.getUserConfigurationDirectory(), fileName);
        return aFile.exists() ? aFile : null;
    }

    public File getWorkingSetConfigurationDirectory() {
        return new File(this.getWorkingSetDirectory(), UserSettings.getCurrent().getDirectory().getName());
    }

    public File getWorkingSetDirectory() {
        return this.currentWorkingSetDirectory;
    }

    public List<File> getWorkingSetDirectories(File aDirectory) {
        File[] childElements = aDirectory.listFiles();
        ArrayList<File> workingSetDirectories = new ArrayList<File>();
        for (int i = 0; i < childElements.length; ++i) {
            File fsElement = childElements[i];
            if (!WorkingSetSettings.isWorkingSetDirectory(fsElement)) continue;
            workingSetDirectories.add(fsElement);
        }
        return workingSetDirectories;
    }

    protected WorkingSetScoringData getWorkingSetScoringData(RaceIdentifier raceID) {
        return this.workingSetRaceDataTable.get(raceID);
    }

    public boolean hasReferences(RaceIdentifier raceID) {
        if (this.getSeasonScoringRaces() != null && this.getSeasonScoringRaces().contains(raceID)) {
            return true;
        }
        for (String eventName : this.getScoringEventNames()) {
            EventScoringRaceSeries eventRaces = this.getEventScoringRaces(eventName);
            if (!eventRaces.contains(raceID)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.currentWorkingSetDirectory = null;
        RaceDataReportServices.setValidateReportDirectoryAction(InstanceMethodAction.create((Object)this, "validateReportsDirectory", RaceDataReportServices.VALIDATE_DIRECTORY_ACTION_PARM_TYPES));
    }

    protected void initializeDefaultWorkingSetDirectory(File aDirectory) throws IOException {
        if (!aDirectory.isDirectory() || aDirectory.list().length != 0) {
            throw new IOException("Creating new working set in non-empty directory not allowed: " + aDirectory.getAbsolutePath());
        }
        WorkingSetSettings wsSettings = this.getDefaultWorkingSetSettings();
        this.createNewWorkingSet(wsSettings, aDirectory);
    }

    protected void installProductConfigurationSettings() {
        String productName = ToolConfigurationSettings.getCurrent().getProductName();
        String productBaseVersion = ToolConfigurationSettings.getCurrent().getProductVersion();
        String productSupportHref = ToolConfigurationSettings.getCurrent().getProductSupportHref();
        String productCurrentVersion = this.loadProductCurrentVersion(productBaseVersion);
        ScoringDataDocument.softwareName = productName;
        ScoringDataDocument.softwareVersion = productCurrentVersion;
        ScoringDataDocument.supportHref = productSupportHref;
    }

    protected void installWorkingSet(File newWorkingSetDirectory) throws IOException, RaceDataIOException {
        File previousWorkingSetDirectory = this.currentWorkingSetDirectory;
        this.fireLoadingWorkingSet(previousWorkingSetDirectory, newWorkingSetDirectory);
        this.currentWorkingSetDirectory = newWorkingSetDirectory;
        this.clearWorkingSetSubdirectoryReferences();
        this.clearWorkingSetValues();
        WorkingSetSettings.loadCurrent(this.currentWorkingSetDirectory);
        this.loadWorkingSetScoringData();
        this.resolveRaceDataModels();
        this.resolveSeriesDataModels();
        this.resolveScoringEventDataModels();
        if (this.allowsSeasonScoring()) {
            this.resolveSeasonDataModels();
        }
        RaceDataReportServices.setReportOptions(WorkingSetSettings.getCurrent().getReportSettings());
        RaceDataReportServices.getReportOptions().setScoringDataDirectory(this.getScoringDataDirectory());
        RaceDataReportServices.getReportOptions().setTransformationStylesheetSearchPath(new File[]{new File(this.getWorkingSetConfigurationDirectory(), REPORT_TRANSFORMATION_STYLES_DIRECTORY_NAME), new File(this.getSystemDirectory(), REPORT_TRANSFORMATION_STYLES_DIRECTORY_NAME)});
        this.fireWorkingSetLoaded(previousWorkingSetDirectory, newWorkingSetDirectory);
    }

    public boolean isResultReconciled(RaceIdentifier raceID) {
        WorkingSetScoringData wssData = this.getWorkingSetScoringData(raceID);
        return wssData.isReconciled();
    }

    public EventScoringRaceSeries loadEventScoringSpecification(File eventSpecFile) throws RaceDataIOException {
        EventScoringSpecification eventSpec;
        try {
            eventSpec = EventScoringSpecification.load(eventSpecFile, this.getSeason());
        }
        catch (IOException ex) {
            throw new RaceDataIOException(ex);
        }
        String eventName = eventSpec.getName();
        EventScoringRaceSeries eventRaces = this.getEventScoringRaces(eventName);
        if (eventRaces != null) {
            throw new IllegalArgumentException("Scoring event '" + eventName + "' is already loaded");
        }
        eventRaces = this.constructEventScoringRaces(eventSpec);
        this.scoringEventsTable.put(eventName, eventRaces);
        return eventRaces;
    }

    protected String loadProductCurrentVersion(String baseVersion) {
        String currentVersion = null;
        currentVersion = ResourceFileAccessor.readFileContents(PRODUCT_VERSION_RESOURCE_REF);
        if (currentVersion != null) {
            return currentVersion.trim();
        }
        List<String> lines = ResourceFileAccessor.readFileLines(PRODUCT_VERSION_INFO_RESOURCE_PATH);
        if (lines != null) {
            String versionEntryTag = "Application-Release:";
            for (String line : lines) {
                if (!line.startsWith(versionEntryTag)) continue;
                currentVersion = line.substring(versionEntryTag.length()).trim();
                return currentVersion;
            }
        }
        return baseVersion;
    }

    protected Map<String, EventScoringRaceSeries> loadScoringEventSpecifications() throws RaceDataIOException {
        List<EventScoringSpecification> eventSpecs;
        try {
            eventSpecs = EventScoringSpecification.loadAllFromDirectory(this.getEventScoringDataDirectory(), this.getSeason());
        }
        catch (IOException ex) {
            throw new RaceDataIOException(ex);
        }
        HashMap<String, EventScoringRaceSeries> eventsTable = new HashMap<String, EventScoringRaceSeries>();
        for (EventScoringSpecification eventSpec : eventSpecs) {
            String eventName = eventSpec.getName();
            EventScoringRaceSeries eventRaces = this.constructEventScoringRaces(eventSpec);
            eventsTable.put(eventName, eventRaces);
        }
        return eventsTable;
    }

    protected ToolSessionRacerList loadRacerList() throws RaceDataIOException {
        return this.loadRacerList(WorkingSetSettings.getCurrent().constructRacerListManagementPolicy());
    }

    protected ToolSessionRacerList loadRacerList(RacerListManagementPolicy managementPolicy) throws RaceDataIOException {
        RacerList aRacerList;
        File backingFile = this.getRacerListBackingFile();
        if (backingFile.exists()) {
            aRacerList = RacerListCSVReader.loadFromFile(backingFile);
        } else {
            aRacerList = this.constructEmptyRacerList();
            new RacerListCSVWriter(aRacerList).writeFile(backingFile);
        }
        return new ToolSessionRacerList(aRacerList, managementPolicy);
    }

    protected RaceSeries loadRaceCalendar() throws RaceDataIOException {
        File backingFile = this.getRaceCalendarBackingFile();
        if (backingFile.exists()) {
            return RaceSeriesCSVReader.loadCalendarFromFile(backingFile);
        }
        RaceSeries emptyRaceSeries = this.constructEmptyRaceCalender();
        this.saveRaceCalendar(emptyRaceSeries, backingFile);
        return emptyRaceSeries;
    }

    protected SeasonScoringRaceSeries loadSeasonScoringRaces() throws RaceDataIOException {
        File backingFile = this.getSeasonScoringRacesBackingFile();
        if (backingFile.exists()) {
            SeasonScoringSpecification seasonSpecification;
            try {
                seasonSpecification = SeasonScoringSpecification.load(backingFile, this.getSeason());
            }
            catch (IOException ex) {
                throw new RaceDataIOException((Exception)ex, "Unable to load season scoring specification " + backingFile.getAbsolutePath());
            }
            return this.constructSeasonScoringRaces(seasonSpecification);
        }
        SeasonScoringRaceSeries emptyRaceSeries = SeasonScoringRaceSeries.createEmptySeries("Season Standings - StandardScoring", SEASON_SCORING_RACES_SHORT_NAME, this.raceCalendar.getSeason(), WorkingSetSettings.getCurrent().getRaceClassClass(), WorkingSetSettings.getCurrent().getWorldCupPointsType());
        emptyRaceSeries.getSpecification().setDescription("Season standings - " + this.raceCalendar.getName());
        try {
            FileSystemServices.getCurrent().realizeDirectory(backingFile.getParentFile());
        }
        catch (IOException ex) {
            throw new RaceDataIOException((Exception)ex, "Unable to create season data directory " + backingFile.getParentFile().getAbsolutePath());
        }
        emptyRaceSeries.getSpecification().setFile(backingFile);
        this.saveScoringSpecification(emptyRaceSeries);
        return emptyRaceSeries;
    }

    protected void loadWorkingSetScoringData() throws RaceDataIOException {
        this.raceCalendar = this.loadRaceCalendar();
        this.racerList = this.loadRacerList();
        this.raceDataDirectory = this.constructWorkingSetSubdirectory("ResultsData", false);
        boolean hasRaceData = this.raceDataDirectory.exists();
        this.seriesDataDirectory = this.constructWorkingSetSubdirectory("ResultsData", false);
        this.workingSetRaceDataTable = new HashMap<RaceIdentifier, WorkingSetScoringData>();
        for (RaceIdentifier raceID : this.raceCalendar.getRaces()) {
            File aFile;
            WorkingSetScoringData wssData = new WorkingSetScoringData(raceID);
            String raceDataFileName = wssData.raceResultsFileName();
            if (hasRaceData && (aFile = new File(this.raceDataDirectory, raceDataFileName)).exists()) {
                wssData.raceResultFile = aFile;
                aFile = new File(this.raceDataDirectory, wssData.racerInfoFileName());
                if (aFile.exists()) {
                    wssData.racerInfoFile = aFile;
                    wssData.racerInfo = null;
                }
            }
            this.workingSetRaceDataTable.put(raceID, wssData);
        }
    }

    public void markResultReconciled(RaceIdentifier raceID) {
        WorkingSetScoringData wssData = this.getWorkingSetScoringData(raceID);
        wssData.setReconciled(true);
    }

    public void openWorkingSet(File newWorkingSetDirectory) throws IOException, RaceDataIOException {
        this.installWorkingSet(newWorkingSetDirectory);
        UserSettings.getCurrent().setCurrentWorkingDirectory(newWorkingSetDirectory);
        UserSettings.getCurrent().saveSettings();
    }

    protected boolean prepareRaceResultForSeriesScoring(RaceResult seriesRaceResult) {
        int numDNS = seriesRaceResult.removeNonStarters();
        return numDNS > 0;
    }

    protected void propagateRaceResultUpdatesToSeries(RaceResult aRaceResult) {
        int raceIndex;
        RaceIdentifier raceID = aRaceResult.getRaceId();
        SeasonScoringRaceSeries seasonRaces = this.getSeasonScoringRaces();
        if (seasonRaces != null && (raceIndex = seasonRaces.indexOf(raceID)) != -1) {
            seasonRaces.set(raceIndex, aRaceResult);
        }
        for (String eventName : this.getScoringEventNames()) {
            EventScoringRaceSeries eventRaces = this.getEventScoringRaces(eventName);
            raceIndex = eventRaces.indexOf(raceID);
            if (raceIndex == -1) continue;
            eventRaces.set(raceIndex, aRaceResult);
        }
    }

    public RaceResult recomputeStandings(RaceResult aRaceResult) {
        return RaceStandings.computeCanonicalStandings(aRaceResult);
    }

    public void removeEventScoringRace(String name, RaceIdentifier raceID) throws RaceDataIOException {
        EventScoringRaceSeries eventRaces = this.getEventScoringRaces(name);
        eventRaces.remove(raceID);
        try {
            eventRaces.getSpecification().saveSettings();
        }
        catch (IOException ex) {
            throw new RaceDataIOException((Exception)ex, "Unable to save event scoring specification: " + ex.getMessage());
        }
    }

    public void removeRace(RaceIdentifier raceID) throws RaceDataIOException {
        this.getRaceCalendar().remove(raceID);
        this.saveRaceCalendar();
        this.workingSetRaceDataTable.remove(raceID);
    }

    public void removeSeasonScoringRace(RaceIdentifier raceID) throws RaceDataIOException {
        this.getSeasonScoringRaces().remove(raceID);
        this.saveSeasonScoringRaces();
    }

    public void resolveRaceDataModels() throws RaceDataIOException {
        for (WorkingSetScoringData wssData : this.workingSetRaceDataTable.values()) {
            if (wssData.raceResultFile == null || wssData.raceResult != null) continue;
            WorkingSetSettings wsSettings = WorkingSetSettings.getCurrent();
            wssData.raceResult = RaceResultCSVReader.loadFromFile(wssData.raceResultFile, wsSettings.getWorldCupPointsType());
        }
    }

    public void resolveScoringEventDataModels() throws RaceDataIOException {
        if (this.scoringEventsTable == null) {
            boolean hasSeriesData = this.seriesDataDirectory.exists();
            this.scoringEventsTable = hasSeriesData ? this.loadScoringEventSpecifications() : new HashMap<String, EventScoringRaceSeries>();
        }
    }

    protected void resolveScoringSeriesRaces(ScoringRaceSeries scoringRaces) throws RaceDataIOException {
        List<String> raceSpecs = scoringRaces.getRaceSpecifications();
        int nRaces = raceSpecs.size();
        for (int i = 0; i < nRaces; ++i) {
            RaceIdentifier raceID = RaceDataIOServices.csvStringToRace(raceSpecs.get(i));
            RaceResult raceResults = this.getRaceResult(raceID);
            if (raceResults == null) continue;
            scoringRaces.set(i, raceResults);
        }
    }

    public void resolveSeasonDataModels() throws RaceDataIOException {
        if (this.seasonScoringRaces == null) {
            this.seasonScoringRaces = this.loadSeasonScoringRaces();
        }
    }

    public void resolveSeriesDataModels() throws RaceDataIOException {
    }

    protected void saveScoringSpecification(ScoringRaceSeries scoringRaces) throws RaceDataIOException {
        try {
            scoringRaces.getSpecification().saveSettings();
        }
        catch (IOException ex) {
            throw new RaceDataIOException((Exception)ex, "Unable to save scoring specification: " + ex.getMessage());
        }
    }

    public File saveRaceResult(RaceResult aRaceResult) throws RaceDataIOException {
        return this.saveRaceResultData(aRaceResult, null, false);
    }

    public File saveRaceResultImport(RaceResult aRaceResult, RacerList racerInfo) throws RaceDataIOException {
        this.prepareRaceResultForSeriesScoring(aRaceResult);
        return this.saveRaceResultData(aRaceResult, racerInfo, true);
    }

    protected File saveRaceResultData(RaceResult aRaceResult, RacerList racerInfo, boolean importingResult) throws RaceDataIOException {
        boolean newResult;
        WorkingSetScoringData wssData = this.getWorkingSetScoringData(aRaceResult.getRaceId());
        File resultDataFile = wssData.raceResultFile;
        if (resultDataFile != null) {
            newResult = false;
        } else {
            newResult = true;
            resultDataFile = new File(this.getRaceDataDirectory(), wssData.raceResultsFileName());
            try {
                FileSystemServices.getCurrent().realizeDirectory(resultDataFile.getParentFile());
            }
            catch (IOException ex) {
                throw new RaceDataIOException((Exception)ex, "Unable to create race results storage directory: " + ex.getMessage());
            }
        }
        new RaceResultCSVWriter(aRaceResult).writeFile(resultDataFile);
        wssData.raceResultFile = resultDataFile;
        wssData.raceResult = aRaceResult;
        if (!newResult) {
            this.propagateRaceResultUpdatesToSeries(aRaceResult);
        }
        if (importingResult) {
            File racerInfoFile = new File(resultDataFile.getParentFile(), wssData.racerInfoFileName());
            File importArchiveDataFile = new File(this.getRaceImportsArchiveDirectory(), wssData.raceResultsFileName());
            File importArchiveRacerInfoFile = new File(importArchiveDataFile.getParentFile(), wssData.racerInfoFileName());
            try {
                racerInfoFile.createNewFile();
            }
            catch (IOException ex) {
                throw new RaceDataIOException((Exception)ex, "Unable to create reconciliation marke file in timing imports directory: " + ex.getMessage());
            }
            try {
                FileSystemServices.getCurrent().realizeDirectory(importArchiveDataFile.getParentFile());
                FileSystemServices.getCurrent().copyFile(resultDataFile, importArchiveDataFile);
            }
            catch (IOException ex) {
                throw new RaceDataIOException((Exception)ex, "Unable to store race results in import archive directory: " + ex.getMessage());
            }
            if (racerInfo != null) {
                new RacerListCSVWriter(racerInfo).writeFile(racerInfoFile);
                try {
                    FileSystemServices.getCurrent().copyFile(racerInfoFile, importArchiveRacerInfoFile);
                }
                catch (IOException ex) {
                    throw new RaceDataIOException((Exception)ex, "Unable to store racer info in import archive directory: " + ex.getMessage());
                }
            } else if (importArchiveRacerInfoFile.exists()) {
                importArchiveRacerInfoFile.delete();
            }
            wssData.racerInfoFile = racerInfoFile;
            wssData.racerInfo = racerInfo;
        }
        if (newResult) {
            this.notifyModelAdded(resultDataFile, aRaceResult);
        } else {
            this.notifyModelChanged(resultDataFile, aRaceResult);
        }
        return resultDataFile;
    }

    public void saveRaceCalendar() throws RaceDataIOException {
        this.saveRaceCalendar(this.getRaceCalendar(), this.getRaceCalendarBackingFile());
    }

    protected void saveRaceCalendar(RaceSeries seriesCalendar, File backingFile) throws RaceDataIOException {
        new RaceSeriesCSVWriter(seriesCalendar).writeFile(backingFile);
    }

    public void saveRacerList(ToolSessionRacerList newRacerList) throws RaceDataIOException {
        File backingFile = this.getRacerListBackingFile();
        newRacerList.sortByBib();
        new RacerListCSVWriter(newRacerList).writeFile(backingFile);
        this.racerList = this.loadRacerList();
        this.notifyModelChanged(backingFile, this.racerList);
    }

    protected void saveSeasonScoringRaces() throws RaceDataIOException {
        this.saveScoringSpecification(this.getSeasonScoringRaces());
        this.notifyModelChanged(this.getSeasonScoringRacesBackingFile(), this.getSeasonScoringRaces());
    }

    public void saveTimingData(RaceIdentifier raceID, String timingData, String preamble) throws IOException {
        String dataLine;
        BufferedReader sourceReader;
        WorkingSetScoringData wssData = this.getWorkingSetScoringData(raceID);
        String fileName = RaceDataIOConstants.FILE_TYPE_TMG.composeFileName(wssData.getRaceFileRootName());
        File timingDataFile = new File(this.getTimingDataImportsDirectory(), fileName);
        FileSystemServices.getCurrent().realizeDirectory(timingDataFile.getParentFile());
        PrintWriter fs = new PrintWriter(new BufferedWriter(new FileWriter(timingDataFile)));
        if (preamble != null) {
            sourceReader = new BufferedReader(new StringReader(preamble));
            while ((dataLine = sourceReader.readLine()) != null) {
                fs.println(dataLine);
            }
            sourceReader.close();
            fs.println();
            fs.flush();
        }
        sourceReader = new BufferedReader(new StringReader(timingData));
        while ((dataLine = sourceReader.readLine()) != null) {
            boolean includeThisLine = true;
            if (!includeThisLine) continue;
            fs.println(dataLine);
        }
        sourceReader.close();
        fs.close();
    }

    public void saveToolOption(ToolID toolID, String option, String value) {
        this.setToolOption(toolID, option, value);
        try {
            WorkingSetSettings.getCurrent().saveSettings();
        }
        catch (IOException ex) {
            DebugSupport.current().dump("Unable to save working set settings with " + toolID.name + "-" + option + " value");
            DebugSupport.current().dumpStack(ex);
        }
    }

    public void setToolOption(ToolID toolID, String option, String value) {
        WorkingSetSettings.getCurrent().setToolOption(toolID, option, value);
    }

    public void updateRacerListManagementPolicy(RacerListManagementPolicy managementPolicy) {
        this.getRacerList().setManagementPolicy(managementPolicy);
        for (Object appModel : ToolServices.getCurrent().getOpenTools(RacerListManager.class)) {
            ((RacerListManager)appModel).updateManagementPolicy(managementPolicy.copy());
        }
    }

    public void updateSeriesRaceClass(Class<? extends RaceClass<?>> newSeriesRaceClassClass) throws RaceDataIOException {
        this.getRaceCalendar().setRaceClassClass(newSeriesRaceClassClass);
        this.saveRaceCalendar();
        this.getRacerList().setAgeClassClass(newSeriesRaceClassClass);
        this.saveRacerList(this.getRacerList());
        if (this.allowsSeasonScoring()) {
            SeriesScoringSpecification seasonScoringSpec = this.getSeasonScoringRaces().getSpecification();
            seasonScoringSpec.setAgeClassClass(newSeriesRaceClassClass);
            this.saveSeasonScoringRaces();
        }
    }

    public void updateSeriesScoringType(WorldCupPointsType newScoringType) throws RaceDataIOException {
        this.getRaceCalendar().setWorldCupPointsType(newScoringType);
        this.saveRaceCalendar();
        if (this.allowsSeasonScoring()) {
            SeriesScoringSpecification seasonScoringSpec = this.getSeasonScoringRaces().getSpecification();
            seasonScoringSpec.setWorldCupPointsType(newScoringType);
            this.saveSeasonScoringRaces();
        }
    }

    public File validateReportsDirectory(File aDirectory) throws RaceDataIOException {
        File reportsDirectory = aDirectory;
        try {
            if (!reportsDirectory.exists()) {
                reportsDirectory = FileSystemServices.getCurrent().realizeDirectory(reportsDirectory);
            }
            File systemStylesDirectory = new File(this.getSystemDirectory(), SYSTEM_STYLES_DIRECTORY_NAME);
            File[] standardStyleSheets = systemStylesDirectory.listFiles(STYLE_SHEET_FILTER);
            for (int i = 0; i < standardStyleSheets.length; ++i) {
                File systemStylesheetFile = standardStyleSheets[i];
                File rdStyleSheetFile = new File(reportsDirectory, systemStylesheetFile.getName());
                if (rdStyleSheetFile.exists()) continue;
                FileSystemServices.getCurrent().copyFile(systemStylesheetFile, reportsDirectory);
            }
        }
        catch (IOException ex) {
            throw new RaceDataIOException(ex);
        }
        return reportsDirectory;
    }

    public static void main(String[] args) {
        List<String> argList = RaceScoringSessionManager.processCommandLineArgs(args);
        try {
            RaceScoringSessionManager.initiateSession();
        }
        catch (Exception ex) {
            System.err.println("***ERROR: Unable to initiate session: " + ex.getMessage());
            DebugSupport.printStackTrace(ex, 10);
        }
        for (String arg : argList) {
            RaceScoringSessionManager.launchTool(arg);
        }
        if (argList.size() == 0) {
            current.closeSplashScreen();
            System.out.println("\nStarted RaceScoringSessionManager:");
            System.out.println("toolInstallationDirectory: " + ToolSessionManager.toolInstallationDirectory.getAbsolutePath());
            System.out.println("userDataDirectory: " + SessionRootSettings.current.getUserDataDirectory().getAbsolutePath());
            System.out.println("currentWorkingSetDirectory: " + current.getWorkingSetDirectory().getAbsolutePath());
            try {
                System.out.println("race calendar: " + current.getRaceCalendar().getName() + " (" + current.getRaceCalendar().size() + " races)");
            }
            catch (Exception ex) {
                System.err.println("***ERROR: Unable to load race calendar: " + ex.getMessage());
                DebugSupport.printStackTrace(ex, 10);
            }
            try {
                System.out.println("racers list size: " + current.getRacerList().size());
            }
            catch (Exception ex) {
                System.err.println("***ERROR: Unable to load season racer list: " + ex.getMessage());
                DebugSupport.printStackTrace(ex, 10);
            }
            SessionManager.current.shutdown();
        }
    }

    static {
        THIS_CLASS = RaceScoringSessionManager.class;
        USE_SINGLE_REPORTS_DIRECTORY = true;
        USE_COMBINED_SERIES_REPORTS_DIRECTORY = true;
        RACE_REPORTS_DIRECTORY_NAME = USE_SINGLE_REPORTS_DIRECTORY ? REPORTS_DIRECTORY_NAME : "Reports/Race";
        SERIES_REPORTS_DIRECTORY_NAME = USE_SINGLE_REPORTS_DIRECTORY ? REPORTS_DIRECTORY_NAME : "Reports/Series";
        SEASON_REPORTS_DIRECTORY_NAME = USE_SINGLE_REPORTS_DIRECTORY ? REPORTS_DIRECTORY_NAME : "Reports/Season";
        EVENT_REPORTS_DIRECTORY_NAME = USE_SINGLE_REPORTS_DIRECTORY ? REPORTS_DIRECTORY_NAME : "Reports/Event";
        RACE_CALENDAR_DATA_FILE_NAME = RaceDataIOConstants.FILE_TYPE_CSV.composeFileName("RaceCalendar");
        SERIES_RACERS_FILE_NAME = RaceDataIOConstants.FILE_TYPE_CSV.composeFileName("RacerList");
        SEASON_SCORING_RACES_DATA_FILE_NAME = SeasonScoringSpecification.composeFileName(SEASON_SCORING_RACES_SHORT_NAME);
        SYNONYM_SPECIFICATIONS_FILE_NAME = RaceDataIOConstants.FILE_TYPE_CFG.composeFileName("SynonymSpecifications");
        STYLE_SHEET_FILTER = new FileFilter(){

            @Override
            public boolean accept(File aFile) {
                return RaceDataIOConstants.FILE_TYPE_CSS.sameExtension(aFile);
            }
        };
        ToolSessionManager.setSessionRootSettingsFileName(ACESRootSettings.FILE_NAME);
    }
}

