/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.foundation.models;

import java.util.List;
import org.ussamasters.aces.racedata.models.RaceIdentifier;
import org.ussamasters.aces.racedata.models.RaceResult;
import org.ussamasters.aces.racedata.models.RaceSeries;
import org.ussamasters.aces.racedata.models.SeasonIdentifier;
import org.ussamasters.aces.tools.foundation.models.SeriesScoringSpecification;

public class ScoringRaceSeries
extends RaceSeries {
    protected SeriesScoringSpecification scoringSpecification;

    public ScoringRaceSeries(SeriesScoringSpecification scoringSpecification, SeasonIdentifier season) {
        super(scoringSpecification.getName(), season, scoringSpecification.getAgeClassClass(), scoringSpecification.getWorldCupPointsType(), scoringSpecification.getRaces());
        this.scoringSpecification = scoringSpecification;
    }

    @Override
    protected void addRaceEntry(RaceIdentifier raceID) {
        super.addRaceEntry(raceID);
        this.getSpecification().addRace(raceID);
    }

    public String getDescription() {
        return this.getSpecification().getDescription();
    }

    public String getShortName() {
        return this.getSpecification().getShortName();
    }

    public List<String> getRaceSpecifications() {
        return this.getSpecification().getRaceSpecifications();
    }

    public SeriesScoringSpecification getSpecification() {
        return this.scoringSpecification;
    }

    @Override
    public void remove(RaceIdentifier raceID) {
        super.remove(raceID);
        this.getSpecification().removeRace(raceID);
    }

    public void setDescription(String description) {
        this.getSpecification().setDescription(description);
    }

    @Override
    protected void validateSetRace(int index, RaceResult raceResult) {
        RaceIdentifier raceId = this.getSpecification().getRace(index);
        if (!raceId.equals(raceResult.getRaceId())) {
            throw new IllegalArgumentException("Cannot install race series entry for " + raceId + " with results from " + raceResult.getRaceId());
        }
    }
}

