/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.foundation.models;

import java.io.File;
import java.io.IOException;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.SeasonIdentifier;
import org.ussamasters.aces.racedata.models.WorldCupPointsType;
import org.ussamasters.aces.tools.foundation.models.SeriesScoringSpecification;

public class SeasonScoringSpecification
extends SeriesScoringSpecification {
    public static final String STANDARD_FILE_NAME_PREFIX = "Season-";
    private static final String SETTING_SEASON_START_YEAR = "seasonStart";
    public static final int UNKNOWN_YEAR = -1;

    public static String composeFileName(String shortName) {
        return FILE_TYPE.composeFileName(STANDARD_FILE_NAME_PREFIX + shortName);
    }

    public static SeasonScoringSpecification createSpecification(String eventName, String shortName, SeasonIdentifier season, Class<? extends RaceClass<?>> ageClassClass, WorldCupPointsType scoringType) {
        return new SeasonScoringSpecification(eventName, shortName, season, ageClassClass, scoringType);
    }

    public static synchronized SeasonScoringSpecification load(File configSettingsFile, SeasonIdentifier season) throws IOException {
        return new SeasonScoringSpecification(configSettingsFile, season);
    }

    public static SeasonScoringSpecification loadFromDirectory(File aDirectory, String configSettingsFileName, SeasonIdentifier season) throws IOException {
        return SeasonScoringSpecification.load(new File(aDirectory, configSettingsFileName), season);
    }

    protected SeasonScoringSpecification(File backingFile, SeasonIdentifier season) throws IOException {
        super(backingFile, season);
        this.upgradeSeasonRepresentation();
    }

    protected SeasonScoringSpecification(String name, String shortName, SeasonIdentifier season, Class<? extends RaceClass<?>> ageClassClass, WorldCupPointsType scoringType) {
        super(SeasonScoringSpecification.createSettings(null), name, shortName, season, ageClassClass, scoringType);
        this.upgradeSeasonRepresentation();
    }

    @Override
    protected String fileNamePrefix() {
        return STANDARD_FILE_NAME_PREFIX;
    }

    private void upgradeSeasonRepresentation() {
        if (this.getSettings().containsSetting(SETTING_SEASON_START_YEAR)) {
            int seasonStartYear = this.getSettings().getIntValue(SETTING_SEASON_START_YEAR);
            if (seasonStartYear != this.getSeason().startYear) {
                throw new IllegalStateException(String.format("Inconsistent upgrade state for season scoring: %s had seasonStartYear=%04d but season=%s", this.getName(), seasonStartYear, this.getSeason().toSeasonYearsString()));
            }
            this.getSettings().removeValue(SETTING_SEASON_START_YEAR);
        }
    }
}

