/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.foundation.processors;

import com.glaivestone.javax.devx.Assert;
import com.glaivestone.javax.devx.DebugSupport;
import com.glaivestone.toolbox.settings.SettingsFileHolder;
import com.glaivestone.toolbox.settings.SettingsSection;
import java.io.File;
import org.ussamasters.aces.tools.foundation.processors.ConfigurationSettingsProcessor;

public class DebugConfigurationSettingsProcessor
extends ConfigurationSettingsProcessor {
    public static final String SECTION_NAME = "Debug";

    public DebugConfigurationSettingsProcessor(SettingsSection settings, SettingsFileHolder fileHolder) {
        super(settings, fileHolder);
    }

    public DebugConfigurationSettingsProcessor(SettingsFileHolder fileHolder) {
        this(fileHolder.getOptionalSection(SECTION_NAME), fileHolder);
    }

    public void processConfigurationSettings() {
        if (!DebugSupport.debugEnabled) {
            this.processDebugEnabledSetting();
            if (!DebugSupport.debugEnabled) {
                return;
            }
            this.processSessionControlOptions();
            this.processDebugControlOptions();
        } else {
            this.processSessionOptions();
        }
        this.processClassLoadList();
        this.processInitActions();
    }

    protected void processDebugControlOptions() {
    }

    protected void processDebugEnabledSetting() {
        boolean enableDebug = this.getSettings().getBooleanValue("debugEnabled", false);
        if (enableDebug) {
            DebugSupport.debugEnabled = true;
            Assert.exitSystemOnAssertionFailure = false;
        }
    }

    public static void processConfigurationSettings(SettingsFileHolder fileHolder) {
        new DebugConfigurationSettingsProcessor(fileHolder).processConfigurationSettings();
    }

    public static void processConfigurationSettings(SettingsFileHolder fileHolder, File logFileDirectory) {
        DebugConfigurationSettingsProcessor settingsProcessor = new DebugConfigurationSettingsProcessor(fileHolder);
        settingsProcessor.setLogFileDirectory(logFileDirectory);
        settingsProcessor.processConfigurationSettings();
    }
}

