/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.foundation.settings;

import com.glaivestone.javax.devx.Assert;
import com.glaivestone.javax.execution.SessionManager;
import com.glaivestone.toolbox.settings.StandardSettingsFileHolder;
import java.io.File;
import java.io.IOException;

public class ToolConfigurationSettings
extends StandardSettingsFileHolder {
    public static ToolConfigurationSettings current = null;
    public static final String NAME = "ToolConfigurationSettings";
    public static final String FILE_NAME = FILE_TYPE.composeFileName("ToolConfigurationSettings");
    public static final String DEFAULTS_SUBDIRECTORY_NAME = "Defaults";
    public static final String PROPERTY_PRODUCT_NAME = "productName";
    public static final String PROPERTY_PRODUCT_VERSION = "productVersion";
    public static final String PROPERTY_PRODUCT_SUPPORT_URL = "productSupportURL";
    public static final String SECTION_TOOLS = "Tools";
    public static final String PROPERTY_TOOL_CLASS = "toolClass";
    public static final String PROPERTY_TOOL_DISPLAY_NAME = "displayName";
    public static final String PROPERTY_TOOL_ICON = "toolIcon";
    public static final String PROPERTY_TOOL_INSTALL_METHOD = "installMethod";
    public static final String PROPERTY_TOOL_OPEN_METHOD = "openMethod";
    public static final String DEFAULT_TOOL_OPEN_METHOD = "open";
    public static final String PROPERTY_LAF = "lookAndFeel";
    public static final String PROPERTY_SPLASH_SCREEN = "splashScreen";
    public static final String PROPERTY_DEFAULT_TOOL_ICON = "defaultToolIcon";
    public static final String LAF_CROSS_PLATFORM = "crossPlatform";
    public static final String LAF_HOST_SYSTEM = "hostSystem";
    protected File defaultsSubdirectory;

    public static ToolConfigurationSettings getCurrent() {
        return current;
    }

    public static File getDefaultsSubdirectory(File aDirectory) {
        return new File(aDirectory, DEFAULTS_SUBDIRECTORY_NAME);
    }

    public static synchronized void loadCurrent(File aDirectory) {
        ToolConfigurationSettings.loadCurrent(aDirectory, FILE_NAME);
    }

    public static synchronized void loadCurrent(File aDirectory, String configSettingsFileName) {
        if (!new File(aDirectory, configSettingsFileName).exists()) {
            System.err.println("***FATAL INSTALLATION ERROR: no tool installation settings file " + configSettingsFileName + " found in " + aDirectory.getAbsolutePath() + ".");
            SessionManager.current.shutdown();
        }
        try {
            current = ToolConfigurationSettings.loadFromDirectory(aDirectory, configSettingsFileName);
        }
        catch (IOException ex) {
            System.err.println("***FATAL INSTALLATION ERROR: unable to load tool settings file " + configSettingsFileName + " in " + aDirectory.getAbsolutePath() + ".");
            System.err.println(ex);
            SessionManager.current.shutdown();
        }
    }

    public static synchronized ToolConfigurationSettings loadFromDirectory(File aDirectory, String configSettingsFileName) throws IOException {
        if (aDirectory == null || !aDirectory.isDirectory()) {
            Assert.shouldNotBe();
            return null;
        }
        return new ToolConfigurationSettings(new File(aDirectory, configSettingsFileName));
    }

    public ToolConfigurationSettings(File backingFile) throws IOException {
        super(backingFile);
    }

    public File getDefaultsSubdirectory() {
        if (this.defaultsSubdirectory == null && this.getFile() != null) {
            this.defaultsSubdirectory = ToolConfigurationSettings.getDefaultsSubdirectory(this.getDirectory());
        }
        return this.defaultsSubdirectory;
    }

    public String getProductName() {
        return this.getStringValueOrNull(PROPERTY_PRODUCT_NAME);
    }

    public String getProductSupportHref() {
        return this.getStringValueOrNull(PROPERTY_PRODUCT_SUPPORT_URL);
    }

    public String getProductVersion() {
        return this.getStringValueOrNull(PROPERTY_PRODUCT_VERSION);
    }

    @Override
    public void setFile(File aFile) {
        super.setFile(aFile);
        this.defaultsSubdirectory = null;
    }
}

