/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.foundation.settings;

import java.io.File;
import java.io.IOException;
import org.ussamasters.aces.tools.foundation.settings.DeveloperSettings;
import org.ussamasters.aces.tools.foundation.settings.ToolSessionSettings;

public class ToolDeveloperSettings
extends DeveloperSettings {
    public static ToolDeveloperSettings current = null;
    public static final String NAME = "ToolDeveloperSettings";
    public static final String FILE_NAME = FILE_TYPE.composeFileName("ToolDeveloperSettings");
    protected static final String STARTUP_DIR_ADJUSTMENT = "..\\USSARaceScoring\\FWM\\Tools";

    public ToolDeveloperSettings(File backingFile) throws IOException {
        super(backingFile);
    }

    @Override
    protected void initializeInstallationDirectory(File startupDirectory, File prototypesDirectory) {
        super.initializeInstallationDirectory(startupDirectory, prototypesDirectory);
        this.initDocsDirectory(startupDirectory, prototypesDirectory);
    }

    protected void initDocsDirectory(File startupDirectory, File prototypesDirectory) {
        File docsSourceDir = new File(prototypesDirectory, "Doc");
        String defaultDocsInstallationDirName = "Doc";
        File docsDir = new File(startupDirectory, defaultDocsInstallationDirName);
        this.ensureDirectoryExists(docsDir);
        this.copyFiles(docsDir, docsSourceDir);
    }

    @Override
    protected void initRootInstallationDirectory(File rootDirectory, File rootPrototypesDirectory) {
        this.copyFiles(rootDirectory, rootPrototypesDirectory);
    }

    @Override
    protected void initSystemConfigFiles(File rootDirectory, File rootPrototypesDirectory) {
    }

    @Override
    protected boolean shouldInitializeInstallationDirectory(File startupDirectory) {
        return !ToolSessionSettings.isToolSessionDirectory(startupDirectory, ToolSessionSettings.FILE_NAME);
    }

    public static void loadCurrent(File aDirectory) {
        ToolDeveloperSettings.loadCurrent(aDirectory, FILE_NAME);
    }

    public static void loadCurrent(File aDirectory, String configSettingsFileName) {
        if (!ToolDeveloperSettings.isDeveloperConfiguration(aDirectory, configSettingsFileName)) {
            return;
        }
        File startupDirectory = ToolDeveloperSettings.adjustStartupDirectory(aDirectory, STARTUP_DIR_ADJUSTMENT);
        File settingsFile = new File(startupDirectory, configSettingsFileName);
        try {
            current = new ToolDeveloperSettings(settingsFile);
        }
        catch (IOException ex) {
            System.err.println("CONFIGURATION ERROR: unable to load developer settings file " + configSettingsFileName + " from " + aDirectory.getAbsolutePath());
            System.err.println(ex);
        }
    }
}

