/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui;

import com.glaivestone.javax.swing.PlainTextDocument;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.ussamasters.aces.racedata.models.RaceClassType;
import org.ussamasters.aces.racedata.models.SeasonConfiguration;
import org.ussamasters.aces.racedata.models.SeasonIdentifier;
import org.ussamasters.aces.tools.foundation.processors.ValidationResolver;
import org.ussamasters.aces.tools.foundation.processors.ValidationResult;
import org.ussamasters.aces.tools.foundation.settings.WorkingSetSettings;
import org.ussamasters.aces.tools.ui.WorkingSetSettingsEditor;

public class NewWorkingSetDialog
extends WorkingSetSettingsEditor {
    public static final String PROPERTY_RACE_SERIES_NAME = "raceSeriesName";
    public static final String PROPERTY_RACE_SERIES_DIRECTORY_NAME = "raceSeriesDirectoryName";
    public static final String PROPERTY_SEASON_YEAR = "raceSeriesSeasonYear";
    public static final String PROPERTY_SERIES_RACE_CLASS_CLASSES = "raceClassClasses";
    private static final String DIALOG_TITLE = "New Race Series";
    protected File newWorkingSetDirectory;
    protected WorkingSetSettings newWorkingSetSettings;
    protected PlainTextDocument seriesDirectoryNameHolder;
    protected PlainTextDocument seriesNameHolder;

    public static File openFor(Window aWindow) {
        NewWorkingSetDialog aDialog = new NewWorkingSetDialog(aWindow);
        aDialog.openWindow();
        return aDialog.getNewWorkingSetDirectory();
    }

    public NewWorkingSetDialog(Window aWindow) {
        super(aWindow);
        this.initializeModels();
    }

    public void acceptChanges() throws IOException {
        SeasonIdentifier season = SeasonIdentifier.forSeason(this.seasonYearHolder.getValue());
        this.newWorkingSetSettings.setDescription(this.getSeriesName());
        this.newWorkingSetSettings.setOrganizer(this.getSelectedSeriesOganizer());
        this.newWorkingSetSettings.setRaceClassClass(this.getSelectedSeriesRaceClass(season));
        this.newWorkingSetSettings.setWorldCupPointsType(this.getSelectedWorldCupPoints());
        this.newWorkingSetSettings.setStandardCourseArrangement(this.getSelectedCourseArrangement());
        this.newWorkingSetSettings.setType(this.getSelectedSeriesType());
        this.newWorkingSetSettings.setSeason(season);
        File wsDirectory = this.getProposedWorkingSetDirectory();
        this.getSessionManager().createNewWorkingSet(this.newWorkingSetSettings, wsDirectory);
        this.newWorkingSetDirectory = wsDirectory;
    }

    @Override
    public void clearResult() {
        this.newWorkingSetDirectory = null;
    }

    public File getNewWorkingSetDirectory() {
        return this.newWorkingSetDirectory;
    }

    protected File getProposedWorkingSetDirectory() {
        return new File(this.getSessionManager().getUserDataDirectory(), this.getSeriesDirectoryName());
    }

    protected String getSeriesDirectoryName() {
        return this.getSeriesDirectoryNameHolder().getText().trim();
    }

    public PlainTextDocument getSeriesDirectoryNameHolder() {
        return this.seriesDirectoryNameHolder;
    }

    protected String getSeriesName() {
        return this.getSeriesNameHolder().getText().trim();
    }

    public PlainTextDocument getSeriesNameHolder() {
        return this.seriesNameHolder;
    }

    public String getTitle() {
        return DIALOG_TITLE;
    }

    @Override
    protected void initialize() {
        super.initialize();
        try {
            this.newWorkingSetSettings = this.getSessionManager().getDefaultWorkingSetSettings();
        }
        catch (IOException ex) {
            throw new IllegalStateException("Unable to load default working set settings from tool installation defaults directory");
        }
    }

    protected void initializeModels() {
        this.seriesDirectoryNameHolder = new PlainTextDocument("NewRaceSeries");
        this.seriesNameHolder = new PlainTextDocument(DIALOG_TITLE);
        this.initRaceSeriesSettingsModels(this.newWorkingSetSettings);
    }

    public ValidationResult validateChanges(ValidationResolver validationResolver) {
        ValidationResult validationResult = new ValidationResult();
        String seriesName = this.getSeriesName();
        String directoryName = this.getSeriesDirectoryName();
        List<WorkingSetSettings> wsSettingsList = this.getSessionManager().getAvailableWorkingSets();
        for (WorkingSetSettings wsSettings : wsSettingsList) {
            if (seriesName.equalsIgnoreCase(wsSettings.getDescription().trim())) {
                validationResult.reportProblem(PROPERTY_RACE_SERIES_NAME, "The race series name you have requested is already in use");
                return validationResult;
            }
            if (!directoryName.equalsIgnoreCase(wsSettings.getDirectory().getName())) continue;
            validationResult.reportProblem(PROPERTY_RACE_SERIES_DIRECTORY_NAME, "The race series directory you have requested is already in use");
            return validationResult;
        }
        if (this.getProposedWorkingSetDirectory().exists()) {
            validationResult.reportProblem(PROPERTY_RACE_SERIES_DIRECTORY_NAME, "The race series directory you have requested already exists.");
            return validationResult;
        }
        String invalidChar = this.validateFileNameComponent(directoryName);
        if (invalidChar != null) {
            validationResult.reportProblem(PROPERTY_RACE_SERIES_DIRECTORY_NAME, "The directory name you have specified for storing the series data is not valid - please remove the special character '" + invalidChar + "' (may cause problems when used in report file names).");
            return validationResult;
        }
        int seasonYear = this.seasonYearHolder.getValue();
        int currentSeasonYear = this.newWorkingSetSettings.getSeason().getSeasonYear();
        String propertyName = PROPERTY_SEASON_YEAR;
        if (seasonYear <= 0) {
            validationResult.reportProblem(propertyName, "The race series season year you have defined is not a valid year number.");
            return validationResult;
        }
        if (!(seasonYear >= currentSeasonYear - 10 && seasonYear <= currentSeasonYear + 10 || validationResolver.confirm(propertyName, "The season year you have specified is pretty far out.\n\n\nAre you sure this is what you meant?"))) {
            validationResult.reportProblem(propertyName, "The race series start year you have defined is fishy.");
            return validationResult;
        }
        SeasonIdentifier season = SeasonIdentifier.forSeason(seasonYear);
        if (season == null) {
            validationResult.reportProblem(propertyName, "The season year you have specified is not a recognized season.");
            return validationResult;
        }
        propertyName = PROPERTY_SERIES_RACE_CLASS_CLASSES;
        RaceClassType raceClassType = this.getSelectedSeriesRaceClassType();
        List<RaceClassType> supportedRaceClasses = SeasonConfiguration.getSeasonConfig(season).getRaceClassTypes();
        if (!supportedRaceClasses.contains(raceClassType)) {
            validationResult.reportProblem(propertyName, String.format("%ses are not supported for the %s season.", raceClassType.raceClassId, seasonYear));
            return validationResult;
        }
        return ValidationResult.SUCCESS_RESULT;
    }
}

