/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui;

import com.glaivestone.mv.swing.TableHolder;
import com.glaivestone.mv.swing.TableRow;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import org.ussamasters.aces.racedata.models.RaceIdentifier;
import org.ussamasters.aces.racedata.models.RaceSeries;
import org.ussamasters.aces.tools.ui.RaceTableRow;

public class RaceCalendarTableHolder
extends TableHolder {
    protected static final Vector<String> STANDARD_COLUMN_LABELS = RaceTableRow.STANDARD_FIXED_COLUMN_LABELS;
    protected RaceSeries raceSeries;
    protected Vector<RaceTableRow> raceDataRows;

    public RaceCalendarTableHolder(RaceSeries raceSeries) {
        this(raceSeries, STANDARD_COLUMN_LABELS, null);
    }

    public RaceCalendarTableHolder(RaceSeries raceSeries, Vector<String> columnLabels) {
        this(raceSeries, columnLabels, null);
        if (columnLabels.size() != STANDARD_COLUMN_LABELS.size()) {
            throw new IllegalArgumentException("Wrong size column labels");
        }
    }

    protected RaceCalendarTableHolder(RaceSeries raceSeries, Vector<String> columnLabels, Object subclassData) {
        this.setData(raceSeries, columnLabels, subclassData);
    }

    protected void addEntry(Object aValue, int rowIndex) {
        this.getConcreteDataModel().insertRow(rowIndex, (TableRow)aValue);
    }

    public void addRace(RaceIdentifier aRace) {
        this.addRace(aRace, this.raceDataRows.size());
    }

    public void addRace(RaceIdentifier aRace, int rowIndex) {
        RaceTableRow newRow = this.constructRow(aRace);
        this.addEntry(newRow, rowIndex);
        this.selectIndex(rowIndex);
    }

    protected void buildRows() {
        Vector<RaceTableRow> rows = new Vector<RaceTableRow>(this.raceSeries.size());
        this.buildRows(this.raceSeries, rows);
        this.raceDataRows = rows;
    }

    protected void buildRows(RaceSeries aRaceSeries, Vector<RaceTableRow> rows) {
        for (RaceIdentifier aRace : aRaceSeries.getRaces()) {
            rows.add(this.constructRow(aRace));
        }
    }

    protected RaceTableRow constructRow(RaceIdentifier aRace) {
        return new RaceTableRow(aRace);
    }

    public RaceSeries getRaceSeries() {
        return this.raceSeries;
    }

    public RaceIdentifier getSelectedRace() {
        RaceTableRow selectedRow = (RaceTableRow)this.getSelectedValue();
        return selectedRow == null ? null : selectedRow.getRace();
    }

    public List<RaceIdentifier> getSelectedRaces() {
        List<Object> selectedRows = this.getSelectedValues();
        int nRaces = selectedRows.size();
        ArrayList<RaceIdentifier> selectedRaces = new ArrayList<RaceIdentifier>(nRaces);
        for (Object tr : selectedRows) {
            RaceTableRow aRow = (RaceTableRow)tr;
            selectedRaces.add(aRow.getRace());
        }
        return selectedRaces;
    }

    @Override
    public int indexOf(Object aValue) {
        return this.indexOf((RaceIdentifier)aValue);
    }

    public int indexOf(RaceIdentifier aRace) {
        int nRows = this.size();
        Vector<Vector> rows = this.getConcreteDataModel().getDataVector();
        for (int i = 0; i < nRows; ++i) {
            RaceTableRow aRow = (RaceTableRow)rows.elementAt(i);
            if (!aRow.getRace().equals(aRace)) continue;
            return i;
        }
        return -1;
    }

    public void refreshRow(RaceIdentifier aRace) {
        int rowIndex = this.indexOf(aRace);
        if (rowIndex == -1) {
            System.out.println("***Result row not found for " + aRace);
            return;
        }
        ((RaceTableRow)this.getRow(rowIndex)).refresh();
        this.getConcreteDataModel().fireTableRowsUpdated(rowIndex, rowIndex);
    }

    public void removeRace(RaceIdentifier aRace) {
        int rowIndex = this.indexOf(aRace);
        if (rowIndex != -1) {
            this.remove(rowIndex);
        }
    }

    public void selectRace(RaceIdentifier aRace) {
        int rowIndex = this.indexOf(aRace);
        if (rowIndex != -1) {
            this.selectIndex(rowIndex);
        }
    }

    public void setData(RaceSeries aRaceSeries) {
        if (this.raceSeries == null) {
            throw new IllegalStateException("Column labels must be provided for initializing new table data");
        }
        this.clear();
        this.raceSeries = aRaceSeries;
        this.buildRows(aRaceSeries, this.raceDataRows);
        this.getConcreteDataModel().newRowsAdded(new TableModelEvent(this.getDataModel(), 0, this.raceDataRows.size() - 1, -1, 1));
    }

    protected void setData(RaceSeries raceSeries, Vector<String> columnLabels) {
        this.raceSeries = raceSeries;
        this.buildRows();
        this.getConcreteDataModel().setDataVector(this.raceDataRows, columnLabels);
    }

    public void setData(RaceSeries raceSeries, Vector<String> columnLabels, Object subclassData) {
        if (subclassData != null) {
            throw new UnsupportedOperationException("Subclass responsibility");
        }
        this.setData(raceSeries, columnLabels);
    }
}

