/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui;

import java.util.ArrayList;
import java.util.List;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceEntryResult;
import org.ussamasters.aces.racedata.models.RaceResult;
import org.ussamasters.aces.racedata.models.Racer;
import org.ussamasters.aces.racedata.models.RacerList;
import org.ussamasters.aces.racedata.models.RacerResult;
import org.ussamasters.aces.racedata.models.USSALicense;
import org.ussamasters.aces.tools.foundation.models.ToolSessionRacerList;
import org.ussamasters.aces.tools.ui.RacerListReconciliationResult;

public class RaceResultBibMappingReconciliationResult
extends RacerListReconciliationResult {
    private RaceResult raceResult;
    protected RacerList raceCompetitorsList;
    private List<RacerResult> inconsistentBibRacers;

    public static RaceResultBibMappingReconciliationResult reconcileCompetitors(RaceResult raceResult, RacerList raceCompetitorsList, ToolSessionRacerList racerList) {
        RaceResultBibMappingReconciliationResult reconciliationResult = new RaceResultBibMappingReconciliationResult(raceResult, raceCompetitorsList, racerList);
        reconciliationResult.reconcileCompetitors();
        return reconciliationResult;
    }

    public RaceResultBibMappingReconciliationResult(RaceResult raceResult, RacerList raceCompetitorsList, ToolSessionRacerList racerList) {
        super(racerList);
        this.raceResult = raceResult;
        this.raceCompetitorsList = raceCompetitorsList;
        this.initCompetitorProcessingParms();
    }

    public List<RacerResult> getInconsistentBibRacers() {
        return this.inconsistentBibRacers;
    }

    protected void initCompetitorProcessingParms() {
        Class<? extends RaceClass<?>> raceClassClass = this.raceResult.getRaceClassClass();
        this.initAbilityGroupReferences(raceClassClass);
    }

    @Override
    protected void initReconciliationInfo() {
        super.initReconciliationInfo();
        this.inconsistentBibRacers = new ArrayList<RacerResult>();
    }

    protected boolean isDefiniteMatch(Racer registeredRacer, String lastName, String firstName, RaceClass<?> raceClass, Racer competitorListRacer) {
        if (!this.hasSameName(registeredRacer, lastName, firstName)) {
            return false;
        }
        if (competitorListRacer != null) {
            String registeredLicenseNumber;
            if (registeredRacer.getAgeClass() != competitorListRacer.getAgeClass()) {
                return false;
            }
            String racerLicenseNumber = competitorListRacer.getUSSALicense().toString();
            if (USSALicense.isValid(racerLicenseNumber) && USSALicense.isValid(registeredLicenseNumber = registeredRacer.getUSSALicense().toString())) {
                return racerLicenseNumber.equalsIgnoreCase(registeredLicenseNumber);
            }
            return true;
        }
        if (raceClass.isAgeGroupClass()) {
            return this.hasSuitableAgeClass(registeredRacer, raceClass);
        }
        return false;
    }

    @Override
    protected void processCompetitors() {
        for (RacerResult rr : this.raceResult.getRacerResults()) {
            this.reconcileCompetitor((RaceEntryResult)rr);
        }
    }

    protected void reconcileCompetitor(RaceEntryResult racerResult) {
        int bibNumber = racerResult.getBibNumber();
        String lastName = racerResult.getLastName();
        String firstName = racerResult.getFirstName();
        RaceClass<?> raceClass = racerResult.getRaceClass();
        Racer competitorListRacer = this.raceCompetitorsList != null ? this.raceCompetitorsList.findBib(bibNumber) : null;
        Racer registeredRacer = this.findRacerWithBibNumber(bibNumber);
        if (registeredRacer != null && this.isDefiniteMatch(registeredRacer, lastName, firstName, raceClass, competitorListRacer)) {
            return;
        }
        registeredRacer = this.findRacerWithSameName(lastName, firstName, raceClass);
        if (registeredRacer != null && this.isDefiniteMatch(registeredRacer, lastName, firstName, raceClass, competitorListRacer)) {
            this.recordInconsistentBibRacer(racerResult, registeredRacer);
        }
    }

    protected void recordInconsistentBibRacer(RaceEntryResult racerResult, Racer registeredRacer) {
        this.inconsistentBibRacers.add(racerResult);
        this.recordInconsistentRacer(racerResult, registeredRacer);
    }
}

