/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui;

import com.glaivestone.javax.execution.EvaluableAction;
import com.glaivestone.mv.ApplicationView;
import java.awt.Frame;
import java.io.IOException;
import java.util.List;
import org.ussamasters.aces.racedata.interchange.TimingSystemDataImporter;
import org.ussamasters.aces.racedata.io.RaceDataIOException;
import org.ussamasters.aces.racedata.models.RaceDescriptor;
import org.ussamasters.aces.racedata.models.RaceIdentifier;
import org.ussamasters.aces.racedata.models.RaceResult;
import org.ussamasters.aces.racedata.models.RacerList;
import org.ussamasters.aces.racedata.reports.RaceDataReportServices;
import org.ussamasters.aces.tools.foundation.models.ToolID;
import org.ussamasters.aces.tools.foundation.processors.ValidationResult;
import org.ussamasters.aces.tools.foundation.settings.WorkingSetSettings;
import org.ussamasters.aces.tools.ui.RaceDataTool;
import org.ussamasters.aces.tools.ui.RaceSpecificationModel;
import org.ussamasters.aces.tools.ui.TimingDataImportModel;

public class RaceResultsImportTool
extends RaceDataTool {
    public static final ToolID TOOL_ID = new ToolID("RaceResultsImportTool");
    protected static final String APPLICATION_TITLE = "Load Race Results";
    private static final Class<RaceResultsImportTool> THIS_CLASS = RaceResultsImportTool.class;
    private static final EvaluableAction TOOL_CONSTRUCTION_ACTION = RaceResultsImportTool.constructToolConstructionAction(THIS_CLASS);
    protected boolean enableReportGeneration = true;
    protected RaceDescriptor raceSpecification;
    protected RaceSpecificationModel raceSpecificationModel;
    protected TimingDataImportModel timingDataImportModel;

    public static ApplicationView findOrOpen(RaceIdentifier raceID, boolean generateReports) {
        List<ApplicationView> views = RaceResultsImportTool.getAllViews(TOOL_ID);
        for (ApplicationView aWindow : views) {
            if (!((RaceResultsImportTool)aWindow.getAppModel()).getRaceSpecificationModel().getRace().equals(raceID)) continue;
            Frame frameWindow = (Frame)aWindow.getMainWindow();
            if (frameWindow.getState() == 1) {
                frameWindow.setState(0);
            } else {
                frameWindow.toFront();
            }
            frameWindow.requestFocus();
            return aWindow;
        }
        return RaceResultsImportTool.open(raceID, generateReports);
    }

    public static ApplicationView open() {
        return (ApplicationView)((Object)new RaceResultsImportTool().openWindow());
    }

    public static ApplicationView open(RaceIdentifier raceID, boolean generateReports) {
        RaceResultsImportTool appModel = (RaceResultsImportTool)RaceResultsImportTool.createTool(TOOL_ID, TOOL_CONSTRUCTION_ACTION);
        if (appModel == null) {
            return null;
        }
        appModel.setRace(raceID);
        appModel.enableReportGeneration = generateReports;
        return RaceResultsImportTool.openToolWindow(TOOL_ID, appModel);
    }

    public RaceResultsImportTool() {
        super(TOOL_ID, APPLICATION_TITLE);
    }

    public boolean getEnableReportGeneration() {
        return this.enableReportGeneration;
    }

    public RaceSpecificationModel getRaceSpecificationModel() {
        return this.raceSpecificationModel;
    }

    public TimingDataImportModel getTimingDataImportModel() {
        return this.timingDataImportModel;
    }

    public void importRaceResultsData(boolean generateReports, boolean displayReports) throws IOException, RaceDataIOException {
        TimingSystemDataImporter loader = this.getTimingDataImportModel().importRaceResult(this.raceSpecification);
        RaceResult raceResult = loader.getRaceResult();
        RacerList racerInfo = loader.getCompetitorList();
        this.getSessionManager().saveRaceResultImport(raceResult, racerInfo);
        this.getSessionManager().saveTimingData(this.raceSpecification.getRaceId(), this.getTimingDataImportModel().getTimingData(), this.getTimingDataImportModel().composeTimingDataArchivePreamble());
        if (generateReports) {
            RaceDataReportServices.writeRaceResultsReports(raceResult, racerInfo, RaceDataReportServices.SUPPORTED_REPORT_TYPES, this.getSessionManager().getRaceReportsDirectory(), displayReports);
        }
    }

    @Override
    protected void initializeModels() {
        super.initializeModels();
        this.raceSpecificationModel = new RaceSpecificationModel(RaceSpecificationModel.newRaceSpecification(WorkingSetSettings.getCurrent().getSeason()));
        this.timingDataImportModel = new TimingDataImportModel(this.raceSpecificationModel.getRace().getNumberOfRuns(), this.raceSpecificationModel.getRaceSpecification().getRaceClassClass());
    }

    protected void setRace(RaceIdentifier raceID) {
        this.getRaceSpecificationModel().setRace(raceID);
        this.getRaceSpecificationModel().setIdentificationEditable(false);
    }

    public ValidationResult validateImportRequest() {
        ValidationResult validationResult = new ValidationResult();
        RaceDescriptor aRaceSpecification = this.getRaceSpecificationModel().getRaceSpecification();
        this.timingDataImportModel.validateSpecifications(validationResult);
        if (validationResult.failed()) {
            return validationResult;
        }
        this.raceSpecification = aRaceSpecification;
        return ValidationResult.SUCCESS_RESULT;
    }

    public static void main(String[] args) {
        RaceResultsImportTool.processCommandLineArgs(args);
        RaceResultsImportTool.initiateSession();
        RaceResultsImportTool.open();
    }
}

